/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scdsbuilder;

import com.sun.scdsbuilder.CmdDocument;
import com.sun.scdsbuilder.ConfigInfo;
import com.sun.scdsbuilder.IdentifierDocument;
import com.sun.scdsbuilder.ImagePanel;
import com.sun.scdsbuilder.IntegerDocument;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;

class SCDSBuilder
extends JFrame
implements ActionListener,
Runnable {
    private String[] cmd;
    private ConfigInfo config;
    private boolean isBusy = false;
    private boolean ccFound = true;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem loadItem;
    private JMenuItem exitItem;
    private JMenu editMenu;
    private JMenuItem clearItem;
    private JMenuItem saveItem;
    private JLabel label;
    private JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
    private JTextField tfVendorName;
    private JTextField tfRTName;
    private JTextField tfRTVersion;
    private JTextField tfWorkingDir;
    private JCheckBox cbNetworkAware;
    private ButtonGroup bgType;
    private JRadioButton rbScalable;
    private JRadioButton rbFailover;
    private ButtonGroup bgSourceType;
    private JRadioButton rbC;
    private JRadioButton rbKsh;
    private JRadioButton rbGDS;
    private JRadioButton rbPerl;
    private JTextField tfStartCmd;
    private JTextField tfStartTO;
    private JTextField tfStopCmd;
    private JTextField tfStopTO;
    private JTextField tfProbeCmd;
    private JTextField tfProbeTO;
    private JButton btnSelectInsDir;
    private JButton btnSelectStartCmd;
    private JButton btnSelectStopCmd;
    private JButton btnSelectProbeCmd;
    private JLabel stepLabel;
    private AccessibleRelationSet tfRelSet;
    private AccessibleRelationSet stepLabelRelSet;
    private JButton btnNext;
    private JButton btnPrev;
    private JButton btnCancel;
    private JButton btnExec;
    private JTextArea taOutputLog;
    private JPanel mainPanel;
    private CardLayout card;
    private JPanel topPanel;
    private JPanel createPanel;
    private JPanel configurePanel;
    private ResourceBundle messages;
    private MessageFormat mf = new MessageFormat("");
    private String screenName = "create";

    public SCDSBuilder(String string) {
        File file;
        this.messages = ResourceBundle.getBundle("com.sun.scdsbuilder.MessagesBundle", Locale.getDefault());
        this.setTitle(this.messages.getString("builder"));
        this.getAccessibleContext().setAccessibleDescription(this.messages.getString("builder"));
        this.setBounds(100, 50, 820, 520);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(this.messages.getString("filemenu"));
        this.fileMenu.setMnemonic(this.messages.getString("filemenumnemonic").charAt(0));
        this.menuBar.add(this.fileMenu);
        char c = this.messages.getString("loadrtmnemonic").charAt(0);
        this.loadItem = new JMenuItem(this.messages.getString("loadrt"), c);
        this.loadItem.getAccessibleContext().setAccessibleDescription(this.messages.getString("loadrt"));
        this.fileMenu.add(this.loadItem);
        this.loadItem.addActionListener((ActionListener)this);
        this.fileMenu.addSeparator();
        c = this.messages.getString("exitmnemonic").charAt(0);
        this.exitItem = new JMenuItem(this.messages.getString("exit"), c);
        this.exitItem.getAccessibleContext().setAccessibleDescription(this.messages.getString("exit"));
        this.fileMenu.add(this.exitItem);
        this.exitItem.addActionListener((ActionListener)this);
        this.editMenu = new JMenu(this.messages.getString("editmenu"));
        this.editMenu.setMnemonic(this.messages.getString("editmenumnemonic").charAt(0));
        this.menuBar.add(this.editMenu);
        c = this.messages.getString("clearmnemonic").charAt(0);
        this.clearItem = new JMenuItem(this.messages.getString("clear"), c);
        this.clearItem.getAccessibleContext().setAccessibleDescription(this.messages.getString("clear"));
        this.editMenu.add(this.clearItem);
        this.clearItem.addActionListener((ActionListener)this);
        c = this.messages.getString("savemnemonic").charAt(0);
        this.saveItem = new JMenuItem(this.messages.getString("save"), c);
        this.saveItem.getAccessibleContext().setAccessibleDescription(this.messages.getString("save"));
        this.editMenu.add(this.saveItem);
        this.saveItem.addActionListener((ActionListener)this);
        this.getRootPane().setJMenuBar(this.menuBar);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ImagePanel imagePanel = new ImagePanel("/usr/cluster/lib/scdsbuilder/classes/com/sun/scdsbuilder/solaris.gif");
        imagePanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanel = new JPanel();
        this.card = new CardLayout();
        this.mainPanel.setLayout(this.card);
        this.createPanel = new JPanel();
        this.createPanel.setLayout(new GridBagLayout());
        this.createPanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.label = new JLabel(this.messages.getString("vendor"));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.createPanel, 0, 0, 1, 1);
        this.tfVendorName = new JTextField("", 15);
        this.tfVendorName.setDocument((Document)new IdentifierDocument());
        this.tfVendorName.setToolTipText(this.messages.getString("vendortip"));
        this.tfVendorName.getAccessibleContext().setAccessibleName(this.messages.getString("vendor"));
        this.addgb((Component)this.tfVendorName, gridBagConstraints, (Container)this.createPanel, 0, 1, 1, 1);
        this.tfRelSet = this.tfVendorName.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setDisplayedMnemonic(this.messages.getString("vendormnemonic").charAt(0));
        this.label.setLabelFor(this.tfVendorName);
        this.label = new JLabel(this.messages.getString("rtname"));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.createPanel, 1, 0, 1, 1);
        this.tfRTName = new JTextField("", 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.tfRTName.setDocument((Document)new IdentifierDocument());
        this.tfRTName.setToolTipText(this.messages.getString("rttip"));
        this.tfRTName.getAccessibleContext().setAccessibleName(this.messages.getString("rtname"));
        this.addgb((Component)this.tfRTName, gridBagConstraints, (Container)this.createPanel, 1, 1, 1, 1);
        this.tfRelSet = this.tfRTName.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setDisplayedMnemonic(this.messages.getString("rtmnemonic").charAt(0));
        this.label.setLabelFor(this.tfRTName);
        this.label = new JLabel(this.messages.getString("rtversion"));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.createPanel, 2, 0, 1, 1);
        this.tfRTVersion = new JTextField("", 5);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.tfRTVersion.setToolTipText(this.messages.getString("rtversiontip"));
        this.tfRTVersion.getAccessibleContext().setAccessibleName(this.messages.getString("rtversion"));
        this.tfRTVersion.setText("1.0");
        this.addgb((Component)this.tfRTVersion, gridBagConstraints, (Container)this.createPanel, 2, 1, 1, 1);
        this.tfRelSet = this.tfRTVersion.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setDisplayedMnemonic(this.messages.getString("rtversionmnemonic").charAt(0));
        this.label.setLabelFor(this.tfRTVersion);
        this.label = new JLabel(this.messages.getString("workingdir"));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.createPanel, 0, 2, 1, 1);
        this.tfWorkingDir = new JTextField("", 25);
        this.tfWorkingDir.setText(System.getProperty("user.dir"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.tfWorkingDir.setToolTipText(this.messages.getString("workingdirtip"));
        this.tfWorkingDir.getAccessibleContext().setAccessibleName(this.messages.getString("workingdir"));
        this.addgb((Component)this.tfWorkingDir, gridBagConstraints, (Container)this.createPanel, 0, 3, 2, 1);
        this.tfRelSet = this.tfWorkingDir.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setDisplayedMnemonic(this.messages.getString("workingdirmnemonic").charAt(0));
        this.label.setLabelFor(this.tfWorkingDir);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.btnSelectInsDir = new JButton(this.messages.getString("browse"));
        this.btnSelectInsDir.addActionListener((ActionListener)this);
        this.btnSelectInsDir.setMnemonic(this.messages.getString("browsemnemonic").charAt(0));
        this.btnSelectInsDir.getAccessibleContext().setAccessibleDescription(this.messages.getString("browse"));
        this.addgb((Component)this.btnSelectInsDir, gridBagConstraints, (Container)this.createPanel, 2, 3, 1, 1);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bgType = new ButtonGroup();
        this.rbScalable = new JRadioButton(this.messages.getString("scalable"));
        this.rbScalable.setToolTipText(this.messages.getString("apptypetip"));
        this.bgType.add(this.rbScalable);
        jPanel.add(this.rbScalable);
        this.rbFailover = new JRadioButton(this.messages.getString("failover"));
        this.bgType.add(this.rbFailover);
        this.rbFailover.setToolTipText(this.messages.getString("apptypetip"));
        jPanel.add(this.rbFailover);
        jPanel.setToolTipText(this.messages.getString("apptypetip"));
        this.cbNetworkAware = new JCheckBox(this.messages.getString("networkaware"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.cbNetworkAware.setToolTipText(this.messages.getString("networkawaretip"));
        this.addgb((Component)jPanel, gridBagConstraints, (Container)this.createPanel, 0, 4, 1, 1);
        this.addgb((Component)this.cbNetworkAware, gridBagConstraints, (Container)this.createPanel, 1, 4, 1, 1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.label = new JLabel(this.messages.getString("sourcetype"));
        jPanel2.add(this.label);
        this.bgSourceType = new ButtonGroup();
        this.tfRelSet = jPanel2.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setDisplayedMnemonic(this.messages.getString("sourcetypemnemonic").charAt(0));
        this.label.setLabelFor(jPanel2);
        this.rbC = new JRadioButton(this.messages.getString("c"));
        this.bgSourceType.add(this.rbC);
        jPanel2.add(this.rbC);
        this.rbC.addActionListener((ActionListener)this);
        this.rbC.setToolTipText(this.messages.getString("codetypetip"));
        this.rbKsh = new JRadioButton(this.messages.getString("ksh"));
        this.bgSourceType.add(this.rbKsh);
        jPanel2.add(this.rbKsh);
        this.rbKsh.addActionListener((ActionListener)this);
        this.rbKsh.setToolTipText(this.messages.getString("codetypetip"));
        this.rbGDS = new JRadioButton(this.messages.getString("gds"));
        this.bgSourceType.add(this.rbGDS);
        jPanel2.add(this.rbGDS);
        this.rbGDS.addActionListener((ActionListener)this);
        this.rbGDS.setToolTipText(this.messages.getString("codetypetip"));
        this.addgb((Component)jPanel2, gridBagConstraints, (Container)this.createPanel, 0, 5, 3, 1);
        this.mainPanel.add((Component)this.createPanel, this.messages.getString("create"));
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.configurePanel = new JPanel();
        this.configurePanel.setLayout(new GridBagLayout());
        this.configurePanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("startcommand"));
        this.label.setDisplayedMnemonic(this.messages.getString("startcommandmnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 0, 0, 1, 1);
        this.tfStartCmd = new JTextField("", 30);
        this.tfStartCmd.setDocument((Document)new CmdDocument(this));
        this.tfStartCmd.setToolTipText(this.messages.getString("startcommandtip"));
        this.tfStartCmd.getAccessibleContext().setAccessibleName(this.messages.getString("startcommand"));
        this.addgb((Component)this.tfStartCmd, gridBagConstraints, (Container)this.configurePanel, 0, 1, 1, 1);
        this.tfRelSet = this.tfStartCmd.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfStartCmd);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.btnSelectStartCmd = new JButton(this.messages.getString("browse"));
        this.btnSelectStartCmd.addActionListener((ActionListener)this);
        this.btnSelectStartCmd.setMnemonic(this.messages.getString("browsemnemonic").charAt(0));
        this.btnSelectStartCmd.getAccessibleContext().setAccessibleDescription(this.messages.getString("browse"));
        this.addgb((Component)this.btnSelectStartCmd, gridBagConstraints, (Container)this.configurePanel, 1, 1, 1, 1);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("timeout"));
        this.label.setDisplayedMnemonic(this.messages.getString("starttimemnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 2, 0, 1, 1);
        this.tfStartTO = new JTextField("", 10);
        this.tfStartTO.setDocument((Document)new IntegerDocument());
        this.tfStartTO.setText("300");
        this.tfStartTO.setToolTipText(this.messages.getString("starttimetip"));
        this.tfStartTO.getAccessibleContext().setAccessibleName(this.messages.getString("timeout"));
        this.addgb((Component)this.tfStartTO, gridBagConstraints, (Container)this.configurePanel, 2, 1, 1, 1);
        this.tfRelSet = this.tfStartTO.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfStartTO);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("stopcommand"));
        this.label.setDisplayedMnemonic(this.messages.getString("stopcommandmnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 0, 2, 1, 1);
        this.tfStopCmd = new JTextField("", 30);
        this.tfStopCmd.setDocument((Document)new CmdDocument(this));
        this.tfStopCmd.setToolTipText(this.messages.getString("stopcommandtip"));
        this.tfStopCmd.getAccessibleContext().setAccessibleName(this.messages.getString("stopcommand"));
        this.addgb((Component)this.tfStopCmd, gridBagConstraints, (Container)this.configurePanel, 0, 3, 1, 1);
        this.tfRelSet = this.tfStartCmd.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfStopCmd);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.btnSelectStopCmd = new JButton(this.messages.getString("browse"));
        this.btnSelectStopCmd.setMnemonic(this.messages.getString("browsemnemonic").charAt(0));
        this.btnSelectStopCmd.addActionListener((ActionListener)this);
        this.btnSelectStopCmd.getAccessibleContext().setAccessibleDescription(this.messages.getString("browse"));
        this.addgb((Component)this.btnSelectStopCmd, gridBagConstraints, (Container)this.configurePanel, 1, 3, 1, 1);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("stoptime"));
        this.label.setDisplayedMnemonic(this.messages.getString("stoptimemnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 2, 2, 1, 1);
        this.tfStopTO = new JTextField("", 10);
        this.tfStopTO.setDocument((Document)new IntegerDocument());
        this.tfStopTO.setText("300");
        this.tfStopTO.setToolTipText(this.messages.getString("stoptimetip"));
        this.tfStopTO.getAccessibleContext().setAccessibleName(this.messages.getString("timeout"));
        this.addgb((Component)this.tfStopTO, gridBagConstraints, (Container)this.configurePanel, 2, 3, 1, 1);
        this.tfRelSet = this.tfStopTO.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfStopTO);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("probecommand"));
        this.label.setDisplayedMnemonic(this.messages.getString("probecommandmnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 0, 4, 1, 1);
        this.tfProbeCmd = new JTextField("", 30);
        this.tfProbeCmd.setDocument((Document)new CmdDocument(this));
        this.tfProbeCmd.setToolTipText(this.messages.getString("probecommandtip"));
        this.tfProbeCmd.getAccessibleContext().setAccessibleName(this.messages.getString("probecommand"));
        this.addgb((Component)this.tfProbeCmd, gridBagConstraints, (Container)this.configurePanel, 0, 5, 1, 1);
        this.tfRelSet = this.tfProbeCmd.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfProbeCmd);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.btnSelectProbeCmd = new JButton(this.messages.getString("browse"));
        this.btnSelectProbeCmd.setMnemonic(this.messages.getString("browsemnemonic").charAt(0));
        this.btnSelectProbeCmd.addActionListener((ActionListener)this);
        this.btnSelectProbeCmd.getAccessibleContext().setAccessibleDescription(this.messages.getString("browse"));
        this.addgb((Component)this.btnSelectProbeCmd, gridBagConstraints, (Container)this.configurePanel, 1, 5, 1, 1);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.label = new JLabel(this.messages.getString("probetime"));
        this.label.setDisplayedMnemonic(this.messages.getString("probetimemnemonic").charAt(0));
        this.addgb((Component)this.label, gridBagConstraints, (Container)this.configurePanel, 2, 4, 1, 1);
        this.tfProbeTO = new JTextField("", 10);
        this.tfProbeTO.setDocument((Document)new IntegerDocument());
        this.tfProbeTO.setText("30");
        this.tfProbeTO.setToolTipText(this.messages.getString("probetimetip"));
        this.tfProbeTO.getAccessibleContext().setAccessibleName(this.messages.getString("probetime"));
        this.addgb((Component)this.tfProbeTO, gridBagConstraints, (Container)this.configurePanel, 2, 5, 1, 1);
        this.tfRelSet = this.tfProbeTO.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.label));
        this.label.setLabelFor(this.tfProbeTO);
        this.mainPanel.add((Component)this.configurePanel, this.messages.getString("configure"));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this.stepLabel = new JLabel(this.messages.getString("stepone"));
        this.stepLabel.setDisplayedMnemonic(this.messages.getString("steponemnemonic").charAt(0));
        jPanel3.add(this.stepLabel);
        this.tfRelSet = jPanel3.getAccessibleContext().getAccessibleRelationSet();
        this.tfRelSet.add(new AccessibleRelation(AccessibleRelation.LABELED_BY, this.stepLabel));
        this.stepLabel.setLabelFor(jPanel3);
        this.btnExec = new JButton(this.messages.getString("create"));
        this.btnExec.addActionListener((ActionListener)this);
        this.btnExec.setMnemonic(this.messages.getString("createmnemonic").charAt(0));
        this.btnExec.setToolTipText(this.messages.getString("createtip"));
        jPanel3.add(this.btnExec);
        this.btnPrev = new JButton(this.messages.getString("previous"));
        this.btnPrev.addActionListener((ActionListener)this);
        this.btnPrev.setMnemonic(this.messages.getString("previousmnemonic").charAt(0));
        jPanel3.add(this.btnPrev);
        this.btnPrev.setToolTipText(this.messages.getString("previoustip"));
        this.btnPrev.setEnabled(false);
        this.btnNext = new JButton(this.messages.getString("next"));
        this.btnNext.addActionListener((ActionListener)this);
        this.btnNext.setMnemonic(this.messages.getString("nextmnemonic").charAt(0));
        this.btnNext.setToolTipText(this.messages.getString("nexttip"));
        jPanel3.add(this.btnNext);
        this.btnCancel = new JButton(this.messages.getString("cancel"));
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnCancel.setMnemonic(this.messages.getString("cancelmnemonic").charAt(0));
        this.btnCancel.setToolTipText(this.messages.getString("canceltip"));
        jPanel3.add(this.btnCancel);
        JPanel jPanel4 = new JPanel();
        this.taOutputLog = new JTextArea(5, 60);
        this.taOutputLog.setEditable(false);
        this.taOutputLog.getAccessibleContext().setAccessibleName(this.messages.getString("output"));
        this.taOutputLog.getAccessibleContext().setAccessibleDescription(this.messages.getString("output"));
        JScrollPane jScrollPane = new JScrollPane(this.taOutputLog, 22, 32);
        jPanel4.add(jScrollPane);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.messages.getString("output")));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.addgb((Component)imagePanel, gridBagConstraints, (Container)this.topPanel, 0, 0, 1, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.addgb((Component)this.mainPanel, gridBagConstraints, (Container)this.topPanel, 1, 0, 4, 4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.addgb((Component)jPanel3, gridBagConstraints, (Container)this.topPanel, 1, 4, 4, 1);
        JSplitPane jSplitPane = new JSplitPane(0, this.topPanel, jPanel4);
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)jSplitPane, "Center");
        if (string != null && string.equals("-k")) {
            this.ccFound = false;
        }
        if ((file = new File(System.getProperty("user.dir") + "/rtconfig")).exists()) {
            this.btnNext.setEnabled(true);
            this.btnExec.setEnabled(false);
        } else {
            this.btnNext.setEnabled(false);
            this.btnExec.setEnabled(true);
        }
        this.config = new ConfigInfo(System.getProperty("user.dir"));
        if (!this.ccFound) {
            this.rbC.setSelected(false);
            this.rbC.setEnabled(false);
        }
        this.resetValues();
        this.setVisible(true);
    }

    private void addgb(Component component, GridBagConstraints gridBagConstraints, Container container, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        container.add(component, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnNext) {
            this.card.show(this.mainPanel, this.messages.getString("configure"));
            this.btnExec.setText(this.messages.getString("configure"));
            this.screenName = "configure";
            this.btnNext.setEnabled(false);
            this.btnPrev.setEnabled(true);
            this.stepLabel.setText(this.messages.getString("steptwo"));
            this.btnExec.setToolTipText(this.messages.getString("configuretip"));
            this.btnExec.setEnabled(true);
        } else if (actionEvent.getSource() == this.btnPrev) {
            this.card.show(this.mainPanel, this.messages.getString("create"));
            this.btnExec.setText(this.messages.getString("create"));
            this.screenName = "create";
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(true);
            this.stepLabel.setText(this.messages.getString("stepone"));
            this.btnExec.setToolTipText(this.messages.getString("createtip"));
            this.btnExec.setEnabled(false);
        } else if (actionEvent.getSource() == this.btnSelectInsDir || actionEvent.getSource() == this.btnSelectStartCmd || actionEvent.getSource() == this.btnSelectStopCmd || actionEvent.getSource() == this.btnSelectProbeCmd || actionEvent.getSource() == this.saveItem || actionEvent.getSource() == this.loadItem) {
            this.selectFile((JComponent)actionEvent.getSource());
        } else if (actionEvent.getSource() == this.btnExec) {
            if (this.screenName.equals("create")) {
                this.createRT();
            } else {
                this.configureRT();
            }
        } else if (actionEvent.getSource() == this.btnCancel) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.exitItem && !this.isBusy) {
            System.exit(0);
        } else if (actionEvent.getSource() == this.clearItem) {
            this.taOutputLog.setText("");
        } else if (actionEvent.getSource() == this.rbGDS) {
            this.tfRTVersion.setText("3.1");
        } else if (actionEvent.getSource() == this.rbC || actionEvent.getSource() == this.rbKsh) {
            this.tfRTVersion.setText("1.0");
        }
    }

    private void selectFile(JComponent jComponent) {
        String string = "";
        JTextField jTextField = null;
        int n = 1;
        this.fileChooser.setSelectedFile(null);
        if (jComponent == this.btnSelectStartCmd) {
            string = this.messages.getString("selectstart");
            this.fileChooser.setToolTipText(this.messages.getString("selectstart"));
            jTextField = this.tfStartCmd;
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("selectstart"));
            n = this.fileChooser.showDialog((Component)this, this.messages.getString("select"));
        } else if (jComponent == this.btnSelectStopCmd) {
            string = this.messages.getString("selectstop");
            this.fileChooser.setToolTipText(this.messages.getString("selectstop"));
            jTextField = this.tfStopCmd;
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("selectstop"));
            n = this.fileChooser.showDialog((Component)this, this.messages.getString("select"));
        } else if (jComponent == this.btnSelectProbeCmd) {
            string = this.messages.getString("selectprobe");
            this.fileChooser.setToolTipText(this.messages.getString("selectprobe"));
            jTextField = this.tfProbeCmd;
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("selectprobe"));
            n = this.fileChooser.showDialog((Component)this, this.messages.getString("select"));
        } else if (jComponent == this.btnSelectInsDir) {
            string = this.messages.getString("selectworkingdir");
            this.fileChooser.setToolTipText(this.messages.getString("selectworkingdir"));
            jTextField = this.tfWorkingDir;
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("selectworkingdir"));
            n = this.fileChooser.showOpenDialog((Component)this);
        } else if (jComponent == this.loadItem) {
            string = this.messages.getString("selectloaddir");
            this.fileChooser.setToolTipText(this.messages.getString("selectloaddir"));
            this.fileChooser.setFileSelectionMode(1);
            jTextField = this.tfWorkingDir;
            this.fileChooser.setDialogTitle(string);
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("selectloaddir"));
            this.fileChooser.setApproveButtonMnemonic(this.messages.getString("loadmnemonic").charAt(0));
            n = this.fileChooser.showDialog((Component)this, this.messages.getString("load"));
        } else if (jComponent == this.saveItem) {
            string = this.messages.getString("logfile");
            this.fileChooser.setToolTipText(this.messages.getString("logfile"));
            this.fileChooser.getAccessibleContext().setAccessibleDescription(this.messages.getString("logfile"));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setDialogTitle(string);
            n = this.fileChooser.showSaveDialog((Component)this);
        }
        File file = this.fileChooser.getSelectedFile();
        if (n != 1) {
            if (jComponent == this.saveItem) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(this.taOutputLog.getText());
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                return;
            }
            if (jComponent == this.btnSelectStartCmd || jComponent == this.btnSelectStopCmd || jComponent == this.btnSelectProbeCmd || jComponent == this.btnSelectInsDir) {
                jTextField.setText(file.getPath());
            }
            if (jComponent == this.btnSelectInsDir || jComponent == this.loadItem) {
                File file2 = new File(file.getPath() + "/rtconfig");
                if (file2.exists()) {
                    ConfigInfo configInfo = new ConfigInfo(file.getPath());
                    jTextField.setText(file.getPath());
                    Object[] objectArray = new Object[]{configInfo.RTName};
                    if (configInfo.sourceType.equals("C") && !this.ccFound) {
                        this.mf.applyPattern(this.messages.getString("compilererror"));
                        this.errorMsg(this.mf.format(objectArray));
                        return;
                    }
                    this.config = configInfo;
                    this.btnNext.setEnabled(true);
                    this.btnExec.setEnabled(false);
                    this.resetValues();
                } else if (jComponent == this.loadItem) {
                    this.errorMsg("No Resource Type found in " + file.getPath());
                } else {
                    this.btnNext.setEnabled(false);
                    this.btnExec.setEnabled(true);
                }
            }
        }
    }

    public void errorMsg(String string) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog((Component)this, string, this.messages.getString("error"), 0);
    }

    public void infoMsg(String string) {
        JOptionPane.showMessageDialog((Component)this, string, this.messages.getString("success"), 1);
    }

    private void createRT() {
        int n = 0;
        String string = new String(this.tfVendorName.getText() + this.tfRTName.getText());
        if (string.length() > 32) {
            this.errorMsg(this.messages.getString("namelengtherror"));
            return;
        }
        if (this.tfVendorName.getText() == null || this.tfVendorName.getText().equals("")) {
            this.errorMsg(this.messages.getString("vendorerror"));
            return;
        }
        n += 2;
        if (this.tfRTName.getText() == null || this.tfRTName.getText().equals("")) {
            this.errorMsg(this.messages.getString("rterror"));
            return;
        }
        n += 2;
        if (this.tfRTVersion.getText() == null || this.tfRTVersion.getText().equals("")) {
            this.errorMsg(this.messages.getString("rtversionerror"));
            return;
        }
        n += 2;
        if (this.tfWorkingDir.getText() == null || this.tfWorkingDir.getText().equals("")) {
            this.errorMsg(this.messages.getString("workingdirerror"));
            return;
        }
        n += 2;
        if (this.rbScalable.isSelected()) {
            ++n;
        }
        if (!this.cbNetworkAware.isSelected()) {
            ++n;
        }
        if (this.rbKsh.isSelected()) {
            ++n;
        }
        if (this.rbGDS.isSelected()) {
            ++n;
        }
        this.cmd = new String[n + 1];
        int n2 = 0;
        this.cmd[n2++] = "/usr/cluster/bin/scdscreate";
        this.cmd[n2++] = "-V";
        this.cmd[n2++] = this.tfVendorName.getText();
        this.cmd[n2++] = "-T";
        this.cmd[n2++] = this.tfRTName.getText();
        this.cmd[n2++] = "-n";
        this.cmd[n2++] = this.tfRTVersion.getText();
        this.cmd[n2++] = "-d";
        this.cmd[n2++] = this.tfWorkingDir.getText();
        if (this.rbScalable.isSelected()) {
            this.cmd[n2++] = "-s";
        }
        if (!this.cbNetworkAware.isSelected()) {
            this.cmd[n2++] = "-a";
        }
        if (this.rbKsh.isSelected()) {
            this.cmd[n2++] = "-k";
        } else if (this.rbGDS.isSelected()) {
            this.cmd[n2++] = "-g";
        }
        this.start();
    }

    private void configureRT() {
        int n = 0;
        if (this.tfStartCmd.getText() == null || this.tfStartCmd.getText().equals("")) {
            this.errorMsg(this.messages.getString("startcommanderror"));
            return;
        }
        if (this.tfStartCmd.getText() != null && !this.tfStartCmd.getText().equals("") && this.tfStartCmd.getText().charAt(0) != '/') {
            this.errorMsg(this.messages.getString("startpatherror"));
            return;
        }
        if (this.tfStopCmd.getText() != null && !this.tfStopCmd.getText().equals("") && this.tfStopCmd.getText().charAt(0) != '/') {
            this.errorMsg(this.messages.getString("stoppatherror"));
            return;
        }
        if (this.tfProbeCmd.getText() != null && !this.tfProbeCmd.getText().equals("") && this.tfProbeCmd.getText().charAt(0) != '/') {
            this.errorMsg(this.messages.getString("probepatherror"));
            return;
        }
        n += 2;
        if (this.tfStartTO.getText() != null && !this.tfStartTO.getText().equals("")) {
            n += 2;
        }
        if (this.tfStopCmd.getText() != null && !this.tfStopCmd.getText().equals("")) {
            n += 2;
        }
        if (this.tfStopTO.getText() != null && !this.tfStopTO.getText().equals("")) {
            n += 2;
        }
        if (this.tfProbeCmd.getText() != null && !this.tfProbeCmd.getText().equals("")) {
            n += 2;
        }
        if (this.tfProbeTO.getText() != null && !this.tfProbeTO.getText().equals("")) {
            n += 2;
        }
        if (this.tfWorkingDir.getText() == null || this.tfWorkingDir.getText().equals("")) {
            this.errorMsg(this.messages.getString("Workingdirerror"));
            return;
        }
        this.cmd = new String[(n += 2) + 1];
        int n2 = 0;
        this.cmd[n2++] = "/usr/cluster/bin/scdsconfig";
        this.cmd[n2++] = "-s";
        this.cmd[n2++] = this.tfStartCmd.getText();
        if (this.tfStartTO.getText() != null && !this.tfStartTO.getText().equals("")) {
            this.cmd[n2++] = "-u";
            this.cmd[n2++] = this.tfStartTO.getText();
        }
        if (this.tfStopCmd.getText() != null && !this.tfStopCmd.getText().equals("")) {
            this.cmd[n2++] = "-t";
            this.cmd[n2++] = this.tfStopCmd.getText();
        }
        if (this.tfStopTO.getText() != null && !this.tfStopTO.getText().equals("")) {
            this.cmd[n2++] = "-v";
            this.cmd[n2++] = this.tfStopTO.getText();
        }
        if (this.tfProbeCmd.getText() != null && !this.tfProbeCmd.getText().equals("")) {
            this.cmd[n2++] = "-m";
            this.cmd[n2++] = this.tfProbeCmd.getText();
        }
        if (this.tfProbeTO.getText() != null && !this.tfProbeTO.getText().equals("")) {
            this.cmd[n2++] = "-n";
            this.cmd[n2++] = this.tfProbeTO.getText();
        }
        this.cmd[n2++] = "-d";
        this.cmd[n2++] = this.tfWorkingDir.getText();
        this.start();
    }

    public void start() {
        Thread thread = new Thread((Runnable)this);
        thread.start();
    }

    public void run() {
        this.isBusy = true;
        this.setCursor(new Cursor(3));
        this.topPanel.setEnabled(false);
        try {
            String string;
            Process process = Runtime.getRuntime().exec(this.cmd);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string = bufferedReader.readLine()) != null) {
                this.taOutputLog.append(string + "\n");
            }
            bufferedReader.close();
            if (process.waitFor() != 0) {
                while ((string = bufferedReader2.readLine()) != null) {
                    this.taOutputLog.append(string + "\n");
                }
                bufferedReader2.close();
                if (this.screenName.equals("create")) {
                    Object[] objectArray = new Object[]{this.tfVendorName.getText(), this.tfRTName.getText()};
                    this.mf.applyPattern(this.messages.getString("createerror"));
                    this.errorMsg(this.mf.format(objectArray));
                } else {
                    Object[] objectArray = new Object[]{this.tfVendorName.getText(), this.tfRTName.getText()};
                    this.mf.applyPattern(this.messages.getString("configerror"));
                    this.errorMsg(this.mf.format(objectArray));
                }
            } else if (this.screenName.equals("create")) {
                this.btnExec.setEnabled(false);
                this.btnNext.setEnabled(true);
                Object[] objectArray = new Object[]{this.tfVendorName.getText(), this.tfRTName.getText()};
                this.mf.applyPattern(this.messages.getString("createsuccess"));
                this.infoMsg(this.mf.format(objectArray));
            } else {
                Object[] objectArray = new Object[]{this.tfVendorName.getText(), this.tfRTName.getText(), this.tfWorkingDir.getText(), this.tfVendorName.getText(), this.tfRTName.getText(), "pkg"};
                this.mf.applyPattern(this.messages.getString("configsuccess"));
                this.infoMsg(this.mf.format(objectArray));
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.topPanel.setEnabled(true);
        this.setCursor(new Cursor(0));
        this.isBusy = false;
    }

    private void resetValues() {
        if (this.config.vendorName != null && !this.config.vendorName.equals("")) {
            this.tfVendorName.setText(this.config.vendorName);
        }
        if (this.config.RTName != null && !this.config.RTName.equals("")) {
            this.tfRTName.setText(this.config.RTName);
        }
        if (this.config.RTVersion != null && !this.config.RTVersion.equals("")) {
            this.tfRTVersion.setText(this.config.RTVersion);
        }
        this.rbScalable.setSelected(this.config.scalable);
        this.rbFailover.setSelected(!this.config.scalable);
        if (this.config.sourceType.equals("C")) {
            this.rbC.setSelected(true);
        } else if (this.config.sourceType.equals("KSH")) {
            this.rbKsh.setSelected(true);
        } else {
            this.rbGDS.setSelected(true);
        }
        this.cbNetworkAware.setSelected(this.config.networkAware);
        if (this.config.startCmd != null && !this.config.startCmd.equals("")) {
            this.tfStartCmd.setText(this.config.startCmd);
        }
        if (this.config.startTO != null && !this.config.startTO.equals("")) {
            this.tfStartTO.setText(this.config.startTO);
        }
        if (this.config.stopCmd != null && !this.config.stopCmd.equals("")) {
            this.tfStopCmd.setText(this.config.stopCmd);
        }
        if (this.config.stopTO != null && !this.config.stopTO.equals("")) {
            this.tfStopTO.setText(this.config.stopTO);
        }
        if (this.config.probeCmd != null && !this.config.probeCmd.equals("")) {
            this.tfProbeCmd.setText(this.config.probeCmd);
        }
        if (this.config.probeTO != null && !this.config.probeTO.equals("")) {
            this.tfProbeTO.setText(this.config.probeTO);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            new SCDSBuilder(stringArray[0]);
        } else {
            new SCDSBuilder(null);
        }
    }
}

