#
# PURPOSE
#   This script converts PRIVATE and CONFIDENTIAL events and tasks
#   to PUBLIC.
#
#   It is required during upgrade from 5.0p4 (for example) to 5.1 so
#   that PRIVATE events in 5.0p4 which were visible PUBLICly show as
#   PUBLIC events in 5.1 via UI.
#
# Timing Analysis
#    Wed Jun 26 22:53:29 PDT 2002
#    Calendar foo has been exported to csexportFile.ics
#      number of events=500
#      number of tasks=0
#    Calendar foo has been imported from csimportFile.ics
#      number of events=500
#      number of tasks=0
#    Wed Jun 26 22:53:35 PDT 2002              
#
#   1    calendar  (500 events)       = 6     seconds
#   2000 calendars (1 million events) = 12000 seconds (3 hours and 20 minutes)
#
# Execution
#    To be run in calendar bin directory as root.
#    perl Private2Public.pl

chop($MYNAME=`basename $0`);

#
# ensure DB backup
#
print "Did you backup your database (n)? ";
chop($ANSWER = <STDIN>);
if ("$ANSWER" NE "y") {
  print "$MYNAME: error: database must be backed up.\n";
  exit(1);
}

#
# possibly save exported calendars for future reference
#
print "Do you want to save exported calendars (n)? ";
chop($ANSWER = <STDIN>);
if ("$ANSWER" NE "y") {
  $EXPORTEDCALENDARDIR="";
  print "$MYNAME: message: exported calendars will be deleted.\n";
}
else {
  print "Where is your exported calendar's directory (ExportedCalendarDir)? ";
  chop($ANSWER = <STDIN>);
  if ($ANSWER EQ "") {
    $EXPORTEDCALENDARDIR="ExportedCalendarDir";
  }
  else {
    $EXPORTEDCALENDARDIR=$ANSWER;
  }
  if (! -d $EXPORTEDCALENDARDIR) {
    print "$MYNAME: message: Creating $EXPORTEDCALENDARDIR\n";
    `mkdir $EXPORTEDCALENDARDIR`;
    if ($? NE 0) {
      print "$MYNAME: error: Unable to create $EXPORTEDCALENDARDIR\n";
      exit(1);
    }
  }
}

#
# get calendar IDs
#
`cscal list > cscalListFile`;
open(CSCALLISTFILE, "cscalListFile") || die "Can't find cscalListFile: $!\n";

#
# for each calid 
# 1) export events and todos
# 2) change privacy from PRIVATE/CONFIDENTIAL to PUBLIC
# 3 import it back
#

while($line = <CSCALLISTFILE>) {
  ($tCalid, $rest) = split(/ /, $line);
  $l = length($tCalid);
  $calid = substr($tCalid, 0, $l - 1);
  $calidCopy = $calid;

#
# change sman:test to sman-test, csexport bug!
#
  $calidCopy =~ s/\:/-/g;

  print "\n";
  `csexport -v -c $calid calendar $calidCopy.ics`;
  if ($EXPORTEDCALENDARDIR NE "") {
    `cp $calidCopy.ics $EXPORTEDCALENDARDIR`;
    print "Copying $calidCopy.ics to $EXPORTEDCALENDARDIR\n";
  }
  `sed 's/^CLASS:PRIVATE/CLASS:PUBLIC/;s/^CLASS:CONFIDENTIAL/CLASS:PUBLIC/' < $calidCopy.ics > $calidCopy.importFile.ics`;
  print "Creating $calidCopy.importFile.ics from $calidCopy.ics\n";
  `csimport -v -c $calid calendar $calidCopy.importFile.ics`;
#
# cleanup
#
  `rm -f $calidCopy.importFile.ics`;
}

close(CSCALLISTFILE);
`rm -f cscalListFile`;

print "\nDone.\n";
