#!/bin/sh
# 
# Script to launch java configurator
# Find out where the java package is installed 
# and execute the java configurator.
#
# Command line arguments are tranfered to java command line
# 
# Last revision: $Date: 2005/03/11 03:04:37 $
#

MYNAME=$0

e_ok=0	       # script completed successfully.
e_fatal=1      # script exited on error

Awk="/bin/awk"
Echo="/bin/echo"
Head="/usr/bin/head"
Pwd="/bin/pwd"
Sed="/bin/sed"
Uname="/bin/uname"

Pkgparam="/usr/bin/pkgparam"
Pkginfo="/usr/bin/pkginfo"

Rpm="/bin/rpm"

REQUIRED_JAVA_VERSION="1.4"

#Save the current path
OLD_DIR=`$Pwd`

#Get the OS 
os_name=`$Uname -s`

case $os_name in
  "SunOS")
    #Name of the Calendar package
    CS_PACKAGE_NAME="SUNWics5"
    
    #Get the JAVA BASEDIR from the CSJAVADIR variable in the SUNWics5 pkg
    JAVA_BASEDIR=`$Pkgparam $CS_PACKAGE_NAME CSJAVADIR`
    
    #Get the BASEDIR for SUNWics5
    CS_BASEDIR=`$Pkgparam $CS_PACKAGE_NAME BASEDIR`
    
    #Path to the configure class
    JCONFIGURE_PATH="$CS_BASEDIR/$CS_PACKAGE_NAME/cal/jconfigure"
    ;;
      
  "Linux")
    #Name of the Calendar package
    CS_PACKAGE_NAME="sun-calendar-core"
    
    #Get the BASEDIR for Calendar server
    CS_BASEDIR=`rpm -q --qf "%{INSTALLPREFIX}" $CS_PACKAGE_NAME`
    
    #Path to the configure class
    JCONFIGURE_PATH="$CS_BASEDIR/calendar/jconfigure"
    ;;
  
  *)
    $Echo "OS not supported\n"
    exit $e_fatal
    ;;
esac

if [ "X$JAVA_BASEDIR" = "X" ]; then
  case $os_name in
    "SunOS")
      #If the JAVA BASEDIR has not been provided by the CSJAVADIR variable
      #Then try to get it from the SUNWj5rt or SUNWj3rt package
    
      #Check for JDK 1.5 package
      JAVA_PKG="SUNWj5rt"
      $Pkginfo -q $JAVA_PKG
      if [ $? -eq 0 ]; then
        JAVA_BASEDIR=`$Pkgparam $JAVA_PKG BASEDIR`/jdk/jdk`$Pkgparam $JAVA_PKG SUNW_PRODVERS | $Sed 's/\/.*//g'`
      else
        JAVA_PKG="SUNWj3rt"
        $Pkginfo -q $JAVA_PKG
        if [ $? -eq 0 ]; then
          JAVA_BASEDIR=`$Pkgparam $JAVA_PKG BASEDIR`/j2se
        fi
      fi
    ;;
    
    "Linux")
      for JAVA_PKG in jre jdk j2se j2re ; do
        $Rpm -q $JAVA_PKG > /dev/null
        if [ $? -eq 0 ] ; then
          JAVA_BASEDIR=`$Rpm -q --queryformat "%{DIRNAMES}" $JAVA_PKG | $Sed "s/\/$//g"`
          break
        fi
      done
    ;;
    
    *)
    echo "OS not supported\n"
    exit $e_fatal
    ;;
  esac
fi

#Last resort to find a JDK
if [ -z "$JAVA_BASEDIR" ]; then
  if [ ! -z "$JAVA_HOME" ]; then
    if [ -d $JAVA_HOME ]; then
      JAVA_BASEDIR=$JAVA_HOME
    fi
  fi
fi

#That's it we're outta here
if [ -z "$JAVA_BASEDIR" ]; then
  $Echo "Could not find a valid Sun Java(TM) installation"
  $Echo "Please install the latest J2SE or set the JAVA_HOME environment variable "
  $Echo "to your local J2SE installation directory and restart $MYNAME"
  exit $e_fatal;
fi

#Java command from the JAVA_BASEDIR
JAVA_CMD="bin/java"

#Full path to java runtime
FULL_JAVA_CMD="$JAVA_BASEDIR/$JAVA_CMD"

JAVA_VERSION=`$FULL_JAVA_CMD -version 2>&1 | $Head -1 | $Awk -F'"' ' { print $2 } '`

#Verify that the JDK version is equal or greater than $REQUIRED_JAVA_VERSION 
if [ ! `$Echo $JAVA_VERSION | $Awk -F'.' ' { print $1 $2 } '` -ge `$Echo $REQUIRED_JAVA_VERSION | $Awk -F'.' ' { print $1 $2 } '` ]; then
  $Echo "The version of Java found on your system: $JAVA_VERSION is too old to run the configurator."
  $Echo "The required Java version is $REQUIRED_JAVA_VERSION and above."
  $Echo "Please upgrade to the latest J2SE and try again."
  exit $e_fatal
fi

#Java arguments: classpath
JAVA_ARGS="-cp . -Djava.library.path=."

#Class to run
CONFIGURE_CMD="configure"

#Execute the command
cd $JCONFIGURE_PATH
$Echo $FULL_JAVA_CMD $JAVA_ARGS $CONFIGURE_CMD $@
$FULL_JAVA_CMD $JAVA_ARGS $CONFIGURE_CMD $@
cd $OLD_DIR
