// Login page script
//
// Main code is groped at the bottom
//

// WhiteSpaces conversion function (into '%20') especially for compatibility with Netscape 4.76
function encodeWhiteSpaces(inputString) {
  if (typeof inputString != "string") { return inputString; }
  while( inputString.indexOf(' ')!=-1) {
   inputString=inputString.replace(' ','%20');
  }
  return inputString;
}

// This function tests if a string contains at least a non-whitespace character
function isBlank(inputString) {
  var retValue=true;
  if ( typeof inputString == 'string' && inputString.length ) {
    var i=0;
    var bFoundChar=false;
    do {
      //alert("inputString=["+inputString+"] inputString.charAt("+i+")=["+inputString.charAt(i)+"]");
      if (inputString.charAt(i)!=' ') {
        bFoundChar=true; 
      } 
    } while ( (++i<inputString.length) && (!bFoundChar) )
    retValue=!bFoundChar;
  } 
  return retValue;
}

// Argument parsing function
//   used in case of redirection to login page (Error,logout)
function getArgs() {
  if (!location.search) return null
  var args;
  var query = location.search.substring(1);
  var pairs = query.split("&");
  for(var i = 0; i < pairs.length; i++) {
    var pos = pairs[i].indexOf('=');
    if (pos == -1) { // First one might be a calid
    if (i == 0) {
      if (!args) args = new Object()
        args.calid = unescape(pairs);
       }
       continue;
     }
     var argname = pairs[i].substring(0, pos);
     var value = pairs[i].substring(pos + 1);
     if (!args) args = new Object()
     args[argname] = unescape(value);
  }
  return args;
}

// Login function
function login() {
  var user=document.u.user.value;
  var password=document.p.password.value;
  if ( isBlank(user) || isBlank(password)) {
    document.location = '/?nouserpass='+encodeWhiteSpaces(user);
    return false;
  } else {
    // trim the user value to prevent further errors
    document.p.test.value = (new Date()).getTime();
    document.p.user.value=user;
    return true;
  }
}

// Error messages display routine
function printErrorMsg(idx1,idx2) {
  document.write(
    '<tr>'+
      '<td>&nbsp;</td>'+
      '<td>'+
        '<div class="logErr">'+
          '<table border="0" cellspacing="0" cellpadding="0">'+
            '<tr>'+
              '<td valign="top">'+
                '<img src="imx/Error_Large.gif" width="21" height="20" alt="Error" vspace="3">'+
                '&#160;&#160;'+
              '</td>'+
              '<td>'+
                '<span class="AlrtErrTxt">'+errormsg[idx1]+'<br>'+errormsg[idx2]+
                '</span>'+
              '</td>'+
            '</tr>'+
          '</table>'+
        '</div>'+
      '</td>'+
    '</tr>');
}

// Error management and display routine
function errorManager() {
  var IE = 0, NN = 0;
  var errorcode;
  if ( args && args.errorcode ) {
    errorcode=args.errorcode;
  }
  var user;
  if ( args && args.user ) {
    user = args.user;
  }
  var nouserpass = false;
  if (window.location.search && window.location.search.substring(0,12) == '?nouserpass=') {
    nouserpass=true;
  }

  if (navigator.userAgent == '') {
    IE = 3;
  } else if (navigator.userAgent.indexOf('MSIE') != -1) {
    IE = parseFloat(navigator.userAgent.substring(navigator.userAgent.indexOf('MSIE') + 5, navigator.userAgent.length));
  } else if (navigator.userAgent.indexOf('Mozilla') != -1) {
    NN = parseFloat(navigator.userAgent.substring(navigator.userAgent.indexOf('Mozilla') + 8, navigator.userAgent.length));
  }

  //alert("IE=["+IE+"] NN=["+NN+"] nouserpass=["+nouserpass+"] user=["+user+"] errorcode=["+errorcode+"]");
  if (IE <=3 && NN <= 3) {
    printErrorMsg(0, 1);
  } else if (user && !nouserpass && (errorcode == 0)) {
    if (NN >= 3 && NN < 4) {
      alert(alertmsg[0]);
    } else {
      printErrorMsg(3, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11000)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[1]);
    else {
      printErrorMsg(4, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11001)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[2]);
    else {
      printErrorMsg(5, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11002)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[3]);
    else {
      printErrorMsg(6, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11003)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[4]);
    else {
      printErrorMsg(7, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11004)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[5]);
    else {
      printErrorMsg(8, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11005)) {
    if (NN >= 3 && NN < 4)
        alert(alertmsg[6]);
    else {
        printErrorMsg(9, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11006)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[7])
    else {
      printErrorMsg(13, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11007)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[8])
    else {
      printErrorMsg(14, 2);
    }
  } else if (user && !nouserpass && (errorcode == 11008)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[8])
    else {
      printErrorMsg(14, 2);
    }
  } else if (user && !nouserpass && (errorcode == 78)) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[10])
    else {
      printErrorMsg(15, 2);
    }
  }


  if (nouserpass) {
    if (NN >= 3 && NN < 4)
      alert(alertmsg[9])
    else {
      printErrorMsg(10, 2);
    }
  }
}

// function called once HTML loaded
function selectField() {
  document.u.user.focus();
  if (args) {
    if (args.nouserpass) document.u.user.value = args.nouserpass;
    if (args.user)       document.u.user.value = args.user;
    if (args.calid)      document.p.calid.value   = args.calid;
    if (args.view)       document.p.view.value    = args.view;
    if (args.date)       document.p.date.value    = args.date;
    if (args.locale)     document.p.locale.value  = args.locale;
    if (args.calname)    document.p.calname.value = args.calname;
    if (args.tzid)       document.p.tzid.value    = args.tzid;

    if ( args.nouserpass || args.user ) {
      document.p.password.focus();
    }
    if (args.calid || args.view || args.date || args.tzid) {
      document.p.user.value="anonymous";
      document.p.password.value = "x";
      document.p.submit();
    }
  }
}

// MAIN CODE SECTION
// NON CONDITIONAL EXECUTION
// EXECUTED AT SCRIPT LOAD TIME
// Getting URL parameters
var args = getArgs();

// Ultimate client-side JavaScript client sniff. Version 3.03
// (C) Netscape Communications 1999.  Permission granted to reuse and distribute.

// convert all characters to lowercase to simplify testing
var agt=navigator.userAgent.toLowerCase();

// *** BROWSER VERSION ***
// Note: On IE5, these return 4, so use is_ie5up to detect IE5.
var is_major = parseInt(navigator.appVersion);
var is_minor = parseFloat(navigator.appVersion);
var is_nav  = ((agt.indexOf('mozilla')!=-1) && (agt.indexOf('spoofer')==-1)
                && (agt.indexOf('compatible') == -1) && (agt.indexOf('opera')==-1)
                && (agt.indexOf('webtv')==-1) && (agt.indexOf('hotjava')==-1));

var is_nav4 = (is_nav && (is_major == 4));
var is_gecko = (agt.indexOf('gecko') != -1);
var is_ie     = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
var is_ie3    = (is_ie && (is_major < 4));
var is_ie4    = (is_ie && (is_major == 4) && (agt.indexOf("msie 4")!=-1) );
var is_ie5up  = (is_ie && !is_ie3 && !is_ie4);

// *** PLATFORM ***
var is_win   = ( (agt.indexOf("win")!=-1) || (agt.indexOf("16bit")!=-1) );
var is_mac    = (agt.indexOf("mac")!=-1);
var is_sun   = (agt.indexOf("sunos")!=-1);


//LOADING THE PROPER VERSION OF MASTER STYLE CSS
if (is_ie5up) // IE5
{
  document.write('<link href="master-style_ie5up.css" type="text/css" rel="stylesheet">');
}
else if (is_gecko) // Netscape 6/7 or Mozilla
{
  document.write('<link href="master-style_ns6up.css" type="text/css" rel="stylesheet">');
}
else if (is_nav4 && is_win) // Netscape 4 Windows
{
  document.write('<link href="master-style_ns4win.css" type="text/css" rel="stylesheet">');
}
else if (is_nav4 && is_sun) // Netscape 4 Solaris
{
  document.write('<link href="master-style_ns4sol.css" type="text/css" rel="stylesheet">');
}
else  // All others
{
  document.write('<link href="master-style_ns4sol.css" type="text/css" rel="stylesheet">');
}

//LOADING LOGIN.CSS OR NOT
if (!is_nav4) {
  document.write('<link href="login.css" type="text/css" rel="stylesheet">');
}

