
<!-- <xsl:template name="dateChecking"> -->

    var valuesave = new Array();

    var MonthMap = new Array();
    MonthMap = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

<!-- the value for these variables are set up in javascript_vars template -->
    var monthName = new Array(jan,feb,mar,apr,may,jun,jul,aug,sep,oct,nov,dec);

<!-- This array is set up in javascript_vars template -->
<!--     var dateCheckErrorMsg = new Array(); -->

    function padZero(n) {
      if (n.length == 1) {
        return '0' + n;
      }
      else {
        return n;
      }
    }

    function daysInMonth(month,year) {

      m = checkNumberStringInput(month);
      
      if (m == -1)
	return (-1);

      y = checkNumberStringInput(year);

      if (y == -1)
	return (-1);

      if (m != 2) {
        return (MonthMap[m -1]);
      }

      <!-- If year is unknown allow upto 29 days in Feb -->
      if (isNaN(y)) {
	return(MonthMap[1]+1);
      }

      return (MonthMap[1] + (isLeapYear(y) ? 1 : 0));
    }

    function isLeapYear(year) {
      return (year % 400 == 0) || (year % 4 == 0 && year % 100 != 0);
    }

    function valueSave(entry,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }
       valuesave[entry]=theform[entry].value;
    }

    function ddCheck(prefix,theform)
    {
      var dayentry=theform[prefix + 'dd'];
      var month=theform[prefix + 'mm'].value;
      var year=theform[prefix + 'ccyy'].value;
      var d = checkNumberStringInput(dayentry.value);

      if (isNaN(d) || d < 1 || d > daysInMonth(month,year)) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide a good day'] + ' ' + monthName[month -1] + '.');        
        if ( !isNaN(valuesave[prefix + 'dd']) && (valuesave[prefix + 'dd']  < daysInMonth(month,year))) {
          dayentry.value = valuesave[prefix + 'dd'];
        } else {
          dayentry.value = daysInMonth(month,year);
        } 
        dayentry.focus();
        dayentry.select();
        return 1; 
      } 

      dayentry.value = padZero(dayentry.value);
      valuesave[prefix + 'dd'] = dayentry.value;
      return 0;
    }

    function mmCheck(prefix,theform)
    {
      var monthentry=theform[prefix + 'mm'];

      var m = checkNumberStringInput(monthentry.value);

      if (isNaN(m) || m < 1 || m > 12) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide good month']);
        if ( !isNaN(valuesave[prefix + 'mm']) ) {
          monthentry.value = valuesave[prefix + 'mm'];
        } 
        monthentry.focus();
        monthentry.select();
        return 1;
        
      }


      monthentry.value = padZero(monthentry.value);
      return(ddCheck(prefix,theform))
    }

    function ccyyCheck(prefix,theform)
    {
      var retval = checkYearPart(prefix,theform);
        
      if(0 == retval) {
        return(ddCheck(prefix,theform));
      } else {
        return retval;
      }
    }

    function checkYearPart(prefix, theform)
    {
      var s = '';
      var yearentry=theform[prefix + 'ccyy'];
      var y = yearentry.value;

      if (y == '00') {
        y = 2000;
      }
      else {
        y = checkNumberStringInput(y);
        if (y == 0 || isNaN(y)) {
          y = -1;
        }
      }

      if (y > 50 && y < 100) {
        y = parseInt('19' + y);
      }
      else {
        if (y > -1 && y <= 50) {
          if (y < 10) {
            y = parseInt('200' + y);
          }
          else {
            y = parseInt('20' + y);
          }
        }
      }

      if (y == -1) {
        s = dateCheckErrorMsg['provide good year'];
      }
      else {
        if (y < 1970) {
          s = dateCheckErrorMsg['provide good min year'];
        }
        if (y > 2036) {
          s = dateCheckErrorMsg['provide good max year'];
        }
      }


      if (s.length > 0) {
        parent.date_error = 1;
        alert(s);
        if ( !isNaN(valuesave[prefix + 'ccyy']) ) {
          yearentry.value = valuesave[prefix + 'ccyy'];
        }
        yearentry.focus();
        yearentry.select();
        return 1;
        
      }

      yearentry.value = y;

      return 0;
    }

    function dateCheck(prefix,field,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }

      switch (field) {
        case 'dd':
          ddCheck(prefix,theform);
          break;
        case 'mm':
          mmCheck(prefix,theform);
          break;
        case 'ccyy':
          ccyyCheck(prefix,theform);
          break;
        default:
          ccyyCheck(prefix,theform);
          break;
      }

    }

    function untilDateCheck(prefix,field,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }
      dateCheck(prefix,field,theform);

    }

    function untilddCheck(prefix,theform)
    {
      var iErr = 0;
      if (!theform) {
        theform = window.document.form;
      }
      var untildayentry=theform[prefix + 'dd'];
      if (isNaN(untildayentry.value))
      {
         untildayentry = theform['dd'];
      }
      var untilmonth=theform[prefix + 'mm'].value;
      if (isNaN(untilmonth))
      {
         untilmonth = theform['mm'].value;
      }
      var untilyear=theform[prefix + 'ccyy'].value;
      if (isNaN(untilyear))
      {
         untilyear = theform['ccyy'].value;
      }
      var untild = checkNumberStringInput(untildayentry.value);

      if (untilyear > theform['ccyy'].value)
      {
        iErr = 0;
      }
      else if (untilyear < theform['ccyy'].value)
      {
        iErr = 1;
      }
      else
      {
        if (untilmonth > theform['mm'].value)
	    {
           iErr = 0;
	    }
	    else if (untilmonth < theform['mm'].value)
	    {  
	       iErr = 1;
	    }
	    else
	    {
	        if (untild < theform['dd'].value)
	        {
	            iErr = 1;
	        }
	        else {
                iErr = 0;
            }
	     }
      }

      if (isNaN(untild) || untild < 1 || untild > daysInMonth(untilmonth,untilyear)) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide a good day'] + ' ' + monthName[untilmonth -1] + '.');
        if (!isNaN(valuesave[prefix + 'dd']))
        {
	       untildayentry.value = valuesave[prefix + 'dd'];
        }
        else
        {
           untildayentry.value = valuesave['dd'];
        }	
        untildayentry.focus();
        untildayentry.select();
      }
      if (iErr == 1)
      {
         parent.date_error = 1;
         alert(dateCheckErrorMsg['good until day']);
         untildayentry.value = theform['dd'].value;
      }
      else
      {
         untildayentry.value = padZero(untildayentry.value);
      }
      return iErr;
    }

    function hourCheck(r,prefix,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }  
      var hourentry=theform[prefix + 'hr'];
	      
      
      var h = checkNumberStringInput(hourentry.value);
      var radix = parseInt(r);
      var minVal = 1;

      if (radix == 23)
      {
        minVal = 0;
      }

      if (isNaN(h) || h < minVal || h > radix) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide good hour']);
        hourentry.value = valuesave[prefix + 'hr'];
        hourentry.focus();
        hourentry.select();
        return;
        
      }
      hourentry.value = padZero(hourentry.value);
    }

    function minuteCheck(prefix,theform)
    {
	if (!theform) {
	   theform = window.document.form;
	}  
	var minuteentry=theform[prefix + 'mn'];
	      
      
      var m = checkNumberStringInput(minuteentry.value);
      
      if (isNaN(m) || m < 0 || m > 59) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide good minute']);
        minuteentry.value = valuesave[prefix + 'mn'];
        minuteentry.focus();
        minuteentry.select();
        return;
        
      }
      minuteentry.value = padZero(minuteentry.value);
    }

    function durationHourCheck(r,prefix,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }  
      var hourentry=theform[prefix + 'hr'];
	      
      
      var h = checkNumberStringInput(hourentry.value);
      var radix = parseInt(r);

      if (isNaN(h) || h < 0 || h > radix) {
        parent.date_error = 1;
        alert(dateCheckErrorMsg['provide good duration hour']);
        hourentry.value = valuesave[prefix + 'hr'];
        hourentry.focus();
        hourentry.select();
        return;
        
      }
      hourentry.value = padZero(hourentry.value);
    }

    function allowEmptyDateCheck(prefix,field,theform)
    {
      if (!theform) {
        theform = window.document.form;
      }

      var dayentry=theform[prefix + 'dd'];
      var monthentry=theform[prefix + 'mm'];
      var yearentry=theform[prefix + 'ccyy'];
      var d = checkNumberStringInput(dayentry.value);
      var m = checkNumberStringInput(monthentry.value);
      var y = checkNumberStringInput(yearentry.value);

      switch (field) {
        case 'dd':
          if (isNaN(d)) 
            return 0;

          if (d < 1 || d > 31) {
            parent.date_error = 1;
            if ( isNaN(m) )
              alert(dateCheckErrorMsg['invalid day']); 
            else
              alert(dateCheckErrorMsg['provide a good day'] + ' ' + monthName[m -1] + '.');
            dayentry.value = valuesave[prefix + 'dd'];
            dayentry.focus();
            dayentry.select();
            return 1;
          }

          ddCheck(prefix,theform);
          break;

        case 'mm':
          if (isNaN(m))
            return 0;

          if (m < 1 || m > 12) {
            parent.date_error = 1;
            alert(dateCheckErrorMsg['provide good month']);
            monthentry.value = valuesave[prefix + 'mm'];
            monthentry.focus();
            monthentry.select();
            return 1;
          }

          monthentry.value = padZero(monthentry.value);

          if (isNaN(d)) return 0;

          return(ddCheck(prefix,theform));

          break;

        case 'ccyy':
          if (isNaN(y))
            return 0;

          var retval = checkYearPart(prefix,theform);
          if (retval) return retval;

          if (isNaN(d)) return 0;

          return(ddCheck(prefix,theform));

          break;

        default:
          if (isNaN(y))
            return 0;

          var retval = checkYearPart(prefix,theform);
          if (retval) return retval;

          if (isNaN(d)) return 0;

          return(ddCheck(prefix,theform));

          break;
      }

    }

    function jumpto_newdate()
    {
      var local_f = window.document.form;

      var dayentry=local_f['dd'];
      var monthentry=local_f['mm'];
      var yearentry=local_f['ccyy'];
      var d = checkNumberStringInput(dayentry.value);
      var m = checkNumberStringInput(monthentry.value);
      var y = checkNumberStringInput(yearentry.value);

      if (isNaN(m) || isNaN(d) || isNaN(y) )
        return;

      if (mmCheck('',local_f) != 0) {
        return;
      }
      if (ddCheck('',local_f) != 0) {
        return;
      }
      if (ccyyCheck('',local_f) != 0) {
        return;
      }

      var month = local_f['mm'].value;
      if (month.length == 1) {
        month = '0' + month.charAt(0);
      } else {
        month = month.charAt(0) + month.charAt(1);
      }

      var day = local_f['dd'].value;
      if (day.length == 1) {
        day = '0' + day.charAt(0);
      } else {
        day = day.charAt(0) + day.charAt(1);
      }

      var year = local_f['ccyy'].value;

      if (month.length == 0 || isNaN(Number(month)) ||
          day.length == 0 || isNaN(Number(day)) ||
          year.length != 4 || isNaN(Number(year))) {
         window.alert(alert_invalid_date);
         return;
      }

      if (parent.date_error == '1') {
         parent.date_error = '0';
         return;
      } 

      var view = jmain.gCurView;

      var idArray = jmain.location.search.match(/id=([^&]*)/);
      var id = '';
      if (idArray && idArray.length > 0) {
        id = idArray[1];
      }

      var tzidArray = parent.location.search.match(/tzid=([^&]*)/);
      var tzid = '';
      if (tzidArray && tzidArray.length > 0) {
        tzid = tzidArray[1];
      }

      var groupArray = jmain.location.search.match(/group=([^&]*)/);
      var group = '';
      var calidArray = jmain.location.search.match(/calid=([^&]*)/);
      var calid = '';
      if (groupArray && groupArray.length > 0) {
        group = groupArray[1];
      } else if (calidArray && calidArray.length > 0) {
        calid = calidArray[1];
      }

      jmain.setDate(year + month + day + 'T000000');
      var urlstring = jmain.gCommandBaseURL +
                '/command.shtml?view=' + view +
                '&id=' + id +
                (group != '' ? '&group='+ group : '') +
                (calid != '' ? '&calid='+ calid : '') +
                (tzid != '' ? '&tzid='+ tzid : '') +
                '&date=' + year + month + day + 'T000000';

      jmain.location.replace(urlstring);

    }

    function in24clock(hour, ampm)
    {
       var ret = hour;

      
        if (ampm != null) {
            if ( ampm == 1 && hour != '12') {
              ret = parseInt(hour) + 12;
            }
            if ( ampm == 0 && hour == '12') {
              ret = '00';
            }
        }

      return ret;
    }

    function comparetime(theform, isampm, firstprefix, isallday)
    {
      var ret = 0;
      if (!theform) {
        theform = window.document.form;
      }

      if(theform[firstprefix+'ccyy']) {
        var fyear = theform[firstprefix+'ccyy'].value;
      } else {
        var fyear = theform['firstyear'].value;
      }

      if(theform['ccyy']) {
        var syear = theform['ccyy'].value;
      } else {
        var syear = theform['secondyear'].value;
      }

      if(theform[firstprefix+'mm']) {
        var fmonth = theform[firstprefix+'mm'].value;
      } else {
        var fmonth = theform['firstmonth'].value;
      }

      if(theform['mm']) {
        var smonth = theform['mm'].value;
      } else {
        var smonth = theform['secondmonth'].value;
      }

      if(theform[firstprefix+'dd']) {
        var fday = theform[firstprefix+'dd'].value;
      } else {
        var fday = theform['firstday'].value;
      }

      if(theform['dd']) {
        var sday = theform['dd'].value;
      } else {
        var sday = theform['secondday'].value;
      }      

      <!-- Set time to the same so that time is not used for allday comparisons -->
      if (!isallday) {
        if(theform[firstprefix+'hr']) {
          if(isampm == 1) {
	    if(theform[firstprefix+'pm'][0].selected) {
            	var fhour = in24clock(theform[firstprefix+'hr'].value, 0);
	    } else {
		var fhour = in24clock(theform[firstprefix+'hr'].value, 1);
	    }
          } else {
            var fhour = theform[firstprefix+'hr'].value;
          }
        } else {
          var fhour = theform['firsthour'].value;
        }

        if(theform['hr']) {
          if(isampm == 1) {
            if(theform['pm'][0].selected) {
            	var shour = in24clock(theform['hr'].value, 0);
	    } else {
		var shour = in24clock(theform['hr'].value, 1);
	    }
          } else {
            var shour = theform['hr'].value;
          }
        } else {
          var shour = theform['secondhour'].value;
        }

        if(theform[firstprefix+'mn']) {
          var fminute = theform[firstprefix+'mn'].value;
        } else {
          var fminute = theform['firstminute'].value;
        }

        if(theform['mn']) {
          var sminute = theform['mn'].value;
        } else {
          var sminute = theform['secondminute'].value;
        }
      } else {
	var fhour = 1;
	var shour = 1;
	var fminute = 1;
	var sminute = 1;
      }

      if (fyear > syear)
      {
        ret = 1;
      }
      else if (fyear < syear)
      {
        ret = 0;
      }
      else if (fmonth > smonth)
      {
        ret = 1;
      }
      else if (fmonth < smonth)
      {  
        ret = 0;
      }
      else if (fday > sday)
      {
        ret = 1;
      }
      else if (fday < sday)
      {
        ret = 0;
      }
      else if (fhour > shour)
      {
         ret = 1;
      }
      else if (fhour < shour)
      {
         ret = 0;
      }
      else if (fminute > sminute)
      {
         ret = 1;
      }
      else {
         ret = 0;
      }
      return ret;
    }


    function importexport_ddCheck(prefix, theform)
    {
      var dayentry=theform[prefix + '_day'];
      if (prefix == 'ms') {
      	var month=theform['mStart'].value;
      } else {
	var month=theform['mEnd'].value;
      }
      var year=theform[prefix + '_year'].value;
      var d = checkNumberStringInput(dayentry.value);

      if (isNaN(d) || d < 1 || d > daysInMonth(month,year)) {
        alert(dateCheckErrorMsg['provide a good day'] + ' ' + monthName[month -1] + '.');        
        if ( !isNaN(valuesave[prefix + '_day']) && (valuesave[prefix + '_day']  < daysInMonth(month,year))) {
          dayentry.value = valuesave[prefix + '_day'];
        } else {
          dayentry.value = daysInMonth(month,year);
        } 
        dayentry.focus();
        dayentry.select();
        return 1; 
      } 

      dayentry.value = padZero(dayentry.value);
      valuesave[prefix + '_day'] = dayentry.value;
      return 0;
    }

    function importexport_yearCheck(prefix, theform)
    {
      var s = '';
      var yearentry=theform[prefix + '_year'];
      var y = yearentry.value;

      if (y == '00') {
        y = 2000;
      }
      else {
        y = checkNumberStringInput(y);
        if (y == 0 || isNaN(y)) {
          y = -1;
        }
      }

      if (y > 50 && y < 100) {
        y = parseInt('19' + y);
      }
      else {
        if (y > -1 && y <= 50) {
          if (y < 10) {
            y = parseInt('200' + y);
          }
          else {
            y = parseInt('20' + y);
          }
        }
      }

      if (y == -1) {
        s = dateCheckErrorMsg['provide good year'];
      }
      else {
        if (y < 1970) {
          s = dateCheckErrorMsg['provide good min year'];
        }
        if (y > 2036) {
          s = dateCheckErrorMsg['provide good max year'];
        }
      }


      if (s.length > 0) {
        alert(s);
        if ( !isNaN(valuesave[prefix + 'year']) ) {
          yearentry.value = valuesave[prefix + 'year'];
        } else {
          if (prefix == 'ms') {
             yearentry.value = '1970';
          } else {
             yearentry.value = '2036';
          }
        }
        yearentry.focus();
        yearentry.select();
        return 1;
        
      }

      yearentry.value = y;
      
      return(importexport_ddCheck(prefix,theform));
    }



