<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="recurrence.xsl"/>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="tab_value">
      <xsl:choose>
        <xsl:when test="string-length(/calendar/group[@name='main']/taskdata/Task/@e_rrule_daily) &gt; 0">1</xsl:when>
        <xsl:when test="string-length(/calendar/group[@name='main']/taskdata/Task/@e_rrule_monthly) &gt; 0">3</xsl:when>
        <xsl:when test="string-length(/calendar/group[@name='main']/taskdata/Task/@e_rrule_yearly) &gt; 0">4</xsl:when>
        <xsl:otherwise>2</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>tab=<xsl:value-of select="$tab_value"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>tab=<xsl:value-of select="$tab_value"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>tab=<xsl:value-of select="$tab_value"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE>Recurrence: Sun Java[tm] System Calendar Express</TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="1" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" marginheight="9" marginwidth="9" src="{$Frame2}"/>
      <FRAME name="button" marginheight="1" marginwidth="1" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="one_tab_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
              <xsl:call-template name="recurrence_root">
                <xsl:with-param name="e_rrule_byMonthRule">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_byMonthRule"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_freq">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_freq"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_interval">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_interval"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_byDay">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_byDay"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_byMonthDay">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_byMonthDay"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_byMonth">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_byMonth"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_bySetPos">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_bySetPos"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_daily">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_daily"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_weekly">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_weekly"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_monthly">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_monthly"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_yearly">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_yearly"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_SU">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_SU"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_MO">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_MO"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_TU">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_TU"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_WE">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_WE"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_TH">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_TH"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_FR">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_FR"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_SA">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_SA"/>
                </xsl:with-param>
                <xsl:with-param name="e_rrule_notset">
                  <xsl:value-of select="./taskdata/Task/@e_rrule_notset"/>
                </xsl:with-param>
                <xsl:with-param name="allDay" select="./taskdata/Task/@e_allday"/>
                <xsl:with-param name="typeSelection" select="./taskdata/Task/@currSelection"/>
              </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>      
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (task_recurrence.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="one_tab_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0">

<xsl:call-template name="load_tabs"/>
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item"><xsl:with-param name="Index">1</xsl:with-param><xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param><xsl:with-param name="Name"><xsl:text>&nbsp;</xsl:text>Recurrence<xsl:text>&nbsp;</xsl:text></xsl:with-param><xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param></xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="recurrenceTimeTable">
<!-- set up variables to use when switching between types of recurrence -->
<xsl:variable name="theRange">
  <xsl:choose>
  <xsl:when test="./taskdata/Task/@inprog_range">
    <xsl:value-of select="./taskdata/Task/@inprog_range"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="./taskdata/Task/@e_rrule_range"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:variable>
<xsl:variable name="theCount">
  <xsl:choose>
  <xsl:when test="./taskdata/Task/@inprog_count">
    <xsl:value-of select="./taskdata/Task/@inprog_count"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of select="./taskdata/Task/@e_rrule_count"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:variable>

<xsl:variable name="countlength">
  <xsl:choose>
  <xsl:when test="/calendar/group[@name='main']/taskdata/Task/@recurrence_bound &lt; 100">
<!-- don't translate this - it's not for display -->
    <xsl:text>2</xsl:text>
  </xsl:when>
  <xsl:otherwise>
<!-- don't translate this - it's not for display -->
    <xsl:text>3</xsl:text>
  </xsl:otherwise>
  </xsl:choose>
</xsl:variable>

  <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
<!-- one row to allow selection of the start date -->
    <TR>
      <TD valign="middle" colspan="2">
        <FONT face="{$font_name}" size="{$font_size_big_2}"><B>Due Date<xsl:text>&nbsp;</xsl:text></B></FONT>
      </TD>
      <TD align="left" valign="middle">
         <xsl:choose>
         <xsl:when test="./taskdata/Task/inprog_DueTime">
            <xsl:call-template name="date_selector">
              <xsl:with-param name="month" select="./taskdata/Task/inprog_DueTime/@month" />
              <xsl:with-param name="day" select="./taskdata/Task/inprog_DueTime/@date" />
              <xsl:with-param name="year" select="./taskdata/Task/inprog_DueTime/@year" />
            </xsl:call-template>
         </xsl:when>
<!-- put something in the start time so ddcheck's don't barf... -->
         <xsl:when test="./taskdata/Task/@e_notdue='1'">
            <xsl:call-template name="date_selector">
              <xsl:with-param name="month" select="/calendar/timectx/CurrTime/@month" />
              <xsl:with-param name="day" select="/calendar/timectx/CurrTime/@date" />
              <xsl:with-param name="year" select="/calendar/timectx/CurrTime/@year" />
            </xsl:call-template>
         </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="date_selector">
              <xsl:with-param name="month" select="./taskdata/Task/DueTime/@month" />
              <xsl:with-param name="day" select="./taskdata/Task/DueTime/@date" />
              <xsl:with-param name="year" select="./taskdata/Task/DueTime/@year" />
            </xsl:call-template>
          </xsl:otherwise>
         </xsl:choose>
            <A>
              <xsl:attribute name="href">
                <xsl:value-of select="command[@name='jump_to']"/>
              </xsl:attribute>
              <IMG src="imx/goto2.gif" width="24" height="24" align="absmiddle" border="0" alt="Jump to a new date"/>
            </A>
<!-- Need to tell the button_root not to copy the time data -->
         <INPUT type="hidden" name="notime" value="1"/>
      </TD>
    </TR>
<!-- spacer row to look good -->
    <TR>
      <TD colspan="3">
        <xsl:text>&nbsp;</xsl:text>
      </TD>
    </TR>
<!-- 3 rows and 3 columns to allow selection of the end criteria -->
     <TR>
      <TD valign="middle">
        <FONT face="{$font_name}" size="{$font_size_big_2}"><B>End<xsl:text>&nbsp;</xsl:text></B>
        <xsl:value-of select="$note_blip"/>
        </FONT>
      </TD>
       <TD valign="baseline" width="1%" align="left">
              <input type="radio" name="range" value="COUNT">
                <xsl:if test="not($theRange='UNTIL') and not($theRange='FOREVER')">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
       </TD>
       <TD valign="baseline" align="left">
          <xsl:call-template name="until_count_selector">
            <xsl:with-param name="count_len" select="$countlength"/>
            <xsl:with-param name="count_num" select="$theCount"/>
            <xsl:with-param name="count_type">TASK</xsl:with-param>
            <xsl:with-param name="recur_bound" select="/calendar/group[@name='main']/taskdata/Task/@recurrence_bound"/>
          </xsl:call-template>
       </TD>
    </TR>
    <TR>
       <TD>
        <xsl:text>&nbsp;</xsl:text>
       </TD>
      <TD valign="middle" align="left">
              <input type="radio" name="range" value="UNTIL">
                <xsl:if test="$theRange='UNTIL'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
      </TD>
      <TD valign="baseline" align="left">
              <xsl:choose>
                <xsl:when test="./taskdata/Task/inprog_UntilTime">
                  <xsl:call-template name="date_selector">
                    <xsl:with-param name="input_prefix" select="'until'" />
                    <xsl:with-param name="month" select="./taskdata/Task/inprog_UntilTime/@month" />
                    <xsl:with-param name="day" select="./taskdata/Task/inprog_UntilTime/@date" />
                    <xsl:with-param name="year" select="./taskdata/Task/inprog_UntilTime/@year" />
                    <xsl:with-param name="checkFunction" select="'untilDateCheck'" />
                  </xsl:call-template>
                 </xsl:when>
                <xsl:when test="./taskdata/Task/RepeatUntilTime">
                  <xsl:call-template name="date_selector">
                    <xsl:with-param name="input_prefix" select="'until'" />
                    <xsl:with-param name="month" select="./taskdata/Task/RepeatUntilTime/@month" />
                    <xsl:with-param name="day" select="./taskdata/Task/RepeatUntilTime/@date" />
                    <xsl:with-param name="year" select="./taskdata/Task/RepeatUntilTime/@year" />
                    <xsl:with-param name="checkFunction" select="'untilDateCheck'" />
                  </xsl:call-template>
                 </xsl:when>
                 <xsl:otherwise>
                  <xsl:call-template name="date_selector">
                    <xsl:with-param name="input_prefix" select="'until'" />
                    <xsl:with-param name="month" select="timectx/StartTime/@month" />
                    <xsl:with-param name="day" select="timectx/StartTime/@date" />
                    <xsl:with-param name="year" select="timectx/StartTime/@year" />
                    <xsl:with-param name="checkFunction" select="'untilDateCheck'" />
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose>
      </TD>
    </TR>
    <TR>
      <TD>
        <xsl:text>&nbsp;</xsl:text>
      </TD>
      <TD valign="baseline" width="1%" align="left"> 
             <input type="radio" name="range" value="FOREVER">
                <xsl:if test="$theRange='FOREVER'">
                  <xsl:attribute name="checked"/>
                </xsl:if>
              </input>
       </TD>
       <TD valign="baseline" align="left">
         <font size="{$font_size_big_2}" face="{$font_name}"><xsl:value-of select="$no_end_date_msg"/></font>
       </TD>
     </TR>
     <TR>
       <td>
         <xsl:text>&nbsp;</xsl:text>
       </td>
       <td>
         <xsl:text>&nbsp;</xsl:text>
       </td>
       <td>
         <xsl:text>&nbsp;</xsl:text>
       </td>
     </TR>
     <TR>
      <td>
        <xsl:text>&nbsp;</xsl:text>
      </td>
      <td colspan="2" align="right" valign="bottom" >
        <font size="{$font_size_big_2}" face="{$font_name}">
            <xsl:call-template name="creates_max_msg_template">
              <xsl:with-param name="MaxNum" select="/calendar/group[@name='main']/taskdata/Task/@recurrence_bound"/>
            </xsl:call-template>
        </font>
      </td>
    </TR>
  </TABLE>

</xsl:template>


</xsl:stylesheet>
