<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<xsl:template match="panel">
  <!-- <xsl:value-of select="@name"/><br/> -->

  <xsl:choose>
    <xsl:when test="@name='singleWeekTimeHeader'">
    <TR>
    <TD align="left">
      <xsl:call-template name="singleWeekTimeHeaderTemplate"/>
    </TD>
<!-- usually the viewtabs is in a second column here but -->
<!-- this seems to mess up the weekcal table so we do it as part of a table -->
<!-- when doing the singleWeekTimeHeaderTemplate -->
<!--
    <TD align="right" valign="bottom">
    </TD>
-->    
    </TR>
    </xsl:when>

    <xsl:when test="@name='weekgrid'">
    <TR>
<!--    <TD colspan="2"> because the viewtabs are in one element with the time info-->
    <TD>
      <xsl:apply-templates select="weekcal"/>
    </TD>
    </TR>
    </xsl:when>

    <xsl:when test="@name='miniview'">
        <xsl:apply-templates select="panel"/>
        <HR size="{$font_size_big}"/>
    </xsl:when>
 
    <xsl:when test="@name='minical'">
      <xsl:apply-templates select="minical"/>
    </xsl:when>

    <xsl:when test="@name='tasktable'">
      <xsl:call-template name="tasktable"/>
    </xsl:when>

    <xsl:otherwise>
    <TABLE border="0">
      <xsl:apply-templates select="panel"/>
    </TABLE>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>


<xsl:template match="weekcal">
<xsl:variable name="weekday_count">
  <xsl:value-of select="count(./weekday)"/>
</xsl:variable>

<xsl:variable name="borderwidth">
   <xsl:choose>
    <xsl:when test="/calendar/@view = 'print'">2</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
</xsl:variable>


<TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}">
    <TABLE border="{$borderwidth}" cellpadding="3" cellspacing="1" width="100%">

<!-- First do the TOP row, which is Time Zone, AllDay stuff and Days of week -->
     <TR>
       <TD rowspan="2" width="1%" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
           <xsl:text>&nbsp;</xsl:text>
<!--
           <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">PST</FONT>
-->
       </TD>
<!-- above the day name/number info -->
       

       <xsl:for-each select="weekday">
        <xsl:variable name="bgcolorchoice">
        <xsl:choose>
        <xsl:when test="./ComponentGroup[@ComponentGroupType='allday_events']"><xsl:value-of select="$bgcolor_form_selected"/></xsl:when>
        <xsl:when test="@dow=1"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
        <xsl:when test="@dow=7"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$bgcolor_table_mid"/></xsl:otherwise>
        </xsl:choose>
        </xsl:variable>
         
         <TD width="14%" valign="top" bgcolor="{$bgcolorchoice}">
         <xsl:if test="($username != 'anonymous') and ($view != 'print')">
         <A>
          <xsl:attribute name="href">
            <xsl:value-of select="command[2]"/>          
          </xsl:attribute>

            <IMG src="imx/new.gif" width="16" height="16" border="0" alt="{$alt_schedule_new_appt}"/>
         </A>
         </xsl:if>
<!-- If there are any allday events put them here -->
<!-- If there are none, put in a space (necessary for TD color -->
        <xsl:if test="./ComponentGroup[@ComponentGroupType='allday_events']">
        <xsl:text>&nbsp;</xsl:text>
        </xsl:if>
        <xsl:for-each select="./ComponentGroup">
          <xsl:if test="@ComponentGroupType='allday_events'">
              <xsl:for-each select="Event|Busy">
              <xsl:if test="name(.)='Event'">
                <xsl:call-template name="smallList_Event"/>
              </xsl:if>
              <xsl:if test="name(.)='Busy'">
                <xsl:call-template name="smallList_Busy"/>
              </xsl:if>
              </xsl:for-each>
          </xsl:if>
        </xsl:for-each>
<!-- done with allday events -->
      </TD>
      </xsl:for-each>
      </TR>
<!-- day name/number info -->
          <TR>
            <xsl:for-each select="weekday">
             <xsl:variable name="topbgcolorchoice">
             <xsl:choose>
             <xsl:when test="(@dow=1) or (@dow=7)"><xsl:value-of select="$bgcolor_wend_top"/></xsl:when>
             <xsl:otherwise><xsl:value-of select="$bgcolor_table_top"/></xsl:otherwise>
             </xsl:choose>
             </xsl:variable>
             <TD width="14%" nowrap="" bgcolor="{$topbgcolorchoice}">

          <xsl:choose>
          <xsl:when test="/calendar/@view='print'">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                <xsl:apply-templates select="@dow"/>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="@date"/>
              </FONT>
          </xsl:when>
          <xsl:otherwise>
              <A style="text-decoration:none;">
              <xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute>
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                <xsl:apply-templates select="@dow"/>
                <xsl:text> </xsl:text>
                <xsl:apply-templates select="@date"/>
              </FONT>
            </A>
          </xsl:otherwise>
          </xsl:choose>
              </TD>
            </xsl:for-each>
          </TR>
<!-- Now start the TIME BLOCKS part of the table -->
<!-- <xsl:for-each select="timeblock"> -->
<xsl:for-each select="timeblock">
<TR>
<!-- save the block number for passing in to a later template -->
<!-- first print the time value of the block -->
<TD width="1%" align="right" valign="top" nowrap="" bgcolor="{$bgcolor_button}">
  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
        <xsl:call-template name="formatTime">
          <xsl:with-param name="ftHour" select="./StartTime/@hour"/>
          <xsl:with-param name="ftMinute" select="./StartTime/@minute"/>
        </xsl:call-template>
  </FONT>
</TD>
<!-- now for each day, print any data from the right block -->
  <xsl:for-each select="weekday">
    <xsl:call-template name="weekdayBlockTemplate">
	   	<xsl:with-param name="mypos" select="position()"/> 
    </xsl:call-template>
  </xsl:for-each>
</TR>
</xsl:for-each>
<!-- Now it's the bottom double row which contains TZ, spacer and notime tasks -->
<TR>
  <TD rowspan="2" width="1%" align="right" valign="top" nowrap="" bgcolor="{$bgcolor_button}">
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
           <xsl:text>&nbsp;</xsl:text>
<!--
      <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
        <FONT color="{$bgcolor_wend_mid}">0</FONT>PST</FONT>
-->
   </TD>
<!-- spacer rest of row : can't assume it is 7 wide becase week is user definable -->
  <TD colspan="{$weekday_count}"><IMG src="imx/spacer.gif" width="1" height="1" border="0"/></TD>
<!-- Now the row of notime info -->
</TR>
<TR>
   <xsl:for-each select="weekday">
      <xsl:variable name="cellbgcolorchoice">
        <xsl:choose>
        <xsl:when test="./ComponentGroup[@ComponentGroupType='onday_tasks']"><xsl:value-of select="$bgcolor_form_selected"/></xsl:when>
        <xsl:when test="@dow=1"><xsl:value-of select="$bgcolor_wend_cell"/></xsl:when>
        <xsl:when test="@dow=7"><xsl:value-of select="$bgcolor_wend_cell"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$bgcolor_background"/></xsl:otherwise>
        </xsl:choose>
       </xsl:variable>
     <TD width="14%" valign="top" bgcolor="{$cellbgcolorchoice}">
<!-- If there are any notime tasks put them here -->
<!-- If there are any notime tasks put them here -->
        <xsl:if test="not(./ComponentGroup[@ComponentGroupType='onday_tasks'])">
          <xsl:text>&nbsp;</xsl:text>
        </xsl:if>
        <xsl:for-each select="./ComponentGroup">
          <xsl:if test="@ComponentGroupType='onday_tasks'">
              <xsl:for-each select="Task">
          <P/>
          <xsl:call-template name="smallList_Task"/>
             </xsl:for-each>
          </xsl:if>
        </xsl:for-each>
<!-- done with notime tasks -->
   </TD>
   </xsl:for-each>
</TR>
        </TABLE>
        </TD>
      </TR>
      <TR>
        <TD><IMG src="imx/spacer.gif" width="1" height="1" vspace="4"/></TD>
      </TR>
</TABLE>
</xsl:template>

<xsl:template name="singleWeekTimeHeaderTemplate">
<TABLE border="0" cellpadding="2" cellspacing="0">
    <TR>
      <TD width="1%" nowrap="">
        <A><xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute><IMG src="imx/ppage-1.gif" width="15" height="15" border="0" alt="{$alt_jump_prev_week}" align="left"/></A><BR/><A><xsl:attribute name="href"><xsl:value-of select="command[2]"/></xsl:attribute><IMG src="imx/npage-1.gif" width="15" height="15" border="0" alt="{$alt_jump_next_week}" align="right"/></A></TD>
      <TD nowrap="">
        <xsl:call-template name="weekTimeHeader"/>
      </TD>
   <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>
   </TD>
 </TR>
</TABLE>
</xsl:template>

<xsl:template name="weekdayBlockTemplate">
   <xsl:param name="mypos"/>

<xsl:variable name="dow">
	<xsl:value-of select="../../weekday[$mypos]/@dow"/>
</xsl:variable>
<xsl:variable name="iso">
	<xsl:value-of select="../../weekday[$mypos]/@iso"/>
</xsl:variable>

<!-- if the last row was a multirow block, skip this one -->
   <xsl:if test="@numIntervals!='0'">
       <xsl:variable name="nestedbgcolorchoice">
          <xsl:choose>
        	<xsl:when test="ComponentGroup"><xsl:value-of select="$bgcolor_form_selected"/></xsl:when>
        	<xsl:when test="@dow=1"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
        	<xsl:when test="@dow=7"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
        	<xsl:otherwise><xsl:value-of select="$bgcolor_table_mid"/></xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="intervals">
	  		<xsl:value-of select="@numIntervals"/>
        </xsl:variable>
<!-- if there is a nested componentgroup, we've got data -->
      <TD width="14%" valign="top" bgcolor="{$nestedbgcolorchoice}" rowspan="{$intervals}">
<!-- now go ahead and print out the events/tasks if there are any -->
      <xsl:call-template name="CGDisplay"/>
      <xsl:if test="$username != 'anonymous'">
        <xsl:if test="$view != 'print'">
          <A>
          <xsl:attribute name="href">
            <xsl:value-of select="command[1]"/>
          </xsl:attribute>

            <IMG src="imx/new.gif" width="16" height="16" border="0" alt="{$alt_schedule_new_appt}"/>
          </A>
         </xsl:if>
      </xsl:if>

<!-- if it's an empty cell, put a spacer in to set the cell -->
      <xsl:if test="not(ComponentGroup)">
        <xsl:text>&nbsp;</xsl:text>
      </xsl:if>
   </TD>
  </xsl:if>
</xsl:template>

<xsl:template name="CGDisplay">
<!-- There is always the top level component group -->
<!-- only if there is data is there a second level component group -->
<xsl:if test="ComponentGroup">
  <xsl:for-each select="ComponentGroup">
    <xsl:call-template name="limitedComponentGroup"/>
  </xsl:for-each>
</xsl:if>
</xsl:template>

</xsl:stylesheet>
