<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="dialog_tabs.xsl"/>
<xsl:include href="common_view.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>	
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>
    <xsl:when test="@top='true'">

    <xsl:variable name="Frame1"><xsl:value-of select="frame[1]"/></xsl:variable>
    <xsl:variable name="Frame2"><xsl:value-of select="frame[2]"/></xsl:variable>
    <xsl:variable name="Frame3"><xsl:value-of select="frame[3]"/></xsl:variable>

    <xsl:variable name="tab_value"><xsl:value-of select="@tab"/></xsl:variable>

    <HTML>
    <HEAD>
<!--    <xsl:call-template name="contextJavascript"/> -->
        <xsl:call-template name="javascript_vars"/>
        <SCRIPT SRC="js_context.js">alert('NotFound');</SCRIPT>

    <TITLE><xsl:value-of select="$errors_list_page_title"/></TITLE>
    </HEAD>
    <FRAMESET border="0" frameborder="0" rows="40,*,40">
      <FRAME name="tab" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" src="{$Frame1}"/>
      <FRAME name="main" frameborder="0" src="{$Frame2}"/>
      <FRAME name="button" marginheight="0" marginwidth="0" scrolling="no" scrollbars="no" frameborder="0" src="{$Frame3}"/>
    </FRAMESET>
    </HTML>

    </xsl:when>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 1">
              <xsl:call-template name="main_errors_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='button'">
      <xsl:for-each select="group">
        <xsl:if test="@name='button'">
          <xsl:call-template name="button_root"/>
        </xsl:if>
      </xsl:for-each>      
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (errors_list.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="tabs_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="0" marginheight="0" onload="window.focus">

<xsl:call-template name="load_tabs"/>

<FORM name="form" method="post">
<TABLE width="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD bgcolor="#000000"><TABLE width="100%" border="0" cellpadding="3" cellspacing="1">
      <TR bgcolor="{$bgcolor_table_mid}">
        <xsl:call-template name="tab_item">
          <xsl:with-param name="Index">1</xsl:with-param>
          <xsl:with-param name="Selected_Index"><xsl:value-of select="/calendar/@tab"/></xsl:with-param>
          <xsl:with-param name="Name">
            <xsl:value-of select="$errors_title"/><xsl:text> </xsl:text>
            <xsl:value-of select="$open_paren"/>
            <xsl:value-of select="/calendar/errorslist/@count"/>
            <xsl:value-of select="$close_paren"/>
          </xsl:with-param>
          <xsl:with-param name="Action"><xsl:value-of select="./tabs/tab[1]"/></xsl:with-param>
        </xsl:call-template>
        <TD align="right" bgcolor="{$bgcolor_table_top}"><FONT face="{$font_name}" size="{$font_size_big_2}"><xsl:text>&nbsp;</xsl:text></FONT></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML>
</xsl:template>

<xsl:template name="all_selection_row">
<xsl:param name="show_spacer"/>
<!-- Delete All row of the table -->
      <TR bgcolor="{$bgcolor_table_mid}">
        <TD width="1%" align="center" nowrap="">
        <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
            <xsl:value-of select="$delete_all_title"/><br/>
            <INPUT type="checkbox" name="alldelete">
              <xsl:attribute name="onClick">
                var f = document.forms[0];
                if ( f.alldelete_checked.value == 0 ) {
                  for (i = 0; i &lt; f.elements.length; i++) {
                    if (f.elements[i].name.substr(0, 11) == 'errordelete') {
                      (f.elements[i]).checked=1;
                    } else if (f.elements[i].name.substr(0, 9) == 'alldelete') {
                      (f.elements[i]).checked=1;
                    }
                  }
                  f.alldelete_checked.value = 1;
                } else {
                  for (i = 0; i &lt; f.elements.length; i++) {
                    if (f.elements[i].name.substr(0, 11) == 'errordelete') {
                      (f.elements[i]).checked=0;
                    } else if (f.elements[i].name.substr(0, 9) == 'alldelete') {
                      (f.elements[i]).checked=0;
                    }
                  }
                  f.alldelete_checked.value = 0;
                }
              </xsl:attribute>
            </INPUT>
          </FONT>
        </TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
      </TR>

      <xsl:if test="($show_spacer = 1)">
      <TR bgcolor="{$bgcolor_table_mid}">
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
      </TR>
      </xsl:if>
</xsl:template>

<xsl:template name="main_errors_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9">
<FORM name="form" method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>

<TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
  <TR>
    <TD colspan="2"><FONT face="{$font_name}" size="{$font_size_big}"><xsl:value-of select="$errors_msg"/></FONT></TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
</TABLE>
<TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
      <INPUT type="hidden" name="alldelete_checked" value="0" />
      <xsl:call-template name="all_selection_row">
        <xsl:with-param name="show_spacer">0</xsl:with-param>
        <xsl:with-param name="deleteall_name">alldelete_top</xsl:with-param>
      </xsl:call-template>
      <TR bgcolor="{$bgcolor_table_top}">
        <TD width="1%" nowrap="" align="left"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:value-of select="$delete_title"/></FONT></TD>
        <TD><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:value-of select="$event_title_title"/></FONT></TD>
        <TD width="1%" nowrap="" align="left"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:value-of select="$organizer_title"/></FONT></TD>
        <TD width="1%" nowrap="" align="left"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:value-of select="$attendee_title"/></FONT></TD>
        <TD align="left"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF"><xsl:value-of select="$event_title_title"/></FONT></TD>
      </TR>
      <xsl:for-each select="/calendar/errorslist/Event">
          <TR bgcolor="{$bgcolor_table_mid}">
            <TD width="1%" nowrap="" align="center" valign="top" bgcolor="{$bgcolor_table_mid}">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
              <INPUT type="checkbox">
                <xsl:attribute name="name">errordelete_<xsl:value-of select="@e_uid_encoded"/>_<xsl:value-of select="@e_rid"/>_<xsl:value-of select="@e_Calid_encoded"/></xsl:attribute>
                <xsl:attribute name="value">
<!-- don't translate this it's part of name sent back to server-->
                  <xsl:choose>
                    <xsl:when test="string-length(attendeeError/@errorRIDs) > 1">
                      <xsl:value-of select="attendeeError/@errorRIDs"/>
                    </xsl:when>
                    <xsl:otherwise><xsl:text>on</xsl:text></xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
              </INPUT>
              </FONT>
            </TD>
            <TD bgcolor="#FFFFFF">
                <xsl:call-template name="List_Event">
		    <xsl:with-param name="includeDate">true</xsl:with-param>
                    <xsl:with-param name="delete">false</xsl:with-param>
		</xsl:call-template>
              <xsl:text>&nbsp;</xsl:text>
            </TD>
            <TD width="1%" nowrap="" align="center">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                <A>
                  <xsl:attribute name="href">mailto:<xsl:value-of select="@e_OrganizerEmail"/></xsl:attribute>
                  <xsl:value-of select="@e_Organizer"/>
                </A>
              </FONT>
            </TD>
            <TD width="1%" align="center" nowrap="">
              <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
              <xsl:for-each select="attendeeError">
                <xsl:value-of select="@attendee"/><xsl:text>&nbsp;</xsl:text><BR/>
              </xsl:for-each>
              </FONT>
            </TD>
            <TD width="1%" nowrap="" align="left" valign="top" bgcolor="#FFFFFF">
              <FONT face="{$font_name}" size="{$font_size_big_2}">
                <xsl:for-each select="attendeeError">
                <xsl:call-template name="outputAttendeeError">
                  <xsl:with-param name="attendeeErrNum">
                    <xsl:value-of select="@errorNum"/>
                  </xsl:with-param>
                </xsl:call-template>
		(
                <xsl:value-of select="@recurringEventNum"/>
		) <xsl:text>&nbsp;</xsl:text><BR/>
<!--
                <INPUT type="hidden">
                  <xsl:attribute name="name">rids_errordelete_<xsl:value-of select="../@e_uid_encoded"/>_<xsl:value-of select="../@e_rid"/>_<xsl:value-of select="../@e_Calid_encoded"/></xsl:attribute>
                  <xsl:attribute name="value">
                    <xsl:value-of select="@errorRIDs"/>
                  </xsl:attribute>
                </INPUT>
-->
                </xsl:for-each>
              </FONT>
            </TD>
          </TR>
      </xsl:for-each>
      <xsl:if test="/calendar/errorslist/@count = 0">
        <TR>
          <TD colspan="4" align="left" valign="top" bgcolor="#FFFFFF">
            <FONT face="{$font_name}" size="{$font_size_big_2}">
              <CENTER><xsl:value-of select="$no_outstanding_errors_msg"/></CENTER>
            </FONT>
          </TD>
        </TR>
        <TR bgcolor="{$bgcolor_table_mid}">
          <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
          <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
          <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
          <TD width="1%" nowrap=""><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
          <TD><IMG src="imx/spacer.gif" width="1" height="1"/></TD>
        </TR>
      </xsl:if>
     
      <xsl:if test="/calendar/errorslist/@count != 0">
        <xsl:call-template name="all_selection_row">
          <xsl:with-param name="show_spacer">1</xsl:with-param>
          <xsl:with-param name="deleteall_name">alldelete_bottom</xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </TABLE></TD>
  </TR>
</TABLE>


</FORM>
</BODY>
</HTML>
</xsl:template>


<xsl:template name="button_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>

<BODY bgcolor="{$bgcolor_table_border}" marginwidth="0" marginheight="0">

<FORM name="form">
<TABLE width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
  <TR>
    <TD align="right" bgcolor="{$bgcolor_button}"><FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
      <INPUT type="button" name="ok" value="{$ok_title}" width="72">
      <xsl:attribute name="onClick">

          var f=parent.frames[1].document.forms[0];

          if (f.alldelete_checked.value == 0 ) {
            for (i = 0; i &lt; f.elements.length; i++) {
              if (f.elements[i].checked == 1) 
              break;
            }

            <!-- Nothing checked, so just close the error dialog -->
            if ( i == f.elements.length ) {
              parent.close();
              return; 
            }
          }

          if (!confirm('<xsl:value-of select="$errors_delete_confirm"/>'))
            return;

          if (form_submitted == '1') {
             alert('<xsl:value-of select="$alert_processing"/>');
             return;
          }
          form_submitted = '1';
          var x=parent.frames[1].document.forms[0].submit();
      </xsl:attribute>
      </INPUT>
      <INPUT type="button" name="esc" value="{$cancel_title}" onClick="parent.close();" width="72"/> 
      <INPUT type="button" name="help" value="{$help_title}" onClick="{button[@name='help']}" width="72"/></FONT> 
    </TD>
  </TR>
</TABLE>
</FORM>

</BODY>
</HTML></xsl:template>



</xsl:stylesheet>

