<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="text" encoding="UTF-8"/>

<xsl:template match="/">
  <xsl:text disable-output-escaping="yes">&lt;pre&gt;</xsl:text>

  <xsl:call-template name="outputXML">
    <xsl:with-param name="indent"/>
  </xsl:call-template>

  <xsl:text disable-output-escaping="yes">&lt;/pre&gt;</xsl:text>
</xsl:template>

<xsl:template name="outputXML">
  <xsl:param name="indent"/>

  <xsl:variable name="indentString" select="$indent"/>

  <!-- output tag -->
  <xsl:value-of select="$indentString"/>

  <xsl:text disable-output-escaping="yes">&amp;lt;</xsl:text>

  <xsl:value-of select="name(.)"/>

  <!-- output parameters -->
  <xsl:for-each select="@*">
    <xsl:text> </xsl:text>
    <xsl:value-of select="name(.)"/>
    <xsl:text>="</xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>"</xsl:text>
  </xsl:for-each>

  <xsl:text disable-output-escaping="yes">&amp;gt;
</xsl:text>

  <!-- output children -->
  <xsl:for-each select="">
    <xsl:call-template name="outputXML">
      <xsl:with-param name="indent">
        <xsl:value-of select="$indentString"/><xsl:text>  </xsl:text>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:for-each>

  <!-- output close tag -->
  <xsl:value-of select="$indentString"/>

  <xsl:text disable-output-escaping="yes">&amp;lt;/</xsl:text>

  <xsl:value-of select="name(.)"/>

  <xsl:text disable-output-escaping="yes">&amp;gt;
</xsl:text>

</xsl:template>

</xsl:stylesheet>

