<?xml version="1.0" encoding="UTF-8" ?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<xsl:template match="componentlist">
<!-- For Each ComponentGroup on this canvas, list appropriately -->

<!-- First handle the stuff that appears earlier before the beginning of the "day" -->

  <TR>
    <xsl:if test="$userprefs/@ceAllCalendarTZIDs = '1'">
<!-- For each "extra" time zone we need to make a row for that extra time information -->
     <xsl:for-each select="./AdditionalTZs/TZ">
       <TD width="1%" rowspan="2" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
<!-- TODO - TZ should have short name -->
        <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
          <xsl:value-of select="@name"/>
        </FONT>
       </TD>
     </xsl:for-each>
     </xsl:if>
        
<!-- Now the column for the default time zone -->
    <TD width="1%" rowspan="2" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
        <xsl:text>&nbsp;</xsl:text>
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
<!--
        <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">PST</FONT>
-->        
    </TD>

<!-- First print out the allday events and the overdue tasks -->

    <xsl:if test="ComponentGroup[@ComponentGroupType='overdue_tasks']!=0 or ComponentGroup[@ComponentGroupType='allday_events']">
    <TD bgcolor="{$bgcolor_form_selected}">
      <xsl:for-each select="./ComponentGroup">
        <xsl:if test="(@ComponentGroupType='overdue_tasks') or (@ComponentGroupType='allday_events')">
          <xsl:call-template name="topbottominterval"/>
        </xsl:if>
      </xsl:for-each>
    </TD>
    </xsl:if>
  </TR>

<!-- Spacer -->
  <TR>
    <TD bgcolor="{$bgcolor_table_top}">
      <IMG src="imx/spacer.gif" width="1" height="1" border="0"/>
    </TD>
  </TR>

<!-- Now handle the day -->
<!-- Now start the TIME BLOCKS part of the table -->
<xsl:for-each select="timeblockset/timeblock">
<TR>
<!-- save the block number for passing in to a later template -->
  <xsl:variable name="blockNumber">
    <xsl:value-of select="@number"/>
  </xsl:variable>

<!-- first print the time value of the block -->
    <xsl:for-each select="../../ComponentGroup[@ComponentGroupType='group']">
      <xsl:if test="position()=$blockNumber">

    <xsl:if test="$userprefs/@ceAllCalendarTZIDs = '1'">
<!-- are there any additional tzs to output time for -->
        <xsl:for-each select="./StartTime/ExtraTZ">
<TD width="1%" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
          <xsl:call-template name="formatTime">
            <xsl:with-param name="ftHour" select="@hour"/>
            <xsl:with-param name="ftMinute" select="@minute"/>
          </xsl:call-template>
  </FONT>
</TD>
        </xsl:for-each>
      </xsl:if>

<TD width="1%" align="right" valign="top" nowrap="" bgcolor="{$bgcolor_button}">
  <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
<!-- and now for the default time zone time information -->
        <xsl:call-template name="formatTime">
          <xsl:with-param name="ftHour" select="./StartTime/@hour"/>
          <xsl:with-param name="ftMinute" select="./StartTime/@minute"/>
        </xsl:call-template>
        <xsl:if test="($username != 'anonymous') and ($view != 'print')">
          <A>

          <xsl:attribute name="href">
            <xsl:value-of select="substring-before((../command[1]),'fillindate')"/>
            <xsl:value-of select="./StartTime/@iso"/>
            <xsl:value-of select="substring-before(substring-after((../command[1]),'fillindate'), 'extraargs')"/>
             <xsl:choose>
              <xsl:when test="(string-length($usrctx/@selectedGroup) > 0) and (string-length($usrctx/@selectedCalendar) = 0)"><xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="$username"/></xsl:when>
              <xsl:otherwise><xsl:text>extraargs</xsl:text></xsl:otherwise>
              </xsl:choose>
            <xsl:value-of select="substring-after((../command[1]),'extraargs')"/>
          </xsl:attribute>

          <IMG src="imx/new.gif" width="16" height="16" border="0" alt="{$alt_schedule_new_appt}"/>
          </A>
        </xsl:if>
  </FONT>
</TD>
      </xsl:if>
    </xsl:for-each>

<!-- now for each day, print any data from the right block -->
  <xsl:for-each select="../../../componentlist">        
    <xsl:call-template name="interval">
        <xsl:with-param name="blocknumber">
          <xsl:value-of select="$blockNumber"/>
        </xsl:with-param>
    </xsl:call-template>
  </xsl:for-each>
</TR>
</xsl:for-each>

<!-- Now handle notime (eg allday) tasks -->
  <TR>

    <xsl:if test="/calendar/usrctx/userprefs/@ceAllCalendarTZIDs = '1'">
<!-- For each "extra" time zone we need to make a row for that extra time information -->
     <xsl:for-each select="./AdditionalTZs/TZ">
       <TD width="1%" rowspan="3" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
           <xsl:text>&nbsp;</xsl:text>
       </TD>
     </xsl:for-each>
    </xsl:if>

    <TD width="1%" rowspan="3" align="right" valign="bottom" nowrap="" bgcolor="{$bgcolor_button}">
        <xsl:text>&nbsp;</xsl:text>
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
<!--
      <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">PST
      </FONT>
-->      
    </TD>

<!-- Spacer -->
    <TD bgcolor="{$bgcolor_table_top}">
      <IMG src="imx/spacer.gif" width="1" height="1" border="0"/>
    </TD>
  </TR>
  <TR>

    <xsl:if test="(count(ComponentGroup[@ComponentGroupType='onday_tasks'])!=0) or (count(ComponentGroup[@ComponentGroupType='nodate_tasks'])!=0)">
    <TD bgcolor="{$bgcolor_form_selected}">
      <xsl:for-each select="./ComponentGroup">
        <xsl:if test="(@ComponentGroupType='onday_tasks') or (@ComponentGroupType='nodate_tasks')">
          <xsl:call-template name="topbottominterval"/>
        </xsl:if>
      </xsl:for-each>
    </TD>
    </xsl:if>
  </TR>
</xsl:template>

<!-- simple listing for allday events, notime (eg allday) tasks, etc -->
<xsl:template name="topbottominterval">
<xsl:call-template name="ComponentGroup"/>
</xsl:template>

<xsl:template name="interval">
  <xsl:param name="blocknumber"/>
  
<xsl:for-each select="ComponentGroup[@ComponentGroupType='group']">
  <xsl:if test="(position()=$blocknumber)">
<!-- if the last row was a multirow block, skip this one -->
    <xsl:if test="@numIntervals!='0'">
      <xsl:variable name="bgcolorselect">
        <xsl:choose>
        <xsl:when test="count(./ComponentGroup)>0"><xsl:value-of select="$bgcolor_form_selected"/></xsl:when>
        <xsl:when test="(./StartTime/@dow=1) or (./StartTime/@dow=7)"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$bgcolor_table_mid"/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="intervals"><xsl:value-of select="@numIntervals"/></xsl:variable>
       <TD width="14%" valign="top" bgcolor="{$bgcolorselect}" rowspan="{$intervals}">
         <!-- now go ahead and print out the events/tasks if there are any -->
         <xsl:for-each select="ComponentGroup">
         <xsl:call-template name="limitedComponentGroup"/>
         </xsl:for-each>
        <!-- if it's an empty cell, put a spacer in to set the cell -->
         <xsl:if test="count(./ComponentGroup)=0">
         <xsl:text>&nbsp;</xsl:text>
         </xsl:if>
       </TD>
    </xsl:if>
  </xsl:if>
</xsl:for-each>
</xsl:template>

<xsl:template match="panel">
  <xsl:choose>
    <xsl:when test="@name='singleDayTimeHeader'">
      <TR>
      <TD align="left">
        <xsl:call-template name="singleDayTimeHeaderTemplate"/>
      </TD>
      <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>        
      </TD>
      </TR>
    </xsl:when>

    <xsl:when test="@name='singleDayView'">
      <TR>
      <TD colspan="2">
      <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
        <TR>
          <TD bgcolor="{$bgcolor_table_border}">
            <TABLE border="0" cellpadding="3" cellspacing="1" width="100%">
              <xsl:apply-templates select="componentlist"/>
            </TABLE>
          </TD>
        </TR>
      </TABLE>
      </TD>
      </TR>
    </xsl:when>
 
    <xsl:when test="@name='miniview'">
        <xsl:apply-templates select="panel"/>
        <HR size="{$font_size_big}"/>
    </xsl:when>
 
    <xsl:when test="@name='minical'">
      <xsl:apply-templates select="minical"/>
    </xsl:when>

    <xsl:when test="@name='tasktable'">
      <xsl:call-template name="tasktable"/>
    </xsl:when>

    <xsl:otherwise>
    <TABLE border="0">
      <xsl:apply-templates select="panel"/> 
    </TABLE>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

</xsl:stylesheet>
