<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


<xsl:template name="printDateHeader">
<xsl:param name="format"/>

<TABLE border="0">
<TR>
<xsl:choose>

  <xsl:when test="$format='weekview'">
      <TD nowrap="">
        <xsl:call-template name="weekTimeHeader"/>
   </TD>
  </xsl:when>

  <xsl:when test="$format='monthview'">
      <TD nowrap="">
        <xsl:call-template name="monthTimeHeader"/>
      </TD>
  </xsl:when>

  <xsl:when test="$format='yearview'">
      <TD nowrap="">
        <xsl:call-template name="yearTimeHeader"/>
      </TD>
  </xsl:when>

  <xsl:otherwise>
        <TD nowrap="">
          <xsl:call-template name="dayTimeHeader"/>
       </TD>
  </xsl:otherwise>
</xsl:choose>
</TR>
</TABLE>
</xsl:template>

<xsl:template name="printMinical">
<TABLE border="0" cellpadding="1" cellspacing="0">
  <TR>
    <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="2" cellspacing="1">
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
        <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}"><xsl:apply-templates select="../timectx/StartTime/@month"/></FONT>
        </TD>
      </TR>
      <TR>
        <xsl:for-each select="Row[1]/Time">
          <TD align="center">
            <xsl:attribute name="bgcolor">
              <xsl:choose>
                <xsl:when test="(@dow=1) or (@dow=7)">
                  <xsl:value-of select="$bgcolor_wend_top"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$bgcolor_table_top"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
              <xsl:call-template name="short_dow">
                <xsl:with-param name="downum" select="@dow"/>
              </xsl:call-template>
            </FONT>
          </TD>
       </xsl:for-each>
      </TR>
      <xsl:for-each select="Row">
      <TR>
        <xsl:for-each select="Time">
          <TD align="right">
            <xsl:choose>
              <xsl:when test="../../../timectx/SelectedTime/@month!=@month">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_border"/> 
                </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_shadow_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
              </xsl:when>
              <xsl:when test="../../../timectx/SelectedTime/@date=@date">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_selected"/> 
                </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="${color_minical_bold_text}">
                    <B><xsl:value-of select="@date"/></B>
                  </FONT>
              </xsl:when>
              <xsl:when test="(@dow=1) or (@dow=7)">
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_wend_mid"/>
                </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="bgcolor">
                  <xsl:value-of select="$bgcolor_table_mid"/>
                </xsl:attribute>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
                    <xsl:value-of select="@date"/>
                  </FONT>
              </xsl:otherwise>
            </xsl:choose>
          </TD>
        </xsl:for-each>
      </TR>
      </xsl:for-each>
      <TR>
        <TD colspan="7" align="center" bgcolor="{$bgcolor_table_top}">
          <FONT face="{$font_name}" size="{$font_size_big}" color="{$color_minical_text}">
            <xsl:value-of select="$today_is_msg"/><xsl:text>&nbsp;</xsl:text>
              <FONT color="{$color_minical_text}">
                <xsl:call-template name="brief_date">
                  <xsl:with-param name="Month">
                    <xsl:value-of select="../timectx/CurrTime/@month"/>
                  </xsl:with-param>
                  <xsl:with-param name="Day">
                    <xsl:value-of select="../timectx/CurrTime/@date"/>
                  </xsl:with-param>
                  <xsl:with-param name="Year">
                    <xsl:value-of select="../timectx/CurrTime/@year"/>
                  </xsl:with-param>
                </xsl:call-template>
              </FONT>
          </FONT>
        </TD>
      </TR>
    </TABLE>
    </TD>
</TR>
<TR>
  <TD>
    <IMG src="imx/spacer.gif" width="1" height="1" vspace="4"/>
  </TD>
</TR>
</TABLE>
</xsl:template>
        
</xsl:stylesheet>
