<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" encoding="UTF-8"/>

<xsl:include href="common.xsl"/>
<xsl:include href="i18n.xsl"/>
<xsl:include href="date_format.xsl"/>
<xsl:include href="dialog_tabs.xsl"/>
<xsl:include href="event_tabs.xsl"/>

<xsl:template match="/">
  <xsl:apply-templates select="calendar"/>      
</xsl:template>

<xsl:template match="calendar">

  <xsl:choose>

    <xsl:when test="@view='tabs'">
      <xsl:for-each select="group">
        <xsl:if test="@name='tabs'">
          <xsl:call-template name="tabs_root"/>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:when test="@view='main'">
      <xsl:for-each select="group">
        <xsl:if test="@name='main'">
          <xsl:choose>

            <xsl:when test="/calendar/@tab = 4">
              <xsl:call-template name="availability_root"/>
            </xsl:when>

            <xsl:otherwise>
              <B><xsl:value-of select="/calendar/@tab"/></B>   
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
      <html>What's this view? (availability.xsl) -<xsl:value-of select="@view"/></html>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<xsl:template name="availability_root">
<HTML>
  <xsl:call-template name="emit_frame_head_tag"/>
<!--  <xsl:call-template name="dateChecking"/> -->
    <xsl:call-template name="javascript_strings"/>
    <SCRIPT SRC="js_date_checking.js">alert('NotFound!');</SCRIPT>

<BODY bgcolor="{$bgcolor_background}" background="imx/ltgrey.gif" marginwidth="9" marginheight="9" onload="window.focus();">
<SCRIPT language="javascript">
function setLocalTime(hour, minutes, pm)
{
  var f = document.forms[0];
  f['hr'].value = parseInt(hour,10);
  f['mn'].value = minutes;
  if (pm) {
    f['pm'].selectedIndex = 1;
  } else {
    f['pm'].selectedIndex = 0;    
  }
}
function setLocal24Time(hour, minutes)
{
  var f = document.forms[0];
  f['hr'].value = hour;
  f['mn'].value = minutes;
}

function setLocalDate(year, month, day)
{
  var f = document.forms[0];
  f['ccyy'].value = year;
  f['mm'].value = month;
  f['dd'].value = day;
  f['type'].value='availability';
  f['i_tabswitch'].value=<xsl:value-of select="/calendar/@tab"/>;
  f.submit();
}


</SCRIPT>
<FORM method="post">
  <xsl:attribute name="action"><xsl:value-of select="./formdata/@action"/></xsl:attribute>
  <xsl:attribute name="name">form</xsl:attribute>
  <xsl:apply-templates select="formdata"/>
  <INPUT type="hidden" name="absalarmset"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_alarm_absolute_trigger"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firsthour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="firstminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/AbsoluteAlarmTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondyear"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@year"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondmonth"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@month"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@date"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondhour"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@hour"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="secondminute"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/StartTime/@minute"/></xsl:attribute></INPUT>
  <INPUT type="hidden" name="isallday"><xsl:attribute name="value"><xsl:value-of select="./eventdata/Event/@e_allday"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="isprivate"><xsl:attribute name="value"><xsl:choose><xsl:when test="((../eventdata/Event/@e_Class) and (../eventdata/Event/@e_Class = 'private'))">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>
<INPUT type="hidden" name="isopaque"><xsl:attribute name="value"><xsl:choose><xsl:when test="(../eventdata/Event/@e_opaque = 'true')">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:attribute></INPUT>


<CENTER>
<TABLE border="0" cellpadding="3" cellspacing="1">
<!-- Insert errors here-->
<xsl:call-template name="emit_new_event_errors"/>
  <TR>
    <TD align="right" valign="middle"><A><xsl:attribute name="href"><xsl:value-of select="command[@name='back']"/></xsl:attribute><IMG src="imx/prev.gif" width="13" height="13" border="0" alt="{$alt_jump_prev_day}"/>
           </A><BR/>
           <A><xsl:attribute name="href"><xsl:value-of select="command[@name='forward']"/></xsl:attribute>
    <IMG src="imx/next.gif" width="13" height="13" border="0" alt="{$alt_jump_next_day}"/>
    </A></TD>
    <TD align="left" valign="baseline">
      <xsl:call-template name="date_selector">
        <xsl:with-param name="month" select="./eventdata/Event/StartTime/@month" />
        <xsl:with-param name="day" select="./eventdata/Event/StartTime/@date" />
        <xsl:with-param name="year" select="./eventdata/Event/StartTime/@year" />
      </xsl:call-template>
      <A>
        <xsl:attribute name="href">
          <xsl:value-of select="command[@name='jump_to']"/>
        </xsl:attribute>
        <IMG src="imx/goto2.gif" width="24" height="24" align="absmiddle" border="0" alt="{$alt_jump_new_date}"/>
      </A>
   
      <xsl:text>&nbsp;</xsl:text>
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <INPUT type="button" name="availabilityUpdate" width="72" value="{$show_availability_title}">
          <xsl:attribute name="onClick">
            var f=document.forms[0];
            f['type'].value='availability';
            f['i_tabswitch'].value=<xsl:value-of select="/calendar/@tab"/>;
            f.submit();
          </xsl:attribute>
        </INPUT>
      </FONT>
   </TD>
   </TR>
   <TR>
    <TD></TD>
    <TD align="left" valign="baseline">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
      <xsl:value-of select="$starting_at_txt"/><xsl:text>&nbsp;</xsl:text>
      </FONT>
      <xsl:call-template name="duration_selector">
        <xsl:with-param name="ds_start_hour" select="./eventdata/Event/StartTime/@hour" />
        <xsl:with-param name="ds_start_min" select="./eventdata/Event/StartTime/@minute" />
        <xsl:with-param name="dur_hour" select="./eventdata/Event/@e_durhour" />
        <xsl:with-param name="dur_min" select="./eventdata/Event/@e_durmin" />
      </xsl:call-template>
    </TD>
  </TR>
  <TR><TD colspan="2"><HR size="{$font_size_big}"/></TD></TR>
  <TR>
    <TD colspan="2" align="center"><TABLE border="0" cellpadding="1" cellspacing="0">
      <TR>
        <TD bgcolor="{$bgcolor_table_border}"><TABLE border="0" cellpadding="2" cellspacing="1">
          <TR align="center" bgcolor="#FFFFFF">
            <TD align="center" bgcolor="#FFFFFF" nowrap=""><FONT face="{$font_name}" size="{$font_size_big}" color="#000000"><xsl:value-of select="$available_title"/></FONT></TD>
            <TD align="center" bgcolor="{$bgcolor_table_top}" background="imx/hash-1.gif" nowrap=""><FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:value-of select="$busy_title"/></FONT></TD>
            <xsl:for-each select="./eventdata/Event/freeBusy">
              <xsl:for-each select="freeBusyBlock">
                <TD>
                  <xsl:choose>
                    <xsl:when test="@free!=1">
                      <xsl:attribute name="colspan">
                        <xsl:choose>
                          <xsl:when test="(@timeAvailable mod (/usrctx/@intervalMinutes)) != 0">
                            <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes)) + 1"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes))"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:attribute>
                      <xsl:attribute name="bgcolor">
                        <xsl:value-of select="$bgcolor_table_top"/>
                      </xsl:attribute>
                      <xsl:attribute name="background">imx/hash-1.gif</xsl:attribute>
                      <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF"><xsl:text>&nbsp;</xsl:text></FONT>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:if test="$username != 'anonymous'">
                       <A>
                        <xsl:attribute name="href">
                          <xsl:choose>
                          <xsl:when test="/calendar/usrctx/userprefs/@ceClock='12'">javascript:setLocalTime('<xsl:choose><xsl:when test="(./StartTime/@hour = 0) or (./StartTime/@hour = 12)">12</xsl:when><xsl:otherwise><xsl:value-of select="(./StartTime/@hour) mod 12"/></xsl:otherwise></xsl:choose>','<xsl:value-of select="./StartTime/@minute"/>',<xsl:choose><xsl:when test="./StartTime/@hour >= 12">1</xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose>);</xsl:when>
                        <xsl:otherwise>javascript:setLocal24Time('<xsl:value-of select="./StartTime/@hour"/>','<xsl:value-of select="./StartTime/@minute"/>');</xsl:otherwise></xsl:choose>
                        </xsl:attribute>

                        <IMG src="imx/new.gif" width="16" height="16" border="0">
                          <xsl:attribute name="alt">
                            <xsl:call-template name="available_time_message">
                              <xsl:with-param name="ftHour" select="./StartTime/@hour"/>
                              <xsl:with-param name="ftMinute" select="./StartTime/@minute"/>
                              <xsl:with-param name="timeAvail" select="@timeAvailable"/>
                            </xsl:call-template>
                          </xsl:attribute>
                        </IMG>
                       </A>
                      </xsl:if>
                    </xsl:otherwise>
                  </xsl:choose>
                </TD>
              </xsl:for-each>
            </xsl:for-each>
          </TR>
          <TR bgcolor="{$bgcolor_table_cell}">

<!-- XXX: TODO: PST is hard-coded here                    -->


            <TD colspan="2" align="right" bgcolor="{$bgcolor_button}" nowrap="">
<!-- TODO - put in variable call to pick up CORRECT TZ abbreviation -->
           <xsl:text>&nbsp;</xsl:text>
            </TD>
            <xsl:for-each select="./eventdata/Event/freeBusy">
              <xsl:for-each select="freeBusyBlock">
                <TD nowrap="">
                  <xsl:if test="@free!=1">
                    <xsl:attribute name="colspan">
                      <xsl:choose>
                        <xsl:when test="(@timeAvailable mod (/usrctx/@intervalMinutes)) != 0">
                          <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes)) + 1"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes))"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:attribute>
                  </xsl:if>
                  <FONT face="{$font_name}" size="{$font_size_big}" color="#000000">
                    <xsl:call-template name="formatTime">
                      <xsl:with-param name="ftHour">
                        <xsl:value-of select="./StartTime/@hour"/>
                      </xsl:with-param>
                      <xsl:with-param name="ftMinute">
                        <xsl:value-of select="./StartTime/@minute"/>
                      </xsl:with-param>
                      </xsl:call-template>
                  </FONT>
                </TD>
              </xsl:for-each>
            </xsl:for-each>
          </TR>

<!-- Output invitee info -->
        <xsl:for-each select="./eventdata/Event/attendeeFreeBusy">
          <TR valign="top" bgcolor="#FFFFFF">
            <TD colspan="2" align="right" nowrap="" bgcolor="{$bgcolor_button}">

<!-- XXXX: TODO: MAKE THIS LINK TO THE USER'S DAY VIEW -->

              <A href="javascript:void();" style="text-decoration:none;">
                <FONT face="{$font_name}" size="{$font_size_big}" color="#FFFFFF">
                  <xsl:call-template name="printCalendarName">
                    <xsl:with-param name="name" select="@invitee"/>
                  </xsl:call-template>
                </FONT>
              </A>
            </TD>
            <xsl:for-each select="./freeBusy">
              <xsl:for-each select="freeBusyBlock">
                <TD>
                    <xsl:choose>
                      <xsl:when test="@accessDenied=1">
                        <xsl:attribute name="colspan">
                          <xsl:value-of select="@span"/>
                        </xsl:attribute>
                        <xsl:attribute name="bgcolor">#FFFF00</xsl:attribute>
                        <xsl:attribute name="align">center</xsl:attribute>
                      </xsl:when>
                      <xsl:when test="(@timeAvailable mod (/usrctx/@intervalMinutes)) != 0">
                        <xsl:attribute name="colspan">
                          <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes)) + 1"/>
                        </xsl:attribute>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:attribute name="colspan">
                          <xsl:value-of select="(@timeAvailable div (/usrctx/@intervalMinutes))"/>
                        </xsl:attribute>
                      </xsl:otherwise>
                    </xsl:choose>
                  <xsl:if test="@free=0">
                    <xsl:attribute name="background">imx/hash-1.gif</xsl:attribute>
                    <xsl:attribute name="bgcolor">
                      <xsl:value-of select="$bgcolor_table_top"/>
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:if test="@accessDenied=1">
                   <FONT face="{$font_name}" size="{$font_size_big}" color="#000000"><xsl:value-of select="$unknown_text"/></FONT>
                  </xsl:if>
                  <xsl:text>&nbsp;</xsl:text>
                </TD>
              </xsl:for-each>
            </xsl:for-each>
          </TR>
        </xsl:for-each>

        </TABLE></TD>
      </TR>
    </TABLE></TD>
  </TR>
</TABLE>
</CENTER>

</FORM>
</BODY>
</HTML>
</xsl:template>

</xsl:stylesheet>
