<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- set the output properties -->
<xsl:output method="html" version="4" encoding="UTF-8"/>

<!-- Include main display XSL instructions -->
<xsl:include href="common_view.xsl"/>

<xsl:template match="panel">
  <xsl:choose>
<!-- Each "GROUP" contains two super-panels, this one and miniview -->

    <xsl:when test="@name='monthview-panel'">
    <TABLE border="0">
      <xsl:apply-templates select="panel"/>
    </TABLE>
    </xsl:when>

    <xsl:when test="@name='miniview'">
        <xsl:apply-templates select="panel"/>
        <HR size="{$font_size_big}"/>
    </xsl:when>

<!--  These are the inner panels -->
    <xsl:when test="@name='singleMonthTimeHeader'">
      <TR>
        <TD nowrap="" align="left">
        <xsl:call-template name="singleMonthTimeHeaderTemplate"/>
        </TD>
        <TD nowrap="" align="right">
        <xsl:call-template name="viewtabs"/>
        </TD>
      </TR>
    </xsl:when>

    <xsl:when test="@name='singleMonthView'">
      <TR>
        <TD width="100%" colspan="2">
      <xsl:apply-templates select="monthcal"/>
        </TD>
      </TR>
    </xsl:when>
 
    <xsl:when test="@name='minical'">
      <xsl:apply-templates select="minical"/>
    </xsl:when>

    <xsl:when test="@name='tasktable'">
      <xsl:call-template name="tasktable"/>
    </xsl:when>

<!-- We should never get here! -->
    <xsl:otherwise>
      <xsl:apply-templates select="panel"/> 
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="monthcal">

<xsl:variable name="borderwidth">
   <xsl:choose>
    <xsl:when test="$view = 'print'">2</xsl:when>
    <xsl:otherwise>0</xsl:otherwise>
   </xsl:choose>
</xsl:variable>

    <TABLE border="0" cellpadding="1" cellspacing="0" width="100%">
      <TR>
       <TD bgcolor="{$bgcolor_table_border}">
	<TABLE border="{$borderwidth}" cellpadding="2" cellspacing="1" width="100%">
          <TR bgcolor="{$bgcolor_table_top}" align="center">  
            <xsl:for-each select="Row[1]/monthday">
              <TD align="center">
                <xsl:attribute name="bgcolor">
                  <xsl:choose>
                    <xsl:when test="(@dow=1) or (@dow=7)">
                      <xsl:value-of select="$bgcolor_wend_top"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="$bgcolor_table_top"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <FONT face="{$font_name}" size="{$font_size_big_2}" color="#FFFFFF">
                  <xsl:apply-templates select="@dow"/>
                </FONT>
              </TD>
           </xsl:for-each>
          </TR>
        <xsl:for-each select="Row">
          <TR bgcolor="{$bgcolor_table_mid}">  
<!-- Write the date of each monthday in the row -->
          <xsl:for-each select="monthday">
            <xsl:variable name="bgcolorchoice">
            <xsl:choose>
            <xsl:when test="../../@month!=@month"><xsl:value-of select="$bgcolor_table_border"/></xsl:when>
            <xsl:when test="(@dow=1) or (@dow=7)"><xsl:value-of select="$bgcolor_wend_mid"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$bgcolor_table_mid"/></xsl:otherwise>
            </xsl:choose>
            </xsl:variable>
            <TD width="14%" nowrap="" bgcolor="{$bgcolorchoice}">
        <xsl:choose>
        <xsl:when test="../../@month!=@month">
        <xsl:choose>
          <xsl:when test="$view = 'print'">
            <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="{$bgcolor_table_mid}">
            <xsl:value-of select="@date"/>        
            </FONT>
          </xsl:when>
          <xsl:otherwise>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute>
                  <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="{$bgcolor_table_mid}">
                  <xsl:value-of select="@date"/>        
                  </FONT>
                </A>
         </xsl:otherwise>
       </xsl:choose>                
       </xsl:when>
       <xsl:otherwise>
        <xsl:choose>
        <xsl:when test="$view = 'print'">
          <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">
          <xsl:value-of select="@date"/>        
          </FONT>
        </xsl:when>
        <xsl:otherwise>
                <A style="text-decoration:none;">
                  <xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute>
                  <FONT face="Verdana,sans-serif" size="{$font_size_big_2}" color="#FFFFFF">
                  <xsl:value-of select="@date"/>        
                  </FONT>
                </A>
        </xsl:otherwise>
        </xsl:choose>
       </xsl:otherwise>
       </xsl:choose>
            </TD>
          </xsl:for-each>
          </TR>
<!-- Write the info for each monthday in the row -->
          <TR bgcolor="{$bgcolor_table_cell}">
          <xsl:for-each select="monthday">
            <xsl:variable name="bgcolorcell">
            <xsl:choose>
            <xsl:when test="./ComponentGroup"><xsl:value-of select="$bgcolor_form_selected"/></xsl:when>
            <xsl:when test="(@dow=1) or (@dow=7)"><xsl:value-of select="$bgcolor_wend_cell"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$bgcolor_table_mid"/></xsl:otherwise>
            </xsl:choose>
            </xsl:variable>

            <TD bgcolor="{$bgcolorcell}">
            <xsl:choose>
              <xsl:when test="ComponentGroup">
                <xsl:for-each select="./ComponentGroup">
                  <xsl:call-template name="limitedComponentGroup"/>
                </xsl:for-each>
                <xsl:if test="($username != 'anonymous') and ($view != 'print')">
                  <A>
                    <xsl:attribute name="href">
                      <xsl:value-of select="substring-before((command[2]),'extraargs')"/>
                       <xsl:choose>
                       <xsl:when test="$usrctx/@selectedGroup and not($usrctx/@selectedCalendar)">
                         <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="$username"/>
                      </xsl:when>
                      <xsl:otherwise><xsl:text>extraargs</xsl:text></xsl:otherwise>
                      </xsl:choose>
                      <xsl:value-of select="substring-after((command[2]),'extraargs')"/>
                    </xsl:attribute>

                    <IMG src="imx/new.gif" width="16" height="16" border="0" alt="Schedule a new appointment"/>
                  </A>
                </xsl:if>
              </xsl:when>
<!-- There are no components for this day -->
            <xsl:otherwise>
<!-- Now special case the various empty days -->         
                <xsl:choose>
<!-- If we're displaying an "end" day in the month -->
                <xsl:when test="(@dow=1) or (@dow=7)">
                 <xsl:text> &nbsp;</xsl:text>
                </xsl:when>
<!-- It's a regular empty day in this month -->
                <xsl:otherwise>
                  <xsl:text>&nbsp;</xsl:text>
              </xsl:otherwise>    
                </xsl:choose>
                <xsl:if test="($username != 'anonymous') and ($view != 'print')">
                <A>
                    <xsl:attribute name="href">
                      <xsl:value-of select="substring-before((command[2]),'extraargs')"/>
                       <xsl:choose>
                       <xsl:when test="$usrctx/@selectedGroup and not($usrctx/@selectedCalendar)">
                       <xsl:text disable-output-escaping="yes">&amp;calid=</xsl:text><xsl:value-of select="$username"/>
                      </xsl:when>
                      <xsl:otherwise><xsl:text>extraargs</xsl:text></xsl:otherwise>
                      </xsl:choose>
                      <xsl:value-of select="substring-after((command[2]),'extraargs')"/>
                    </xsl:attribute>

                  <IMG src="imx/new.gif" width="16" height="16" border="0" alt="Schedule a new appointment"/>
                </A>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
          </TD>
          </xsl:for-each>
          </TR>
          </xsl:for-each>
       </TABLE>
      </TD>
    </TR>
</TABLE>
</xsl:template>


<xsl:template name="singleMonthTimeHeaderTemplate">
    <TABLE border="0" cellpadding="2" cellspacing="0" width="100%">
    <TR>
      <TD nowrap="">
        <A>
          <xsl:attribute name="href"><xsl:value-of select="command[1]"/></xsl:attribute>
          <IMG src="imx/ppage-1.gif" width="15" height="15" border="0" alt="Jump to the previous month" align="left"/>
        </A>
        <BR/>
        <A>
          <xsl:attribute name="href"><xsl:value-of select="command[2]"/></xsl:attribute>
          <IMG src="imx/npage-1.gif" width="15" height="15" border="0" alt="Jump to the next month" align="left"/>
        </A>
        <BR/>
      </TD>
      <TD nowrap="">
        <xsl:call-template name="monthTimeHeader"/>
      </TD>
<!--
      <TD align="right" valign="bottom">
          <xsl:call-template name="viewtabs"/>
      </TD>
-->      
    </TR>
    </TABLE>
</xsl:template>

</xsl:stylesheet>
