<?xml version="1.0"?>

<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!-- <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:space="preserve"> -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!-- GENERAL NOTE -->
<!-- This file can be localized as required -->
<!-- This file contains the text strings referenced in non-localized xsl files as well -->
<!-- as the text strings used in date_format.xsl (which is localized) so that date_format -->
<!-- need only be localized for languages whose format or layout differs from that of english -->

<xsl:variable name="no_title">
  Untitled
</xsl:variable>

<xsl:template match="@dow">
  <xsl:if test=".='1'">Sunday</xsl:if>
  <xsl:if test=".='2'">Monday</xsl:if>
  <xsl:if test=".='3'">Tuesday</xsl:if>
  <xsl:if test=".='4'">Wednesday</xsl:if>
  <xsl:if test=".='5'">Thursday</xsl:if>
  <xsl:if test=".='6'">Friday</xsl:if>
  <xsl:if test=".='7'">Saturday</xsl:if>
</xsl:template>

<xsl:template name="short_dow">
  <xsl:param name="downum"/>

  <xsl:if test="$downum='1'">S</xsl:if>
  <xsl:if test="$downum='2'">M</xsl:if>
  <xsl:if test="$downum='3'">T</xsl:if>
  <xsl:if test="$downum='4'">W</xsl:if>
  <xsl:if test="$downum='5'">T</xsl:if>
  <xsl:if test="$downum='6'">F</xsl:if>
  <xsl:if test="$downum='7'">S</xsl:if>
</xsl:template>


<xsl:template match="@month">
  <xsl:if test=".='01'">Jan</xsl:if>
  <xsl:if test=".='02'">Feb</xsl:if>
  <xsl:if test=".='03'">March</xsl:if>
  <xsl:if test=".='04'">April</xsl:if>
  <xsl:if test=".='05'">May</xsl:if>
  <xsl:if test=".='06'">June</xsl:if>
  <xsl:if test=".='07'">July</xsl:if>
  <xsl:if test=".='08'">Aug</xsl:if>
  <xsl:if test=".='09'">Sep</xsl:if>
  <xsl:if test=".='10'">Oct</xsl:if>
  <xsl:if test=".='11'">Nov</xsl:if>
  <xsl:if test=".='12'">Dec</xsl:if>
</xsl:template>

<xsl:template name="monthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">Jan</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">Feb</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">Mar</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">Apr</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">May</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">Jun</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">Jul</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">Aug</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">Sep</xsl:if>
  <xsl:if test="$MonthNum=10">Oct</xsl:if>
  <xsl:if test="$MonthNum=11">Nov</xsl:if>
  <xsl:if test="$MonthNum=12">Dec</xsl:if>
</xsl:template>

<xsl:template name="longMonthName">
  <xsl:param name="MonthNum"/>

  <xsl:if test="($MonthNum=1) or ($MonthNum='01')">January</xsl:if>
  <xsl:if test="($MonthNum=2) or ($MonthNum='02')">February</xsl:if>
  <xsl:if test="($MonthNum=3) or ($MonthNum='03')">March</xsl:if>
  <xsl:if test="($MonthNum=4) or ($MonthNum='04')">April</xsl:if>
  <xsl:if test="($MonthNum=5) or ($MonthNum='05')">May</xsl:if>
  <xsl:if test="($MonthNum=6) or ($MonthNum='06')">June</xsl:if>
  <xsl:if test="($MonthNum=7) or ($MonthNum='07')">July</xsl:if>
  <xsl:if test="($MonthNum=8) or ($MonthNum='08')">August</xsl:if>
  <xsl:if test="($MonthNum=9) or ($MonthNum='09')">September</xsl:if>
  <xsl:if test="$MonthNum=10">October</xsl:if>
  <xsl:if test="$MonthNum=11">November</xsl:if>
  <xsl:if test="$MonthNum=12">December</xsl:if>
</xsl:template>

<xsl:template name="findErrorString">
  <xsl:param name="ErrorType"/>

  <xsl:choose>
    <xsl:when test="($ErrorType='INVALID_STARTDATETIME') or ($ErrorType='INVALID_ENDDATETIME')">
      The date and time you entered is invalid. Please correct it.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWCAL_EXISTING'">
      A calendar already exists with this name. Please choose another name.
    </xsl:when>
    <xsl:when test="$ErrorType='NEWGROUP_EXISTING'">
      A group already exists with this name. Please choose another name.
    </xsl:when>
<!-- Can't do an "otherwise" because failure to find string indicates no error -->
  </xsl:choose>
</xsl:template>

<xsl:template name="outputGroupClipped">
    <xsl:param name="ClipNum"/>
    <xsl:param name="groupName"/>

    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">5</xsl:with-param>
    </xsl:call-template>
    <xsl:text> to </xsl:text>
    <xsl:value-of select="$ClipNum"/>
    <xsl:text>: </xsl:text>
    <xsl:value-of select="$groupName"/>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="outputSeeAvailabilityTab">
    <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">
    <xsl:call-template name="outputAttendeeError">
        <xsl:with-param name="attendeeErrNum">140</xsl:with-param>
    </xsl:call-template>
    </FONT><BR/>   
</xsl:template>

<xsl:template name="emit_new_event_errors">
<xsl:if test="(count(../errorslist/error)!=0)">
 <TR>
   <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">

     <xsl:for-each select="../errorslist/error">
       <xsl:choose>
          <xsl:when test="@errorNum = '5'">
	     <xsl:call-template name="outputGroupClipped">
                <xsl:with-param name="ClipNum" select="@clipNum"/>
<!--	           <xsl:value-of select="@clipNum"/>   Satya -->
<!--                </xsl:with-param>                  Satya -->
                <xsl:with-param name="groupName" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>  -->
<!--                </xsl:with-param>               -->
             </xsl:call-template> <!-- outputGroupClipped -->
          </xsl:when>
		<xsl:when test="@errorNum='65' or @errorNum='66' or @errorNum='68'">
             	    <xsl:call-template name="outputRecurrenceErrorMessageInNewEventDialog">
                	<xsl:with-param name="recurrenceErrorNum"><xsl:value-of select="@errorNum"/></xsl:with-param>
             	    </xsl:call-template>
		</xsl:when>
          <xsl:when test="@errorNum = '140'">
	     <xsl:call-template name="outputSeeAvailabilityTab"/>
          </xsl:when>
          <xsl:otherwise>
             <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                <xsl:with-param name="attendeeErrorNum" select="@errorNum"/>
<!--	           <xsl:value-of select="@errorNum"/>   -->
<!--                </xsl:with-param>                   -->
                <xsl:with-param name="attendeeUserID" select="@userid"/>
<!--	           <xsl:value-of select="@userid"/>   -->
<!--                </xsl:with-param>                 -->
             </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
          </xsl:otherwise>
       </xsl:choose>
     </xsl:for-each>
   </TD>
 </TR>
</xsl:if>
</xsl:template>

<xsl:template name="emit_new_cal_or_group_errors">
  <xsl:if test="(count(../errorslist/error)!=0)">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
        <xsl:for-each select="../errorslist/error">
	  <xsl:choose>
		<xsl:when test="@errorNum = '5'">
		</xsl:when>

        <xsl:otherwise>
             	    <xsl:call-template name="outputAttendeeErrorMessageInNewEventDialog">
                	<xsl:with-param name="attendeeErrorNum">
	           		<xsl:value-of select="@errorNum"/>
                	</xsl:with-param>
                	<xsl:with-param name="attendeeUserID">
	           		<xsl:value-of select="@userid"/>
                	</xsl:with-param>
             	    </xsl:call-template> <!-- outputAttendeeErrorMessageInNewEventDialog -->
		</xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </TD>
    </TR>
  </xsl:if>
  <xsl:if test="/calendar/error">
    <TR>
      <TD colspan="2" bgcolor="{$attendee_error_bgcolor}">
      <FONT face="{$font_name}" size="{$font_size_big_2}">
        <xsl:call-template name="outputSpecificError">
          <xsl:with-param name="Type">
            <xsl:value-of select="/calendar/error/@type"/>
          </xsl:with-param>
        </xsl:call-template>
      </FONT>
      </TD>
    </TR>
  </xsl:if>  
</xsl:template>

<xsl:template name="outputAttendeeErrorMessageInNewEventDialog">
  <xsl:param name="attendeeErrorNum"/>
  <xsl:param name="attendeeUserID"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputAttendeeError">
      <xsl:with-param name="attendeeErrNum">
           <xsl:value-of select="$attendeeErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
  <xsl:text> - </xsl:text>
  <xsl:value-of select="$attendeeUserID"/>

 </FONT><BR/>
</xsl:template>

<xsl:template name="outputRecurrenceErrorMessageInNewEventDialog">
  <xsl:param name="recurrenceErrorNum"/>
 
  <FONT size="{$font_size_big_2}" face="{$font_name}" color="{$error_font_color}">

  <xsl:call-template name="outputRecurrenceError">
      <xsl:with-param name="recurrenceErrNum">
           <xsl:value-of select="$recurrenceErrorNum"/>
      </xsl:with-param>
  </xsl:call-template>
 </FONT><BR/>
</xsl:template>
 

<xsl:template name="outputDirectoryLookupError">
  <xsl:param name="directoryErrNum"/>
  <!-- The error codes here are the same as the LDAP error codes -->
  <xsl:choose>
    <xsl:when test="$directoryErrNum = '2'"> 
      <!-- LDAP Protocol Error (2) -->
      There was a problem with the directory server with this search.&nbsp;
      Please provide another search string.
    </xsl:when>    
    <xsl:when test="$directoryErrNum = '3'">
      <!-- LDAP Timelimit Exceeded (3) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '4'">
      <!-- LDAP Sizelimit Exceeded (4) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '11'">
      <!-- LDAP Adminlimit Exceeded - lookthroughlimit exceeded (11) -->
      Too many results match this search.&nbsp;
      Please provide a more detailed search string.
    </xsl:when>
    <xsl:when test="$directoryErrNum = '81'">
      <!-- LDAP Server Down (81) -->
      A connection to the directory server could not be established.
    </xsl:when>      
    <xsl:when test="$directoryErrNum = '91'">
      <!-- LDAP Connect Error (91) -->
      A connection to the directory server could not be established.
    </xsl:when>      
    <xsl:otherwise>
      <!-- All other errors -->
      There was a problem with the directory server with this search.&nbsp;
      Please provide another search string.
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputAttendeeError">
  <xsl:param name="attendeeErrNum"/>

  <xsl:choose>
    <xsl:when test="$attendeeErrNum = '-5000'">
      GSE Error: event was deleted
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5001'">
      GSE Error: unsupported implementation
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5002'">
      GSE Error: malloc failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5003'">
      GSE Error: cannot create multiple instance of GSE
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5004'">
      GSE Error: GSE entry is invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5005'">
      GSE Error: event is invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5006'">
      GSE Error: cannot find transport interface
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5007'">
      GSE Error: cannot find attendee in organizer calendar
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5008'">
      GSE Error: cannot create resource such as lock, GDisp, ...etc
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5009'">
      GSE Error: expect iCS user, instead get SMTP user
    </xsl:when>
<!--      <xsl:value-of select="../eventdata/Event/@e_attendeeErrorInput"/>  Satya -->
    <xsl:when test="$attendeeErrNum = '-5010'">
      GSE Error: invalid component method and state
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5011'">
      GSE Error: request time conflict with another existing meeting request
    </xsl:when>

    <xsl:when test="$attendeeErrNum = '10000'">
      DB Error: component not found
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10001'">
      DB Error: IO error
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10002'">
      DB Error: one or more values of the event are invalid
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10003'">
      DB Error: function call does not operate on the supplied component
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10004'">
      DB Error: requested query is unknown or unsupported
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10005'">
      DB Error: a required parameter is NULL, not set, or not present
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10006'">
      DB Error: write was aborted because the requested SequenceNo condition check failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10007'">
      DB Error: write was aborted because the requested modified time condition check failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10008'">
      DB Error: write was aborted because the calendar does not allow overlapping appointments
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10009'">
      DB Error: ENS notification returned an error
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10010'">
      DB Error: a required value is null
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '1'">
      Invitee Error: bad argument
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '2'">
      Invitee Error: calendar not found
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '3'">
      Invitee Error: calendar is disabled
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '4'">
      Invitee Error: user is not allowed to access the calendar
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '5'">
      Invitee Error: Group was clipped
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '6'">
      Invitee Error: Cannot remove organizer
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '10'">
      Calendar Error: calendar creation failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '25'">
      Calendar Error: existing calendar with same identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '28'">
      Calendar Error: User does not have the access privilege needed
      to perform this operation.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '29'">
      Calendar Error: User trying to access calendar that does not exist.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '30'">
      Calendar Error: illegal calendar identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '40'">
      Invitee Error: Cannot double book to invitee.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '45'">
      Calendar Error: User does not have the access privilege needed
      to perform this operation.
    </xsl:when> 
    <xsl:when test="$attendeeErrNum = '47'">
      Calendar Error: User must be an owner or co-owner
      to perform this operation.
    </xsl:when> 
<!-- new error added in JES3 -->
    <xsl:when test="$attendeeErrNum = '78'">
      Calendar Error: Database is in readonly mode.
    </xsl:when>
<!-- end of JES3 addition -->
    <xsl:when test="$attendeeErrNum = '140'">
      Please see availability tab to find free time.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '141'">
      Group Error: illegal group identifier
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '142'">
      Calendar Error: Cannot add unknown user to privacy or owner list.
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-4'">
      SMTP Error: no mail host
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-5'">
      SMTP Error: connect failed
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-6'">
      SMTP Error: expect response to connect did not happen
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-7'">
      SMTP Error: problem addressing message
    </xsl:when>
    <xsl:when test="$attendeeErrNum = '-11'">
      SMTP Error: no recipient
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11001'">
      Error: Connection to Backend Database Failed.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11000'">
      Error: Maximum Connections to Backend Database Reached.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11002'">
      Error: Unable to resolve Calendar.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11003'">
      Error: Bad Data Backend Database Unreachable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11004'">
      Error: DWP Host Context Unavailable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11005'">
      Error: Backend Host Unresolvable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11006'">
      Error: No Data - Backend Database Unreachable.
    </xsl:when>
    <xsl:when test="$attendeeErrNum ='11007'">
      Error: Connection to Backend Database Failed.
    </xsl:when>
    <xsl:otherwise>
      Unknown error #<xsl:value-of select="$attendeeErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template name="outputRecurrenceError">
  <xsl:param name="recurrenceErrNum"/>
  <xsl:choose>
    <xsl:when test="$recurrenceErrNum='65'">
      Error: One instance of recurrence cannot skip over another.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='66'">
      Error: Two instances of recurrence cannot occur on the same day.
    </xsl:when>
    <xsl:when test="$recurrenceErrNum='68'">
      Error: Cannot change privacy of only one instance.
    </xsl:when>
    <xsl:otherwise>
      Unknown recurrence error #<xsl:value-of select="$recurrenceErrNum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="getDisplayNameOfTZID">
  <xsl:param name="tzid"/>
  <xsl:choose>
     <xsl:when test="$tzid='America/Adak'">America/Adak</xsl:when> 
     <xsl:when test="$tzid='America/Anchorage'">America/Anchorage</xsl:when> 
     <xsl:when test="$tzid='America/Los_Angeles'">America/Los_Angeles</xsl:when> 
     <xsl:when test="$tzid='America/Phoenix'">America/Phoenix</xsl:when> 
     <xsl:when test="$tzid='America/Denver'">America/Denver</xsl:when> 
     <xsl:when test="$tzid='America/Costa_Rica'">America/Costa_Rica</xsl:when> 
     <xsl:when test="$tzid='America/Chicago'">America/Chicago</xsl:when> 
     <xsl:when test="$tzid='America/Indianapolis'">America/Indianapolis</xsl:when> 
     <xsl:when test="$tzid='America/New_York'">America/New_York</xsl:when> 
     <xsl:when test="$tzid='America/Havana'">America/Havana</xsl:when> 
     <xsl:when test="$tzid='America/Port-au-Prince'">America/Port-au-Prince</xsl:when> 
     <xsl:when test="$tzid='America/Grand_Turk'">America/Grand_Turk</xsl:when> 
     <xsl:when test="$tzid='America/Caracas'">America/Caracas</xsl:when> 
     <xsl:when test="$tzid='America/Cuiaba'">America/Cuiaba</xsl:when> 
     <xsl:when test="$tzid='America/Halifax'">America/Halifax</xsl:when> 
     <xsl:when test="$tzid='America/Santiago'">America/Santiago</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Stanley'">Atlantic/Stanley</xsl:when> 
     <xsl:when test="$tzid='America/St_Johns'">America/St_Johns</xsl:when> 
     <xsl:when test="$tzid='America/Buenos_Aires'">America/Buenos_Aires</xsl:when> 
     <xsl:when test="$tzid='America/Sao_Paulo'">America/Sao_Paulo</xsl:when> 
     <xsl:when test="$tzid='America/Miquelon'">America/Miquelon</xsl:when> 
     <xsl:when test="$tzid='America/Godthab'">America/Godthab</xsl:when> 
     <xsl:when test="$tzid='Atlantic/South_Georgia'">Atlantic/South_Georgia</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Cape_Verde'">Atlantic/Cape_Verde</xsl:when> 
     <xsl:when test="$tzid='Atlantic/Azores'">Atlantic/Azores</xsl:when> 

     <xsl:when test="$tzid='Africa/Casablanca'">Africa/Casablanca</xsl:when> 
     <xsl:when test="$tzid='Europe/London'">Europe/London</xsl:when> 
     <xsl:when test="$tzid='Africa/Lagos'">Africa/Lagos</xsl:when> 
     <xsl:when test="$tzid='Europe/Paris'">Europe/Paris</xsl:when> 
     <xsl:when test="$tzid='Africa/Tripoli'">Africa/Tripoli</xsl:when> 
     <xsl:when test="$tzid='Europe/Warsaw'">Europe/Warsaw</xsl:when> 
     <xsl:when test="$tzid='Africa/Johannesburg'">Africa/Johannesburg</xsl:when> 
     <xsl:when test="$tzid='Europe/Bucharest'">Europe/Bucharest</xsl:when> 
     <xsl:when test="$tzid='Europe/Istanbul'">Europe/Istanbul</xsl:when> 
     <xsl:when test="$tzid='Africa/Cairo'">Africa/Cairo</xsl:when> 
     <xsl:when test="$tzid='Europe/Riga'">Europe/Riga</xsl:when> 
     <xsl:when test="$tzid='Africa/Windhoek'">Africa/Windhoek</xsl:when> 
     <xsl:when test="$tzid='Europe/Minsk'">Europe/Minsk</xsl:when> 
     <xsl:when test="$tzid='Europe/Simferopol'">Europe/Simferopol</xsl:when> 
     <xsl:when test="$tzid='Europe/Moscow'">Europe/Moscow</xsl:when> 
     <xsl:when test="$tzid='Europe/Samara'">Europe/Samara</xsl:when> 

     <xsl:when test="$tzid='Asia/Beirut'">Asia/Beirut</xsl:when> 
     <xsl:when test="$tzid='Asia/Jerusalem'">Asia/Jerusalem</xsl:when> 
     <xsl:when test="$tzid='Asia/Amman'">Asia/Amman</xsl:when> 
     <xsl:when test="$tzid='Asia/Riyadh'">Asia/Riyadh</xsl:when> 
     <xsl:when test="$tzid='Asia/Tehran'">Asia/Tehran</xsl:when> 
     <xsl:when test="$tzid='Asia/Yerevan'">Asia/Yerevan</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtau'">Asia/Aqtau</xsl:when> 
     <xsl:when test="$tzid='Asia/Baku'">Asia/Baku</xsl:when> 
     <xsl:when test="$tzid='Asia/Kabul'">Asia/Kabul</xsl:when> 
     <xsl:when test="$tzid='Asia/Karachi'">Asia/Karachi</xsl:when> 
     <xsl:when test="$tzid='Asia/Aqtobe'">Asia/Aqtobe</xsl:when> 
     <xsl:when test="$tzid='Asia/Bishkek'">Asia/Bishkek</xsl:when> 
     <xsl:when test="$tzid='Asia/Yekaterinburg'">Asia/Yekaterinburg</xsl:when> 
     <xsl:when test="$tzid='Asia/Calcutta'">Asia/Calcutta</xsl:when> 
     <xsl:when test="$tzid='Asia/Katmandu'">Asia/Katmandu</xsl:when> 
     <xsl:when test="$tzid='Asia/Dacca'">Asia/Dacca</xsl:when> 
     <xsl:when test="$tzid='Asia/Alma-Ata'">Asia/Alma-Ata</xsl:when> 
     <xsl:when test="$tzid='Asia/Novosibirsk'">Asia/Novosibirsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Rangoon'">Asia/Rangoon</xsl:when> 
     <xsl:when test="$tzid='Asia/Bangkok'">Asia/Bangkok</xsl:when> 
     <xsl:when test="$tzid='Asia/Krasnoyarsk'">Asia/Krasnoyarsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Ulan_Bator'">Asia/Ulan_Bator</xsl:when> 
     <xsl:when test="$tzid='Asia/Shanghai'">Asia/Shanghai</xsl:when> 
     <xsl:when test="$tzid='Asia/Taipei'">Asia/Taipei</xsl:when> 
     <xsl:when test="$tzid='Asia/Irkutsk'">Asia/Irkutsk</xsl:when> 
     <xsl:when test="$tzid='Asia/Tokyo'">Asia/Tokyo</xsl:when> 
     <xsl:when test="$tzid='Asia/Seoul'">Asia/Seoul</xsl:when> 
     <xsl:when test="$tzid='Asia/Yakutsk'">Asia/Yakutsk</xsl:when> 
     <xsl:when test="$tzid='Australia/Perth'">Australia/Perth</xsl:when> 
     <xsl:when test="$tzid='Australia/Darwin'">Australia/Darwin</xsl:when> 
     <xsl:when test="$tzid='Australia/Adelaide'">Australia/Adelaide</xsl:when> 
     <xsl:when test="$tzid='Australia/Brisbane'">Australia/Brisbane</xsl:when> 
     <xsl:when test="$tzid='Australia/Sydney'">Australia/Sydney</xsl:when> 
     <xsl:when test="$tzid='Australia/Hobart'">Australia/Hobart</xsl:when> 
     <xsl:when test="$tzid='Asia/Vladivostok'">Asia/Vladivostok</xsl:when> 
     <xsl:when test="$tzid='Australia/Lord_Howe'">Australia/Lord_Howe</xsl:when> 
     <xsl:when test="$tzid='Pacific/Guadalcanal'">Pacific/Guadalcanal</xsl:when> 
     <xsl:when test="$tzid='Pacific/Noumea'">Pacific/Noumea</xsl:when> 
     <xsl:when test="$tzid='Asia/Magadan'">Asia/Magadan</xsl:when> 
     <xsl:when test="$tzid='Pacific/Norfolk'">Pacific/Norfolk</xsl:when> 
     <xsl:when test="$tzid='Pacific/Fiji'">Pacific/Fiji</xsl:when> 
     <xsl:when test="$tzid='Pacific/Auckland'">Pacific/Auckland</xsl:when> 
     <xsl:when test="$tzid='Asia/Kamchatka'">Asia/Kamchatka</xsl:when> 
     <xsl:when test="$tzid='Pacific/Chatham'">Pacific/Chatham</xsl:when> 
     <xsl:when test="$tzid='Pacific/Tongatapu'">Pacific/Tongatapu</xsl:when> 
     <xsl:when test="$tzid='Asia/Anadyr'">Asia/Anadyr</xsl:when> 
     <xsl:when test="$tzid='Pacific/Kiritimati'">Pacific/Kiritimati</xsl:when> 
     <xsl:when test="$tzid='Pacific/Apia'">Pacific/Apia</xsl:when> 
     <xsl:when test="$tzid='Pacific/Honolulu'">Pacific/Honolulu</xsl:when> 
     <xsl:when test="$tzid='Pacific/Rarotonga'">Pacific/Rarotonga</xsl:when> 
     <xsl:when test="$tzid='Pacific/Marquesas'">Pacific/Marquesas</xsl:when> 
     <xsl:when test="$tzid='Pacific/Gambier'">Pacific/Gambier</xsl:when> 
     <xsl:when test="$tzid='Pacific/Pitcairn'">Pacific/Pitcairn</xsl:when> 
     <xsl:when test="$tzid='Pacific/Easter'">Pacific/Easter</xsl:when> 
    <xsl:otherwise>
      Unknown time zone #<xsl:value-of select="$tzid"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- Variables with spaces in their values.  xslvarparser.pl cannot handle this.-->

<xsl:variable name="note_blip">*</xsl:variable>
<xsl:variable name="no_end_date_msg">No end date </xsl:variable>
<xsl:variable name="cap_the_text">The </xsl:variable>
<xsl:variable name="vert_divider"> | </xsl:variable>
<xsl:variable name="horiz_divider"> - </xsl:variable>

<xsl:variable name="leftarrowremove_title"><xsl:text>&lt;&lt;</xsl:text> Remove</xsl:variable>

<!--
<xsl:variable name=""></xsl:variable>
-->

<!-- TEMPLATES to PROVIDE LOCALIZATION of FORMATTING -->
<!-- For some languages all that will need to happen is translation of the text -->
<!-- For other languages the entire format of the statement may need to change as well -->


<!-- This template is used in toolbar.xsl to print out "Welcome Firstname Lastname" if possible -->
<!-- The form of the welcome can be made language appropriate or event suppressed by changing here -->
<xsl:template name="toolbar_welcome">
  <xsl:if test="(string-length(/calendar/usrctx/user/@fullName) > 0) or (string-length(/calendar/usrctx/user/@name) > 0)">
    <b><FONT size="2" face="PrimaSans BT,Verdana,sans-serif">
    <xsl:text>Welcome  </xsl:text>
    <xsl:choose>
    <xsl:when test="string-length(/calendar/usrctx/user/@fullName) > 0">
      <xsl:value-of select="/calendar/usrctx/user/@fullName"/>
    </xsl:when> 
    <xsl:otherwise> 
      <xsl:value-of select="/calendar/usrctx/user/@name"/>
    </xsl:otherwise> 
    </xsl:choose> 
    </FONT></b>
    <img src="imx/spacer.gif" width="10" height="5"/>
  </xsl:if>
</xsl:template>


<!-- This template is used in task_list.xsl to print out "Alexandra's Calendar (#)" in the tab -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="task_tab_name">
  <xsl:param name="numtasks"/>

  <xsl:text>Tasks for </xsl:text>
  <xsl:value-of select="/calendar/usrctx/user/@firstName"/>
  <xsl:text>'s Calendar (</xsl:text>
  <xsl:value-of select="$numtasks"/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- This template is used in groupview.xsl and availability.xsl to provide the tool tip for the aspirins -->
<!-- which look like this "Start at 8:00pm (1 hour available)" -->
<!-- This format or message can be changed as appropriate for other languages by modifying this template -->
<xsl:template name="available_time_message">
  <xsl:param name="ftHour"/>
  <xsl:param name="ftMinute"/>
  <xsl:param name="timeAvail"/>

  <xsl:text>Start at </xsl:text>
  <xsl:call-template name="formatTime">
    <xsl:with-param name="ftHour" select="$ftHour"/>
    <xsl:with-param name="ftMinute" select="$ftMinute"/>
  </xsl:call-template>
  <xsl:text>&nbsp;(</xsl:text>
  <xsl:choose>
    <xsl:when test="$timeAvail=60">
      <xsl:text>1 hour</xsl:text>
    </xsl:when>
    <xsl:when test="60 > $timeAvail">
      <xsl:value-of select="$timeAvail"/><xsl:text> minutes</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>More than 1 hour</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text> available)</xsl:text>
</xsl:template>

<xsl:template name="creates_max_msg_template">
  <xsl:param name="MaxNum"/>

  <xsl:value-of select="$note_blip"/>
  <xsl:text> Creates a maximum of </xsl:text>
  <xsl:value-of select="$MaxNum"/>
  <xsl:text> instances</xsl:text>
</xsl:template>

<!-- A multipart message to clarify information on a timezone tab -->
<!-- For l10n this can be changed as required -->
<xsl:template name="timezone_tab_msg">
  <xsl:param name="multiselect"/>
  <xsl:param name="tz_area"/>
  
<!-- first the appropriate lead in message -->
  <xsl:choose>
  <xsl:when test="$multiselect=1">
    <xsl:text>One or more time zones from any region can be associated with the current calendar. In gridded views such as the day view, all time zones associated with the calendar become part of the view's time scale. If no time zone is specified with this calendar, then the default time zone will be used. The following time zones are available in the </xsl:text>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text>One time zone from any region can be associated with the current calendar. In gridded views such as the day view, the time zone associated with the calendar becomes part of the view's time scale. If no time zone is specified with this calendar, then the default time zone will be used. The following time zones are available in the </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now the appropriate title specifying timezone area -->
  <xsl:choose>
  <xsl:when test="$tz_area='NSAMERICA'">
    <xsl:text>North/South America </xsl:text>
  </xsl:when>
  <xsl:when test="$tz_area='EUROPE'">
    <xsl:text>Europe/Africa </xsl:text>
  </xsl:when>
<!-- otherwise ASIA -->
  <xsl:otherwise> 
    <xsl:text>Asia/Pacific Rim </xsl:text>
  </xsl:otherwise>
  </xsl:choose>
<!-- now finish the statement -->
  <xsl:text>region:</xsl:text>
</xsl:template>


<!-- This is to generate a message composed of several parts used in reply_event.xsl  -->
<!-- the template can be modified for localization purposes -->
<xsl:template name="reply_event_msg_template">
  <xsl:param name="org_id"/>

      <xsl:text>The following event has been added to your calendar by "</xsl:text>
      <xsl:value-of select="$org_id"/>
      <xsl:text>". You can accept or decline this invitation by selecting the appropriate option for your reply below.</xsl:text>
</xsl:template>

<!-- This is used in options.xsl -->
<!-- It is a multi-part message to allow the "browse" to be BOLD -->
<!-- but it needs to be in a template to allow for localization reformatting -->
<xsl:template name="click_browse_instruct">
  <FONT size="{$font_size_big_2}" face="{$font_name}">
  <xsl:text>Click</xsl:text>&nbsp;
  <B><xsl:text>Browse...</xsl:text></B>&nbsp;
  <xsl:text>to select a file.</xsl:text>
  </FONT>
</xsl:template>

<!-- truncatestring -->
<!-- This is used to truncate encoded strings safely -->
<xsl:template name="truncatestring">
<xsl:param name="thestring"/>
<xsl:param name="thelength"/>

 <xsl:choose>
   <xsl:when test="string-length($thestring) &gt; number($thelength)">	   
      <xsl:variable name="add_on" select="substring-before(substring($thestring, number($thelength)),';')"/>
      <xsl:choose>
        <xsl:when test="string-length($add_on) &gt; 0">
	  <xsl:value-of select="concat(substring($thestring, 0, number($thelength)),$add_on,';')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($thestring, 0, number($thelength))"/>
        </xsl:otherwise>
      </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
      <xsl:value-of select="string($thestring)"/>
   </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- printCalendarName -->
<!-- Of the form "calname (displayname)" -->
<!-- or if displayname is missing, then just the "calname" -->
<!-- but limit size of both pieces to reasonable number -->
<xsl:template name="printCalendarName">
  <xsl:param name="name"/>
  <xsl:param name="printname"/>

<xsl:if test="string-length($name) &gt; 0">
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
</xsl:if>
<xsl:if test="string-length($printname) &gt; 0">
  <xsl:text> (</xsl:text>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$printname"/>
     <xsl:with-param name="thelength">25</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($printname) &gt; 25">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:text>)</xsl:text>
</xsl:if>  
</xsl:template>          

<!-- printLimitedName -->
<!-- Limit size to reasonable number -->
<!-- Withparen=true puts parens around the name -->
<xsl:template name="printLimitedName">
  <xsl:param name="name"/>
  <xsl:param name="withparen"/>
  
<xsl:if test="string-length($name) &gt; 0">
  <xsl:if test="$withparen='true'"><xsl:text>(</xsl:text></xsl:if>
  <xsl:call-template name="truncatestring">
     <xsl:with-param name="thestring" select="$name"/>
     <xsl:with-param name="thelength">55</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="string-length($name) &gt; 55">
    <xsl:text>...</xsl:text>
  </xsl:if>
  <xsl:if test="$withparen='true'"><xsl:text>)</xsl:text></xsl:if>
</xsl:if>
</xsl:template>          


<!-- make this a template since it is composed of pieces and may need the -->
<!-- format changed for localization -->
<!-- Note that for the moment you cannot change the glif's used to indicate status -->
<!-- there is a separate bug filed on that -->
<xsl:template name="invitations_msg_template">

  <xsl:text>Use this panel to accept </xsl:text>
  (<FONT face="mono">+</FONT>)
  <xsl:text> or decline </xsl:text>
  (<FONT face="mono">-</FONT>)
  <xsl:text> or leave undecided </xsl:text>
  (<FONT face="mono">?</FONT>)
  <xsl:text> invitations to events.</xsl:text>
  <br/>
  <xsl:text>For recurring events, the setting will be applied to the entire sequence.</xsl:text>
</xsl:template>


<xsl:template name="limitedSearchMsg">
  <xsl:param name="limit"/>

  <xsl:text>The results from a search with less than </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> characters may not be complete. For better results, try using at least </xsl:text>
  <xsl:value-of select="$limit"/>
  <xsl:text> characters.</xsl:text>

</xsl:template>


</xsl:stylesheet>
