#include "nsIFactory.h"
#include "nsISupports.h"
#include "csIPlugin.h"
#include "csIUserAttributes.h"

#include "csUserAttributesDB.h"

// interfaces
static NS_DEFINE_IID(kISupportsIID,         NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kIFactoryIID,          NS_IFACTORY_IID);
static NS_DEFINE_IID(kIPluginIID,           CS_IPLUGIN_IID);
static NS_DEFINE_IID(kIUserAttributesIID,   CS_IUSERATTRIBUTES_IID);

// implementations
static NS_DEFINE_IID(kCUserAttributesDB,  CS_IUSERATTRIBUTESDB_CID);

class csUserAttributesDBFactory : public nsIFactory
{   
  public:   
    // nsISupports methods   
    NS_IMETHOD QueryInterface(const nsIID &aIID,    
                              void **aResult);   
    NS_IMETHOD_(nsrefcnt) AddRef(void);   
    NS_IMETHOD_(nsrefcnt) Release(void);   

    // nsIFactory methods   
    NS_IMETHOD CreateInstance(nsISupports *aOuter,   
                              const nsIID &aIID,   
                              void **aResult);   

    NS_IMETHOD LockFactory(PRBool aLock);   

    csUserAttributesDBFactory(const nsCID &aClass);   
    ~csUserAttributesDBFactory();   

  private:   
    nsrefcnt  mRefCnt;   
    nsCID     mClassID;
};   

csUserAttributesDBFactory::csUserAttributesDBFactory(const nsCID &aClass)   
{   
  mRefCnt = 0;
  mClassID = aClass;
}   

csUserAttributesDBFactory::~csUserAttributesDBFactory()   
{   
  NS_ASSERTION(mRefCnt == 0, "non-zero refcnt at destruction");   
}   

nsresult csUserAttributesDBFactory::QueryInterface(const nsIID &aIID,   
                                                 void **aResult)   
{   
  if (aResult == NULL) {   
    return NS_ERROR_NULL_POINTER;   
  }   

  // Always NULL result, in case of failure   
  *aResult = NULL;   

  if (aIID.Equals(kISupportsIID)) {   
    *aResult = (void *)(nsISupports*)this;   
  } else if (aIID.Equals(kIFactoryIID)) {   
    *aResult = (void *)(nsIFactory*)this;   
  }   

  if (*aResult == NULL) {   
    return NS_NOINTERFACE;   
  }   

  AddRef(); // Increase reference count for caller   
  return NS_OK;   
}   

nsrefcnt csUserAttributesDBFactory::AddRef()   
{   
  return ++mRefCnt;   
}   

nsrefcnt csUserAttributesDBFactory::Release()   
{   
  if (--mRefCnt == 0) {   
    delete this;   
    return 0; // Don't access mRefCnt after deleting!   
  }   
  return mRefCnt;   
}  

nsresult csUserAttributesDBFactory::CreateInstance(nsISupports *aOuter,  
                                                 const nsIID &aIID,  
                                                 void **aResult)  
{  
  (nsISupports*) aOuter;

  if (aResult == NULL) {  
    return NS_ERROR_NULL_POINTER;  
  }  

  *aResult = NULL;  
  
  nsISupports *inst = NULL;

  if (mClassID.Equals(kCUserAttributesDB) || mClassID.Equals(kIUserAttributesIID)) {
    inst = (nsISupports *)(csIUserAttributes*)new csUserAttributesDB();
  } else if (mClassID.Equals(kIPluginIID)) {
    inst = (nsISupports *)(csIPlugin*)new csUserAttributesDB();
  }

  if (inst == NULL) {  
    return NS_ERROR_OUT_OF_MEMORY;  
  }  

  nsresult res = inst->QueryInterface(aIID, aResult);

  if (res != NS_OK) {  
    // We didn't get the right interface, so clean up  
    delete inst;  
  }  

  return res;  
}  

nsresult csUserAttributesDBFactory::LockFactory(PRBool aLock)  
{  
  // Not implemented in simplest case.  
  (PRBool) aLock;
  return NS_OK;
}  

// return the proper factory to the caller
extern "C" NS_EXPORT nsresult NSGetFactory(const nsCID &aClass, 
                                           nsISupports* aServiceMgr,
                                           nsIFactory **aFactory)
{
  (nsISupports*) aServiceMgr;

  if (NULL == aFactory) {
    return NS_ERROR_NULL_POINTER;
  }

  *aFactory = new csUserAttributesDBFactory(aClass);

  if (NULL == aFactory) {
    return NS_ERROR_OUT_OF_MEMORY;
  }

  return (*aFactory)->QueryInterface(kIFactoryIID, (void**)aFactory);
}

