#ifndef csUserAttributesDB_h___
#define csUserAttributesDB_h___

#include "csIPlugin.h"
#include "csIUserAttributes.h"
#include "nsString.h"

#define CS_IUSERATTRIBUTESDB_CID                       \
{ /* eb090450-e149-11d2-9e73-00105ae811b7 */         \
    0xeb090450,                                      \
    0xe149,                                          \
    0x11d2,                                          \
    {0x9e, 0x73, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


class csUserAttributesDB : public csIUserAttributes,
                           public csIPlugin
{
public:
  csUserAttributesDB();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);

  NS_IMETHOD  GetAttribute(char * aUser, char * aKey, char ** aValue, PRInt32 * aReturnCode);
  NS_IMETHOD  SetAttribute(char * aUser, char * aKey, char * aValue, PRInt32 * aReturnCode);
  NS_IMETHOD  FreeAttribute(char * aValue, PRInt32 * aReturnCode);

  NS_IMETHOD SearchCalendars(char* aSearchString, PRInt32 aSearchFlags, PRInt32 aSearchOpt, char ***aResults, PRInt32 *aCount);
  NS_IMETHOD FreeSearchResults(char **aResults, PRInt32 *aReturnCode);

protected:

  virtual ~csUserAttributesDB();

};

#endif /* csUserAttributesDB_h___ */
