/*
 * Copyright 1997 by Sun Microsystems, Inc.
 * Some preexisting portions copyright [1999] Netscape Communications Corp.
 * All rights reserved
 *
 * asub : example asynchronous subscriber
 *
 * Syntax:
 *   asub host port
 */

#include <stdlib.h>
#include <stdio.h>

#include "pasdisp.h"
#include "subscriber.h"

static pas_dispatcher_t *disp = NULL;
static subscriber_t *_subscriber = NULL;
static subscription_t *_subscription = NULL;
static renl_t *_renl = NULL;

static void _exit_usage()
{
    printf("\nUsage:\n\tasub host port\n");
    exit(5);
}

static void _exit_error(const char *msg)
{
    printf("%s\n", msg);
    exit(1);
}

static void _subscribe_ack(void *arg, int rc, void *subscription)
{
    (void)arg;

    if (!rc) {
	_subscription = subscription;
	printf("Subscription successful\n");
	_renl = renl_create_subscriber(_subscription, "renl_id", NULL);
    } else {
	printf("Subscription failed - status %d\n", rc);
	pas_shutdown(disp);
    }
}

static void _unsubscribe_ack(void *arg, int rc, void *ignored)
{
    (void *)ignored;
    (void *)arg;

    if (rc != 0) {
	printf("Unsubscribe failed - status %d\n", rc);
    }

    subscriber_delete(_subscriber);
    pas_shutdown(disp);
}


static int _handle_notify(void *arg, char *url, char *str, int len)
{
    (void *)arg;
    printf("[%s] %.*s\n", url, len, (str) ? str : "(null)");
    return 0;
}

static void _open_ack(void *arg, int rc, void *enc)
{
    _subscriber = (subscriber_t *)enc;

    (void *)arg;
    if (rc) {
	printf("Failed to create subscriber with status %d\n", rc);
	pas_shutdown(disp);
	return;
    }

    subscribe(_subscriber, "enp://yoyo.com/xyz",
	      _handle_notify, NULL,
	      _subscribe_ack, NULL);
    
    return;
}

static void _unsubscribe(int sig)
{
    (int)sig;
    unsubscribe(_subscriber, _subscription, _unsubscribe_ack, NULL);
}

main(int argc, char **argv)
{
    unsigned short port = 57997;
    char host[256];

    if (argc < 2) _exit_usage();
    if (*(argv[1]) == '0') {
	strcpy(host, "127.0.0.1");
    } else {
	strcpy(host, argv[1]);
    }
    if (argc > 2) {
	port = (unsigned short)atoi(argv[2]);
    }

    disp = pas_dispatcher_new(NULL);
    if (disp == NULL) _exit_error("Can't create publisher");

    subscriber_new_a(disp, NULL, host, port, _open_ack, NULL);

    pas_dispatch(disp);

    pas_dispatcher_delete(disp);

    exit(0);
}

