/*
 * Copyright 2000 by Sun Microsystems, Inc.
 * Some preexisting portions copyright [1999] Netscape Communications Corp.
 * All rights reserved
 *
 * apub : simple interactive asynchronous publisher using
 *
 * Syntax:
 *   apub host port
 */

#include <stdlib.h>
#include <stdio.h>

#include "pasdisp.h"
#include "publisher.h"

static pas_dispatcher_t *disp = NULL;
static publisher_t *_publisher = NULL;
static int _shutdown = 0;

static void _read_stdin();

static void _exit_usage()
{
    printf("\nUsage:\n\tapub host port\n");
    exit(5);
}

static void _exit_error(const char *msg)
{
    printf("%s\n", msg);
    exit(1);
}


static void _call_shutdown()
{
    _shutdown = 1;
    pas_shutdown(disp);
}

static void _open_ack(void *arg, int rc, void *enc)
{
    _publisher = (publisher_t *)enc;

    (void *)arg;

    if (!_publisher) {
	printf("Failed to create publisher with status %d\n", rc);
	_call_shutdown();
	return;
    }

    _read_stdin();

    return;
}


static void _publish_ack(void *arg, int rc, void *ignored)
{
    (void *)ignored;

    free(arg);

    if (rc != 0) {
	printf("Publish failed with status %d\n", rc);
	_call_shutdown();
        return;
    }

    _read_stdin();

    return;
}

static void _read_stdin()
{
    static char input[1024];

    printf("apub> ");
    fflush(stdout);
    while (!_shutdown) {
	if ( !fgets(input, sizeof(input), stdin) ) {
	    continue;
	} else {
	    char *message;
	    unsigned int message_len;

	    input[strlen(input) - 1] = 0; /* Strip off the \n */

	    if (*input == '.' && input[1] == 0) {
                publisher_delete(_publisher);
		_call_shutdown();
		break;
	    }

	    message = strdup(input);
	    message_len = strlen(message);
	    publish(_publisher, "enp://yoyo.com/xyz",
		    message, message_len,
		    _publish_ack, NULL, (void *)message, 0);
	    return;
	}
    }

    return;
}


main(int argc, char **argv)
{
    unsigned short port = 57997;
    char host[256];

    if (argc < 2) _exit_usage();
    if (*(argv[1]) == '0') {
	strcpy(host, "127.0.0.1");
    } else {
	strcpy(host, argv[1]);
    }
    if (argc > 2) {
	port = (unsigned short)atoi(argv[2]);
    }

    disp = pas_dispatcher_new(NULL);
    if (disp == NULL) _exit_error("Can't create publisher");

    publisher_new_a(disp, NULL, host, port, _open_ack, disp);

    pas_dispatch(disp);

    _shutdown = 1;

    pas_dispatcher_delete(disp);

    exit(0);
}


