#ifndef csDataTranslatorCSV_h___
#define csDataTranslatorCSV_h___

#include "csIPlugin.h"
#include "csIDataTranslator.h"
#include "nspr.h"
#include "nsString.h"
#include "xmlparse.h"

#define CSV_TAG_NONE          0
#define CSV_TAG_SUBJECT       1
#define CSV_TAG_STARTDATE     2
#define CSV_TAG_STARTTIME     3
#define CSV_TAG_ENDDATE       4
#define CSV_TAG_ENDTIME       5
#define CSV_TAG_ALLDAYEVENT   6
#define CSV_TAG_DESCRIPTION   7

typedef struct token
{
  char * subject;
  char * startdate;
  char * starttime;
  char * enddate;
  char * endtime;
  char * alldayevent;
  char * description;
  PRInt32 tag;
} token;

#define CS_IDATATRANSLATOR_CSV_CID                       \
{ /* 71adf370-cc4b-11d2-9e6d-00105ae811b7 */         \
    0x71adf370,                                      \
    0xcc4b,                                          \
    0x11d2,                                          \
    {0x9e, 0x6d, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}

class csDataTranslatorCSV : public csIDataTranslator,
                            public csIPlugin
{
public:
  csDataTranslatorCSV();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);

  NS_IMETHOD GetSupportedContentTypes(char ** aSupportedInContentTypes, 
                                      char ** aSupportedOutContentType,
                                      char ** aPreferredInContentType,
                                      PRInt32 * aReturnCode);

  NS_IMETHOD  Translate(char * aInContentType, char * aOutContentType, char ** aInBuffer, char ** aOutBuffer, PRInt32 * aInSize, PRInt32 * aOutSize, PRInt32 * aReturnCode);


protected:
  virtual ~csDataTranslatorCSV();


public:
  XML_Parser  mparser;          /* XML parser */
  char *      output_buffer;    /* output buffer */
  PRInt32     output_size;      /* output buffer size */
  PRInt32     output_written;   /* actual number of bytes writtent to output buffer */
  PRInt32     buf_ptr;          /* offset in buffer currently writing to */
  PRBool      debug;            /* debug mode */
  PRBool      bInComponent;     /* Currently in a component tag */
  token       cur_token;        /* Current Token */

private:
  NS_IMETHOD_(PRInt32) convert_xml_to_csv(char ** inbuf, char ** outbuf, PRInt32 insize);
  NS_IMETHOD output_csv_header();

public:
  NS_IMETHOD buf_write(const char * data, PRInt32 len);

};

#endif /* csDataTranslatorCSV_h___ */
