#ifndef csAuthenticationLocal_h___
#define csAuthenticationLocal_h___

#include "csIPlugin.h"
#include "csIAuthentication.h"
#include "nsString.h"

#define CS_IAUTHENTICATIONLOCAL_CID                       \
{ /* f9eaa440-e14a-11d2-9e73-00105ae811b7 */         \
    0xf9eaa440,                                      \
    0xe14a,                                          \
    0x11d2,                                          \
    {0x9e, 0x73, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


class csAuthenticationLocal : public csIAuthentication,
                              public csIPlugin
{
public:
  csAuthenticationLocal();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);

  NS_IMETHOD  Logon(char * aUser, char * aPassword, PRInt32 * aReturnCode);
  NS_IMETHOD  Logout(char * aUser, PRInt32 * aReturnCode);
  NS_IMETHOD  VerifyUserExists(char * aUser, PRInt32 * aReturnCode);
  NS_IMETHOD  ChangePassword(char * aUser, char * aOldPassword, char * aNewPassword, PRInt32 * aReturnCode);

protected:

  virtual ~csAuthenticationLocal();

};

#endif /* csAuthenticationLocal_h___ */
