#include "csAuthenticationLocal.h"
#include "nsString.h"
#include "authlogon.h"

static NS_DEFINE_IID(kISupportsIID,      NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kAuthenticationIID, CS_IAUTHENTICATION_IID);
static NS_DEFINE_IID(kPluginIID,         CS_IPLUGIN_IID);

nsresult csAuthenticationLocal :: QueryInterface(REFNSIID aIID, void** aInstancePtr)
{

  if (NULL == aInstancePtr)
    return NS_ERROR_NULL_POINTER;

  if (aIID.Equals(kAuthenticationIID))
    *aInstancePtr = (void*)((csIAuthentication *)this);
  else if (aIID.Equals(kISupportsIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIAuthentication *)this);
  else if (aIID.Equals(kPluginIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIPlugin *)this);
  else
    return (NS_NOINTERFACE);  

  NS_ADDREF_THIS();
  return NS_OK;
}

NS_IMPL_ADDREF(csAuthenticationLocal)
NS_IMPL_RELEASE(csAuthenticationLocal)

csAuthenticationLocal :: csAuthenticationLocal()
{
  NS_INIT_REFCNT();
}

csAuthenticationLocal :: ~csAuthenticationLocal()
{
}

NS_IMETHODIMP csAuthenticationLocal :: Init(nsISupports * aServer)
{
  (nsISupports *) aServer;
  return NS_OK;
}

NS_IMETHODIMP csAuthenticationLocal :: GetDescription(nsString& aDescription)
{
  aDescription = "Authentication Sample Plugin";
  return NS_OK;
}

NS_IMETHODIMP csAuthenticationLocal :: GetVendorName(nsString& aVendorName)
{
  aVendorName = "Netscape Communications Corporation";
  return NS_OK;
}

NS_IMETHODIMP csAuthenticationLocal :: GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) 
{
  aMajorValue = 1;
  aMinorValue = 0;
  return NS_OK;
}


NS_IMETHODIMP csAuthenticationLocal :: Logon(char * aUser, char * aPassword, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (void*) aPassword;
  *aReturnCode = 1;
  nsresult nsr = NS_AUTHENTICATION_LOGON_SUCCESS;

  if (authlogon(aUser, aPassword) == PR_FALSE)
    nsr = NS_AUTHENTICATION_LOGON_FAILURE;

  return nsr;
}

NS_IMETHODIMP csAuthenticationLocal :: Logout(char * aUser, PRInt32 * aReturnCode)
{
  (void*) aUser;
  *aReturnCode = 1;
  nsresult nsr = NS_AUTHENTICATION_LOGOUT_SUCCESS;

  return nsr;
}

NS_IMETHODIMP csAuthenticationLocal :: VerifyUserExists(char * aUser, PRInt32 * aReturnCode)
{
  (void*) aUser;
  *aReturnCode = 1;
  nsresult nsr = NS_AUTHENTICATION_VERIFYUSEREXISTS_SUCCESS;

  return nsr;
}

NS_IMETHODIMP csAuthenticationLocal :: ChangePassword(char * aUser, char * aOldPassword, char * aNewPassword, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (char*) aOldPassword;
  (char*) aNewPassword;
  *aReturnCode = 1;
  nsresult nsr = NS_AUTHENTICATION_CHANGEPASSWORD_SUCCESS;

  return nsr;
}
