#include "nspr.h"
#include "authlogon.h"

#ifdef WIN32
#include "windows.h"
#else
#include "pwd.h"
#include "unistd.h"
#include "crypt.h"
#endif


PR_IMPLEMENT(PRBool) authlogon(char * aUser, char * aPassword)
{
  PRBool bSuccess = PR_TRUE;

#ifdef WIN32

  /*
   * In order for this code to work, the administrator of this NT box MUST do the following as Administrator.
   * since no user by default has the required privileges to log on via batch jobs:
   *
   * 1) Run the User Manager which is in Start/Programs/Administrative Tools
   * 2) click on Policies/User Rights on the Menu Bar
   * 3) Click the "Show Advanced Rights" checkbox
   * 4) In the pulldown menu, select "Log On As Batch Job"
   * 5) Click the "Add..." button
   * 6) Highlight "Everyone" and click the "Add" button
   * 7) click the "Ok" button
   * 8) click the "Ok" button
   * 9) Click User/Exit from the menubar
   * 10) Logout and log back in
   */

  HANDLE hToken;
  BOOL rc;
  LPVOID  lpBuffer;

  rc = LogonUser(aUser, NULL, aPassword, LOGON32_LOGON_BATCH, LOGON32_PROVIDER_DEFAULT, &hToken); 

  if (rc != 0)
  {
    /* Happy Happy */
    CloseHandle(hToken);
    
  } else {
    DWORD dw;
    dw = GetLastError();

    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
                  NULL, 
                  dw, 
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
                  (LPTSTR) &lpBuffer, 
                  100000, 
                  NULL);

    LocalFree(lpBuffer);
    bSuccess = PR_FALSE;

  }
#else

  int i = 0;
  struct passwd * pwstruct;
  char salt[3];
  char * newpass = NULL;

  /* run cryprt on aPassword before comparing */
  pwstruct = getpwnam(aUser);
  
  if (pwstruct == ((struct passwd *)NULL)) {
    bSuccess = PR_FALSE;
  } else {

    /* Don't support passwords less than 2 characters */
    if ((pwstruct->pw_passwd) && strlen(pwstruct->pw_passwd) > 1)
    {
      salt[0] = pwstruct->pw_passwd[0];
      salt[1] = pwstruct->pw_passwd[1];
      salt[2] = '\0';

      newpass = crypt(aPassword, salt);

      if ((newpass) && (pwstruct->pw_passwd) && (strlen(newpass) == strlen(pwstruct->pw_passwd)))
      {
	      for (i = 0; newpass[i] != '\0'; i++)
		      if (newpass[i] != pwstruct->pw_passwd[i])
          {
			      bSuccess = PR_FALSE;
            break;
          }
      } else {
        bSuccess = PR_FALSE;
      }
    } else {
      bSuccess = PR_FALSE;
    }

  }

#endif

  return bSuccess;
}

