#include "csUserAttributes.h"
#include "nsString.h"

static NS_DEFINE_IID(kISupportsIID,      NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kUserAttributesIID, CS_IUSERATTRIBUTES_IID);
static NS_DEFINE_IID(kPluginIID,         CS_IPLUGIN_IID);

nsresult csUserAttributes :: QueryInterface(REFNSIID aIID, void** aInstancePtr)
{

  if (NULL == aInstancePtr)
    return NS_ERROR_NULL_POINTER;

  if (aIID.Equals(kUserAttributesIID))
    *aInstancePtr = (void*)((csIUserAttributes *)this);
  else if (aIID.Equals(kISupportsIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIUserAttributes *)this);
  else if (aIID.Equals(kPluginIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIPlugin *)this);
  else
    return (NS_NOINTERFACE);  

  NS_ADDREF_THIS();
  return NS_OK;
}

NS_IMPL_ADDREF(csUserAttributes)
NS_IMPL_RELEASE(csUserAttributes)

csUserAttributes :: csUserAttributes()
{
  NS_INIT_REFCNT();
}

csUserAttributes :: ~csUserAttributes()
{
}

NS_IMETHODIMP csUserAttributes :: Init(nsISupports * aServer)
{
  (nsISupports *) aServer;
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: GetDescription(nsString& aDescription)
{
  aDescription = "A Sample User Attributes Plugin";
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: GetVendorName(nsString& aVendorName)
{
  aVendorName = "Netscape Communications Corporation";
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) 
{
  aMajorValue = 2;
  aMinorValue = 0;
  return NS_OK;
}


NS_IMETHODIMP csUserAttributes :: GetAttribute(char * aUser, char * aKey, char ** aValue, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (void*) aKey;
  (void*) aValue;
  *aReturnCode = 0;
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: SetAttribute(char * aUser, char * aKey, char * aValue, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (void*) aKey;
  (void*) aValue;
  *aReturnCode = 0;
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: FreeAttribute(char * aValue, PRInt32 * aReturnCode)
{
  (void*) aValue;
  *aReturnCode = 0;
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: SearchCalendars(char* aSearchString, PRInt32 aSearchFlags, PRInt32 aSearchOpt, char ***aResults, PRInt32 *aCount)
{
  (void*)aSearchString;
  aSearchFlags = 0;
  aSearchOpt = 0;
  (void***)aResults;
  *aCount = 0;
  return NS_OK;
}

NS_IMETHODIMP csUserAttributes :: FreeSearchResults(char **aResults, PRInt32 *aReturnCode)
{
  (void**)aResults;
  *aReturnCode = 0;
  return NS_OK;
}
