#ifndef csDataTranslator_h___
#define csDataTranslator_h___

#include "csIPlugin.h"
#include "csIDataTranslator.h"
#include "nsString.h"

#define CS_IDATATRANSLATOR_CID                       \
{ /* e6ba64b0-cc2b-11d2-9e6d-00105ae811b7 */         \
    0xe6ba64b0,                                      \
    0xcc2b,                                          \
    0x11d2,                                          \
    {0x9e, 0x6d, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


class csDataTranslator : public csIDataTranslator,
                         public csIPlugin
{
public:
  csDataTranslator();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);


  NS_IMETHOD GetSupportedContentTypes(char ** aSupportedInContentTypes, 
                                      char ** aSupportedOutContentType,
                                      char ** aPreferredInContentType,
                                      PRInt32 * aReturnCode);

  NS_IMETHOD Translate(char * aInContentType, 
                       char * aOutContentType, 
                       char ** aInBuffer, 
                       char ** aOutBuffer, 
                       PRInt32 * aInSize,
                       PRInt32 * aOutSize,
                       PRInt32 * aReturnCode);

protected:

  virtual ~csDataTranslator();

};

#endif /* csDataTranslator_h___ */
