#include "csICalendarServer.h"
#include "csDataTranslator.h"
#include "nsString.h"

static NS_DEFINE_IID(kISupportsIID,       NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kDataTranslatorIID,  CS_IDATATRANSLATOR_IID);
static NS_DEFINE_IID(kPluginIID,          CS_IPLUGIN_IID);
static NS_DEFINE_IID(kICalendarServerIID, CS_ICALENDARSERVER_IID);

nsresult csDataTranslator :: QueryInterface(REFNSIID aIID, void** aInstancePtr)
{

  if (NULL == aInstancePtr)
    return NS_ERROR_NULL_POINTER;

  if (aIID.Equals(kDataTranslatorIID))
    *aInstancePtr = (void*)((csIDataTranslator *)this);
  else if (aIID.Equals(kISupportsIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIDataTranslator *)this);
  else if (aIID.Equals(kPluginIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIPlugin *)this);
  else
    return (NS_NOINTERFACE);  

  NS_ADDREF_THIS();
  return NS_OK;
}

NS_IMPL_ADDREF(csDataTranslator)
NS_IMPL_RELEASE(csDataTranslator)

csDataTranslator :: csDataTranslator()
{
  NS_INIT_REFCNT();
}

csDataTranslator :: ~csDataTranslator()
{
}

NS_IMETHODIMP csDataTranslator :: Init(nsISupports * aServer)
{
  nsresult res = NS_COMFALSE ;
  PRUint32 min, maj;

  csICalendarServer * cs;

  /* Here we QueryInterface for the CalendarServer. If this call succeeds, we will have
     bumped the reference count of the server by 1 
  */
  if (aServer)
    res = aServer->QueryInterface(kICalendarServerIID,(void**)&cs);

  /* If we succeeded in getting a reference to the server, let's check it's version */
  if (NS_SUCCEEDED(res))
  {
    
    cs->GetVersion(maj,min);

    if (min > 0 && maj >= 1)
      res = NS_OK;
    else
      res = NS_COMFALSE;

    /* Release our reference to this server instance */
    cs->Release();
  }

  return res;
}

NS_IMETHODIMP csDataTranslator :: GetDescription(nsString& aDescription)
{
  aDescription = "A Sample Data Translator Plugin";
  return NS_OK;
}

NS_IMETHODIMP csDataTranslator :: GetVendorName(nsString& aVendorName)
{
  aVendorName = "Netscape Communications Corporation";
  return NS_OK;
}

NS_IMETHODIMP csDataTranslator :: GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) 
{
  aMajorValue = 2;
  aMinorValue = 0;
  return NS_OK;
}


NS_IMETHODIMP csDataTranslator :: Translate(char * aInContentType, 
                                            char * aOutContentType, 
                                            char ** aInBuffer, 
                                            char ** aOutBuffer,
                                            PRInt32 * aInSize,
                                            PRInt32 * aOutSize,
                                            PRInt32 * aReturnCode)
{
  (void*) aInContentType;
  (void*) aOutContentType;
  (void*) aInBuffer;
  (void*) aOutBuffer;
  (void*) aInSize;
  *aOutSize = 0;
  *aReturnCode = 0;
  return NS_OK;
}

NS_IMETHODIMP csDataTranslator :: GetSupportedContentTypes(char ** aSupportedInContentTypes, 
                                                           char ** aSupportedOutContentType,
                                                           char ** aPreferredInContentType,
                                                           PRInt32 * aReturnCode) 
{
  (void*) aSupportedInContentTypes;
  (void*) aSupportedOutContentType;
  (void*) aPreferredInContentType;
  *aReturnCode = 0;
  return NS_OK;
}
