#ifndef csAuthentication_h___
#define csAuthentication_h___

#include "csIPlugin.h"
#include "csIAuthentication.h"
#include "nsString.h"

#define CS_IAUTHENTICATION_CID                       \
{ /* 9f036d10-bc90-11d2-9e6c-00105ae811b7 */         \
    0x9f036d10,                                      \
    0xbc90,                                          \
    0x11d2,                                          \
    {0x9e, 0x6c, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


class csAuthentication : public csIAuthentication,
                         public csIPlugin
{
public:
  csAuthentication();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);

  NS_IMETHOD  Logon(char * aUser, char * aPassword, PRInt32 * aReturnCode);
  NS_IMETHOD  Logout(char * aUser, PRInt32 * aReturnCode);
  NS_IMETHOD  VerifyUserExists(char * aUser, PRInt32 * aReturnCode);
  NS_IMETHOD  ChangePassword(char * aUser, char * aOldPassword, char * aNewPassword, PRInt32 * aReturnCode);

protected:

  virtual ~csAuthentication();

};

#endif /* csAuthentication_h___ */
