#include "csAuthentication.h"
#include "nsString.h"

static NS_DEFINE_IID(kISupportsIID,      NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kAuthenticationIID, CS_IAUTHENTICATION_IID);
static NS_DEFINE_IID(kPluginIID,         CS_IPLUGIN_IID);

nsresult csAuthentication :: QueryInterface(REFNSIID aIID, void** aInstancePtr)
{

  if (NULL == aInstancePtr)
    return NS_ERROR_NULL_POINTER;

  if (aIID.Equals(kAuthenticationIID))
    *aInstancePtr = (void*)((csIAuthentication *)this);
  else if (aIID.Equals(kISupportsIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIAuthentication *)this);
  else if (aIID.Equals(kPluginIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIPlugin *)this);
  else
    return (NS_NOINTERFACE);  

  NS_ADDREF_THIS();
  return NS_OK;
}

NS_IMPL_ADDREF(csAuthentication)
NS_IMPL_RELEASE(csAuthentication)

csAuthentication :: csAuthentication()
{
  NS_INIT_REFCNT();
}

csAuthentication :: ~csAuthentication()
{
}

NS_IMETHODIMP csAuthentication :: Init(nsISupports * aServer)
{
  (nsISupports*) aServer;
  return NS_OK;
}

NS_IMETHODIMP csAuthentication :: GetDescription(nsString& aDescription)
{
  aDescription = "Authentication Sample Plugin";
  return NS_OK;
}

NS_IMETHODIMP csAuthentication :: GetVendorName(nsString& aVendorName)
{
  aVendorName = "Netscape Communications Corporation";
  return NS_OK;
}

NS_IMETHODIMP csAuthentication :: GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) 
{
  aMajorValue = 1;
  aMinorValue = 0;
  return NS_OK;
}


NS_IMETHODIMP csAuthentication :: Logon(char * aUser, char * aPassword, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (void*) aPassword;
  *aReturnCode = 1;
  return NS_AUTHENTICATION_LOGON_SUCCESS;
}

NS_IMETHODIMP csAuthentication :: Logout(char * aUser, PRInt32 * aReturnCode)
{
  (void*) aUser;
  *aReturnCode = 1;
  return NS_AUTHENTICATION_LOGOUT_SUCCESS;
}

NS_IMETHODIMP csAuthentication :: VerifyUserExists(char * aUser, PRInt32 * aReturnCode)
{
  (void*) aUser;
  *aReturnCode = 1;
  return NS_AUTHENTICATION_VERIFYUSEREXISTS_SUCCESS;
}

NS_IMETHODIMP csAuthentication :: ChangePassword(char * aUser, char * aOldPassword, char * aNewPassword, PRInt32 * aReturnCode)
{
  (void*) aUser;
  (char *) aOldPassword;
  (char *) aNewPassword;
  *aReturnCode = 1;
  return NS_AUTHENTICATION_CHANGEPASSWORD_SUCCESS;
}


