#ifndef csAccessControl_h___
#define csAccessControl_h___

#include "csIPlugin.h"
#include "csIAccessControl.h"
#include "nsString.h"

#define CS_IACCESSCONTROL_CID                       \
{ /* B97C3121-E57E-11d3-BF5F-00805F8A8DBD */         \
    0xB97C3121,                                      \
    0xE57E,                                          \
    0x11d3,                                          \
    {0xBF, 0x5F, 0x00, 0x80, 0x5F, 0x8a, 0x8d, 0xbd} \
}


class csAccessControl : public csIAccessControl,
                         public csIPlugin
{
public:
  csAccessControl();

  NS_DECL_ISUPPORTS

  NS_IMETHOD  Init(nsISupports * aServer);

  NS_IMETHOD  GetDescription(nsString& aDescription);
  NS_IMETHOD  GetVendorName(nsString& aVendorName);
  NS_IMETHOD  GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue);

  NS_IMETHOD CheckAccess(char * aUser, 
                         char * aCalid, 
                         PRInt32 aAccessRequest,
                         PRInt32 * aAccessAllowed,
                         PRInt32 * aReturnCode);

protected:

  virtual ~csAccessControl();

};

#endif /* csAccessControl_h___ */
