#include "csAccessControl.h"
#include "nsString.h"

static NS_DEFINE_IID(kISupportsIID,      NS_ISUPPORTS_IID);
static NS_DEFINE_IID(kAccessControlIID, CS_IACCESSCONTROL_IID);
static NS_DEFINE_IID(kPluginIID,         CS_IPLUGIN_IID);

nsresult csAccessControl :: QueryInterface(REFNSIID aIID, void** aInstancePtr)
{

  if (NULL == aInstancePtr)
    return NS_ERROR_NULL_POINTER;

  if (aIID.Equals(kAccessControlIID))
    *aInstancePtr = (void*)((csIAccessControl *)this);
  else if (aIID.Equals(kISupportsIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIAccessControl *)this);
  else if (aIID.Equals(kPluginIID))
    *aInstancePtr = (void*) ((nsISupports*)(csIPlugin *)this);
  else
    return (NS_NOINTERFACE);  

  NS_ADDREF_THIS();
  return NS_OK;
}

NS_IMPL_ADDREF(csAccessControl)
NS_IMPL_RELEASE(csAccessControl)

csAccessControl :: csAccessControl()
{
  NS_INIT_REFCNT();
}

csAccessControl :: ~csAccessControl()
{
}

NS_IMETHODIMP csAccessControl :: Init(nsISupports * aServer)
{
  (nsISupports*) aServer;
  return NS_OK;
}

NS_IMETHODIMP csAccessControl :: GetDescription(nsString& aDescription)
{
  aDescription = "AccessControl Sample Plugin";
  return NS_OK;
}

NS_IMETHODIMP csAccessControl :: GetVendorName(nsString& aVendorName)
{
  aVendorName = "Netscape Communications Corporation";
  return NS_OK;
}

NS_IMETHODIMP csAccessControl :: GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) 
{
  aMajorValue = 1;
  aMinorValue = 0;
  return NS_OK;
}

NS_IMETHODIMP csAccessControl :: CheckAccess(char * aUser, 
                                             char * aCalid, 
                                             PRInt32 aAccessRequest,
                                             PRInt32 * aAccessAllowed,
                                             PRInt32 * aReturnCode)
{
  (char*) aUser;
  (char*) aCalid;
  (PRInt32) aAccessRequest;
  (PRInt32*) aAccessAllowed;
  *aReturnCode = 1;
  return NS_OK;
}


