#ifndef csIUserAttributes_h___
#define csIUserAttributes_h___

#include "nsISupports.h"

/**
 * Interface for user attributes
 */
class csIUserAttributes : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * Get a User Attribute
     *
     * @param aUser  - the user
     * @param aKey   - the attribute
     * @param aValue - the value
     * @param aReturnCode - the error code to be returned
     * @result NS_OK if successful
     */
    NS_IMETHOD GetAttribute(char * aUser, char * aKey, char ** aValue, PRInt32 * aReturnCode) = 0;

    /**
     * Set a User Attribute
     *
     * @param aUser  - the user
     * @param aKey   - the attribute
     * @param aValue - the value
     * @param aReturnCode - the error code to be returned
     * @result NS_OK if successful
     */
    NS_IMETHOD SetAttribute(char * aUser, char * aKey, char * aValue, PRInt32 * aReturnCode) = 0;

    /**
     * Free a User Attribute
     *
     * @param aValue - the value
     * @param aReturnCode - the error code to be returned
     * @result NS_OK if successful
     */
    NS_IMETHOD FreeAttribute(char * aValue, PRInt32 * aReturnCode) = 0;

    /**
     * Search calendar owned attribute
     *
     * @param aSearchString - the value to be searched
     * @param aSearchFlags  - 1 search calid, 2 - cal name and 4 - owner
     * @param aSearchOpt    - 0 - contains, 1 - begins with, 2 -ends with and 4 - exact
     * @param aResults - array of return values
     * @param aCount   - number of results returned
     * @result NS_OK if successful
     */
    NS_IMETHOD SearchCalendars(char* aSearchString, PRInt32 aSearchFlags, PRInt32 aSearchOpt, char ***aResults, PRInt32 *aCount) = 0;

    /**
     * Free the search results
     *
     * @param aRestults - values to be freed
     * @param aReturnCode - the error code to be returned
     * @result NS_OK if successful
     */
    NS_IMETHOD FreeSearchResults(char **aResults, PRInt32 *aReturnCode) = 0;

};

#define CS_IUSERATTRIBUTES_IID                       \
{ /* 012002b0-bfcb-11d2-9e6c-00105ae811b7 */         \
    0x012002b0,                                      \
    0xbfcb,                                          \
    0x11d2,                                          \
    {0x9e, 0x6c, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


#endif /* csIUserAttributes_h___ */
