#ifndef csIQualifiedCalidLookup_h___
#define csIQualifiedCalidLookup_h___

#include "nsISupports.h"

/**
 * This interface defines a translator from DB to the desired output format.
 */
class csIQualifiedCalidLookup : public nsISupports 
{

public:

    /**
     * Always gets called after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * Return back a calendar-identifier for the qualfied url.
     * If the calendar-identifier is not found, return an error.
     */
    NS_IMETHOD_(PRInt32) FindCalid(char * pQualifiedURL, 
                         char ** ppCalidOut, PRInt32 * piCalidSize,
                         PRInt32 * aReturnCode) = 0;
};

#define CS_IQUALIFIEDCALIDLOOKUP_IID                 \
{ /* 6f5a36dc-3036-11d4-ba4b-001083029ad0 */         \
    0x6f5a36dc,                                      \
    0x3036,                                          \
    0x11d4,                                          \
    {0xba, 0x4b, 0x00, 0x10, 0x83, 0x02, 0x9a, 0xd0} \
}


#endif /* csIQualifiedCalidLookup_h___ */
