#ifndef csIPlugin_h___
#define csIPlugin_h___

#include "nsISupports.h"
#include "nsString.h"

/**
 *
 * The csIPlugin interface *should* be implemented by all CSAPI plugins.
 * It allows the server to obtain useful information about the plugin,
 * what CSAPI modules it supports and what version it is.
 *
 * Not implementing this interface is 'OK', but deemed a poor thing.
 *
 */

class csIPlugin : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * Get Text Description of the Plugin
     *
     * @param aDescription - the description
     * @result NS_OK if successful
     */
    NS_IMETHOD GetDescription(nsString& aDescription) = 0;

    /**
     * Get Text Description of the vendor supplying this plugin
     *
     * @param aVendorName - the vendor name
     * @result NS_OK if successful
     */
    NS_IMETHOD GetVendorName(nsString& aVendorName) = 0;

    /**
     * Get the version of this plugin - must be >= 1.0
     *
     * @param aMajorValue - the major version number
     * @param aMinorValue - the minor version number
     * @result NS_OK if successful
     */
    NS_IMETHOD GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) = 0;


};

#define CS_IPLUGIN_IID                               \
{ /* aedd4cc0-bc7f-11d2-9e6c-00105ae811b7 */         \
    0xaedd4cc0,                                      \
    0xbc7f,                                          \
    0x11d2,                                          \
    {0x9e, 0x6c, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


#endif /* csIPlugin_h___ */
