#ifndef csIMalloc_h___
#define csIMalloc_h___

#include "nsISupports.h"
#include "nsString.h"

/**
 *
 * The csIMalloc interface can be obtained from the calendar server
 * so that plugins can have access to the fact memory allocation routines 
 * used in the server itself
 *
 */

class csIMalloc : public nsISupports 
{

public:

    /**
     * Always gets called after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init() = 0;

    /**
     * @description Malloc - Allocates nBytes memory
	 *
	 * @param PRUint32 nBytes - number of bytes to allocate
     *
     * @result ptr if successful, NULL if unsuccessful
     */

    NS_IMETHOD_(void*)  Malloc(PRUint32 nBytes) = 0;

    /**
     * @description Realloc - ReAllocates nBytes memory on previously allocated data
	 *
	 * @param void * aPtr     - pointer to previously allocated memory
	 * @param PRUint32 nBytes - number of bytes to allocate
     *
     * @result ptr if successful, NULL if unsuccessful
     */

    NS_IMETHOD_(void*)  Realloc(void * aPtr, PRUint32 nBytes) = 0;

    /**
     * @description Calloc - Allocated and initializes to zero aSize*aNum bytes of data
	 *
	 * @param PRUint32 nSize - number of bytes in each object
	 * @param PRUint32 nNum  - number of objects
     *
     * @result ptr if successful, NULL if unsuccessful
     */

    NS_IMETHOD_(void*)  Calloc(PRUint32 aSize, PRUint32 aNum) = 0;

    /**
     * @description Free - free's previously allocated memory
	 *
	 * @param void * aPtr     - pointer to previously allocated memory
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD   Free(void * aPtr) = 0;

    /**
     * @description Free - free's previously allocated memory, if aPtr is not NULL
	 *
	 * @param void * aPtr     - pointer to previously allocated memory
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD   FreeIf(void * aPtr) = 0;


};

#define CS_IMALLOC_IID                       \
{ /* 53199ff0-ee10-11d2-a4f0-0060b0670ba5 */         \
    0x53199ff0,                                      \
    0xee10,                                          \
    0x11d2,                                          \
    {0xa4, 0xf0, 0x00, 0x60, 0xb0, 0x67, 0x0b, 0xa5} \
}


#endif /* csIMalloc_h___ */




