#ifndef csIDataTranslator_h___
#define csIDataTranslator_h___

#include "nsISupports.h"

/**
 * This is the interface for data translator plugins.
 */
class csIDataTranslator : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;


    /**
     * @description - The purpose of this method is for the plugin to supply what content-type it wants to
     *                convert from and what content type it can convert to. All out parameters should be allocated
     *                by the plugin.
     *
     * @inparam aSupportedInContentTypes    - the list of server supported content-types to send as input
     *                                        this is an array of null terminated strings
     * @outparam aSupportedOutContentType   - the content-type the plugin will convert data to
     * @outparam aPreferredInContentType    - the preferred content-type the plugin would like to receive in order
     *                                        to convert data.  This content-type MUST be one of the server
     *                                        supported content-types pass in the first paramater (aSupportedInContentTypes)

     * @param aReturnCode      - Return code to allow normal processing to continue
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD GetSupportedContentTypes(char ** aSupportedInContentTypes, 
                                        char ** aSupportedOutContentType,
                                        char ** aPreferredInContentType,
                                        PRInt32 * aReturnCode) = 0;


    /**
     * @description - This routine does the actual translation of data between content types
     *
     * @param aInContentType   - the ContentType Incoming
     * @param aOutContentType  - the ContentType Outgoing
     * @param aInBuffer        - the input data buffer
     * @param aOutBuffer       - the output data buffer
     * @param aInSize          - the input buffer size
     * @param aOutSize         - the output buffer size
     * @param aReturnCode      - Return code op
     *
     * @result NS_OK if successful
     */
    NS_IMETHOD Translate(char * aInContentType, 
                         char * aOutContentType, 
                         char ** aInBuffer, 
                         char ** aOutBuffer, 
                         PRInt32 * aInSize,
                         PRInt32 * aOutSize,
                         PRInt32 * aReturnCode) = 0;

};

#define CS_IDATATRANSLATOR_IID                       \
{ /* 2b7a4050-cc28-11d2-9e6d-00105ae811b7 */         \
    0x2b7a4050,                                      \
    0xcc28,                                          \
    0x11d2,                                          \
    {0x9e, 0x6d, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


#endif /* csIDataTranslator_h___ */
