#ifndef csICalendarServer_h___
#define csICalendarServer_h___

#include "nsISupports.h"
#include "nsString.h"

/**
 *
 * the csICalendarServer interface can be queried by plugins to get specific
 * information about this running instance of the calendar server.  This object
 * is valid for the full lifetime of the client, so no reference is needed.
 *
 */

class csICalendarServer : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init() = 0;

    /**
     * Get the version of the calendar server - must be >= 1.0
     *
     * @param aMajorValue - the major version number
     * @param aMinorValue - the minor version number
     * @result NS_OK if successful
     */

    NS_IMETHOD GetVersion(PRUint32& aMajorValue, PRUint32& aMinorValue) = 0;

};

#define CS_ICALENDARSERVER_IID                       \
{ /* 2a148df0-ee10-11d2-a4f0-0060b0670ba5 */         \
    0x2a148df0,                                      \
    0xee10,                                          \
    0x11d2,                                          \
    {0xa4, 0xf0, 0x00, 0x60, 0xb0, 0x67, 0x0b, 0xa5} \
}


#endif /* csICalendarServer_h___ */




