#ifndef csICalendarLookup_h___
#define csICalendarLookup_h___

#include "nsISupports.h"


/**
 * This is the interface for calendar lookup.
 */
class csICalendarLookup : public nsISupports 
{

public:

    /**
     * Always gets called after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;


    /**
     * @description - Qualify the relative calid using appropriate mechanism
     *
     * @inparam aRelativeCalid    - the relative calid
     * @outparam aQualifiedCalid  - url of qualified calid.
     *				it is a pointer to a pointer to char.
     *				the pointer to char should point to null,
     *				otherwise memory will leak.
     * @param aReturnCode      - Return code to allow normal processing to continue
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD QualifyCalid(char * aRelativeCalid, 
                            char ** aQualifiedCalid,
                            PRInt32 * aReturnCode) = 0;


    /**
     * @description - Free a previously allocated fully qualified calid
     *
     * @param aQualifiedCalid   - calid to free
     * @param aReturnCode      - Return code op
     *
     * @result NS_OK if successful
     */
    NS_IMETHOD FreeCalid(char ** aQualifiedCalid, 
                         PRInt32 * aReturnCode) = 0;

    /**
     * @description - Query Type of Plugin
     *
     * @outparam aType  - type of CLD
     *
     * @param aReturnCode      - Return code to allow normal processing to continue
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD QueryType(char ** aType,
                         PRInt32 * aReturnCode) = 0;


    /**
     * @description - Free a previously allocated type
     *
     * @param aType   - type to free
     * @param aReturnCode      - Return code op
     *
     * @result NS_OK if successful
     */
    NS_IMETHOD FreeType(char ** aType, 
                        PRInt32 * aReturnCode) = 0;


  /**
   * @description           - This call is made to delete the dwp hostname 
   *    associated with a calendar in the calendar lookup database.  Note 
   *    that for the RegularExpression implementation, this is a no-op.
   *
   * @param psCalid         - calid
   *
   * @outparam piReturnCode - CLD-specific return status
   *                          NS_OK if successful.
   * @result                - NS_OK if successful.
   */
  NS_IMETHOD DeleteHostnameForCalid(char* psCalid, 
        PRInt32 *piReturnCode) = 0;

  /**
   * @description           - This call is made to set the dwp hostname 
   *    associated with a calendar in the calendar lookup database.  Note 
   *    that for the RegularExpression implementation, this is a no-op.
   *
   * @param psCalid         - calid
   * @param psHost          - hostname
   *
   * @outparam piReturnCode - CLD-specific return status
   *                          NS_OK if successful.
   *
   * @result                - NS_OK if successful.
   */
  NS_IMETHOD SetHostnameForCalid(char* psCalid, char* psHost, 
        PRInt32 *piReturnCode) = 0;

  /**
   * @description           - This call is made to get the dwp 
   *    hostname associated with a calendar in the calendar lookup 
   *    database.  Note that for the RegularExpression implementation, 
   *    this is a no-op.
   *
   * @param psCalid         - calid
   * @param psHost          - hostname
   * @outparam piReturnCode - CLD-specific return status
   *                          NS_OK if successful.
   * @result                - NS_OK if successful.
   */
  NS_IMETHOD GetHostnameForCalid(char* psCalid, char** ppsHost, 
       PRInt32 *piReturnCode) = 0;

};

#define CS_ICALENDARLOOKUP_IID                       \
{ /* fb5237c0-c7d4-11d3-bf5a-00805f8a8dbd */         \
    0xfb5237c0,                                      \
    0xc7d4,                                          \
    0x11d3,                                          \
    {0xbf, 0x5a, 0x00, 0x80, 0x5f, 0x8a, 0x8d, 0xbd} \
}


#endif /* csICalendarLookup_h___ */
