#ifndef csIAuthentication_h___
#define csIAuthentication_h___

#include "nsISupports.h"
#include "nsError.h"

/**
 *
 * The csIAuthentication interface must be implemented by all plugins wishing to override
 * the default authentication behavior of the calendar server
 *
 */

/*
 * The following nsresult values should be returned by the Logon method
 */

#define NS_AUTHENTICATION_LOGON_SUCCESS NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_AUTHENTICATION,1)
#define NS_AUTHENTICATION_LOGON_FAILURE NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_AUTHENTICATION,2)

/*
 * The following nsresult values should be returned by the Logoff method
 */

#define NS_AUTHENTICATION_LOGOUT_SUCCESS NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_AUTHENTICATION,3)
#define NS_AUTHENTICATION_LOGOUT_FAILURE NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_AUTHENTICATION,4)

/*
 * The following nsresult values should be returned by the VerifyUserExists method
 */

#define NS_AUTHENTICATION_VERIFYUSEREXISTS_SUCCESS NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_AUTHENTICATION,5)
#define NS_AUTHENTICATION_VERIFYUSEREXISTS_FAILURE NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_AUTHENTICATION,6)

/*
 * The following nsresult values should be returned by the ChangePassword method
 */

#define NS_AUTHENTICATION_CHANGEPASSWORD_SUCCESS NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_AUTHENTICATION,5)
#define NS_AUTHENTICATION_CHANGEPASSWORD_FAILURE NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_AUTHENTICATION,6)

/**
 *
 * The csIAuthentication interface must be implemented by all plugins wishing to override
 * the default authentication behavior of the calendar server
 *
 */
class csIAuthentication : public nsISupports 
{

public:

    /**
     * Always gets caled after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * Login a User
     *
     * @param aUser - the username
     * @param aPassword - the password
     * @param aReturnCode - NS_CONTINUE_DEFAULT_PROCESSING - to allow server to continue default processing
     *                      NS_OVERRIDE_DEFAULT_PROCESSING - to override server's native authentication mechanism
     * @result NS_OK if successful
     */
    NS_IMETHOD Logon(char * aUser, char * aPassword, PRInt32 * aReturnCode) = 0;

    /**
     * Logout a User
     *
     * @param aUser - the username
     * @param aReturnCode - NS_CONTINUE_DEFAULT_PROCESSING - to allow server to continue default processing
     *                      NS_OVERRIDE_DEFAULT_PROCESSING - to override server's native authentication mechanism
     * @result NS_OK if successful
     */
    NS_IMETHOD Logout(char * aUser, PRInt32 * aReturnCode) = 0;

    /**
     * Verify Existence of a User
     *
     * @param aUser - the username
     * @param aReturnCode - NS_CONTINUE_DEFAULT_PROCESSING - to allow server to continue default processing
     *                      NS_OVERRIDE_DEFAULT_PROCESSING - to override server's native authentication mechanism
     * @result NS_OK if successful
     */
    NS_IMETHOD VerifyUserExists(char * aUser, PRInt32 * aReturnCode) = 0;

    /**
     * change password of a User
     *
     * @param aUser - the username
     * @param aOldPassword - the old password
     * @param aNewPassword - the new password
     * @param aReturnCode - NS_CONTINUE_DEFAULT_PROCESSING - to allow server to continue default processing
     *                      NS_OVERRIDE_DEFAULT_PROCESSING - to override server's native authentication mechanism
     * @result NS_OK if successful
     */
    NS_IMETHOD ChangePassword(char * aUser, char * aOldPassword, char * aNewPassword, PRInt32 * aReturnCode) = 0;

};

#define CS_IAUTHENTICATION_IID                       \
{ /* 9e74bfd0-bc80-11d2-9e6c-00105ae811b7 */         \
    0x9e74bfd0,                                      \
    0xbc80,                                          \
    0x11d2,                                          \
    {0x9e, 0x6c, 0x00, 0x10, 0x5a, 0xe8, 0x11, 0xb7} \
}


#endif /* csIAuthentication_h___ */
