#ifndef csIAccessControl_h___
#define csIAccessControl_h___

#include "nsISupports.h"

/* Access types */
#define ICS_ACCESSTYPE_NONE                 0x00000000
#define ICS_ACCESSTYPE_READCOMPONENT        0x00000001
#define ICS_ACCESSTYPE_WRITECOMPONENT       0x00000002
#define ICS_ACCESSTYPE_CREATECOMPONENT      0x00000008
#define ICS_ACCESSTYPE_DELETECOMPONENT      0x00000010
#define ICS_ACCESSTYPE_READCALENDAR         0x00000020
#define ICS_ACCESSTYPE_WRITECALENDAR        0x00000040
#define ICS_ACCESSTYPE_CREATECALENDAR       0x00000080
#define ICS_ACCESSTYPE_DELETECALENDAR       0x00000100
#define ICS_ACCESSTYPE_SCHEDULE             0x00000200
#define ICS_ACCESSTYPE_FREEBUSY             0x00000400
#define ICS_ACCESSTYPE_SELF_ADMIN           0x00000800
#define ICS_ACCESSTYPE_AOB_REPLY            0x00001000
#define ICS_ACCESSTYPE_AOB_INVITE           0x00002000
#define ICS_ACCESSTYPE_AOB_CANCEL           0x00004000

#define ICS_ACCESSTYPE_ALL                  0xFFFFFFFF

/**
 *
 * The csIAccessControl interface must be implemented by all plugins wishing to override
 * the default access control behavior of the calendar server
 *
 */

class csIAccessControl : public nsISupports 
{

public:

    /**
     * Always gets called after the object is created
     *
     * @result NS_OK if successful
     */

    NS_IMETHOD Init(nsISupports * aServer) = 0;

    /**
     * This function is used by an enduser to define their own access control to a calendar.
     * The caller of the function passes in
     *  1) the userid of the user to check access on
     *  2) the calendar-id to check access on
     *  3) a bitmask representing what types of access to check on
     * The implementer of the function will then need to return a bitmask indicating what
     * access types the user is allowed and an errorcode.
     * The types of access the user is allowed is defined by the ICS_ACCESSTYPE constants above.
     * The errorcode returned can be either 
     *  1) NS_CONTINUE_DEFAULT_PROCESSING - allow server to continue default behavior
     *  2) NS_OVERRIDE_DEFAULT_PROCESSING - override the server' default behavior
     *
     * @param aUser - authenticated user making the request. For anonymous access, pUserID is "anonymous" 
     * @param aCalid - calid for calendar
     * @param aAccessRequest - set of bit flags representing the requested access types
     * @param aAccessAllowed - outparam - set of bit flags representing the allowed accesses. 
     *                         only bits specified in aAccessRequest are checked.
     * @param aReturnCode - NS_CONTINUE_DEFAULT_PROCESSING - to allow server to continue default processing
     *                      NS_OVERRIDE_DEFAULT_PROCESSING - to override server's native access control mechanism
     * @result NS_OK if successful
     */
    NS_IMETHOD CheckAccess(char * aUser, 
                           char * aCalid, 
                           PRInt32 aAccessRequest,
                           PRInt32 * aAccessAllowed,
                           PRInt32 * aReturnCode) = 0;


};

#define CS_IACCESSCONTROL_IID                       \
{ /* 3C38FD73-E57A-11d3-BF5F-00805F8A8DBD */         \
    0x3C38FD73,                                      \
    0xE57A,                                          \
    0x11d3,                                          \
    {0xbf, 0x5f, 0x00, 0x80, 0x5f, 0x8a, 0x8d, 0xbd} \
}


#endif /* csIAccessControl_h___ */
