/*
** NETSCAPE COMMUNICATIONS CORPORATION 
** 
** Copyright (c) 1998 Netscape Communications Corporation. All Rights
** Reserved. 
** 
** Use of this Source Code is subject to the terms of the applicable license
** agreement from Netscape Communications Corporation. 
** 
** The copyright notice(s) in this Source Code does not indicate actual or
** intended publication of this Source Code. 
**
**  Filename 
**  --------
**  expapi.h
**
**  Description
**  -----------
**  header file for calendar express api
**  
**
*/

/* DLLs need this */
#ifdef XP_UNIX
#define __export
#else
#define __export __declspec(dllexport)
#endif


/* the longest URL we will ever return */
#define MAX_URL_LENGTH 2048

/* Public Interface Functions */

/*
 * Name: CEXP_Init
 *
 * Purpose:  Initialize the SDK
 *
 * Parameters: a string containing the hostname of the 
 * directory server, a string containing the attrib name
 * that you want to match the user name against, a string
 * containing the base DN to search for user records, an
 * integer specifying the directory servers port number, a
 * string specifying the DN to bind as, and a string
 * containing the password for the bind DN
 *
 * Returns: 0 on success, -1 on failure
 *
 * Comments: If the bindDN and password are NULL, anonymous
 * searching will be attempted.
 *
 */
extern __export int CEXP_Init(char *pszLdapHost, 
	     char *pszLdapMatchAttrib, 
	     char *pszLdapDN, 
	     unsigned int iLdapPort,
	     char *pszLdapBindUser,
	     char *pszLdapBindPass,
             char *pszAdminUser,
             char *pszAdminPassword);

/*
 * Name: CEXP_GenerateLoginURL
 *
 * Purpose: Return a login URL with valid session ID for
 * a given user
 *
 * Parameters: a string containing the user name, a string
 * containing the client host IP-address, a string containing
 * the hostname (no ip-address) of the calendar server, and a ptr 
 * to a buffer into which the URL can be placed.
 *
 * Returns: 0 on sucess, -1 on failure. On sucess the pszURL
 * buffer will be filled with a valid URL string.
 *
 * Comments: none
 *
 */
extern __export int CEXP_GenerateLoginURL(char *pszUser, 
			 char* pszClientAddress, 
			 char *pszCalendarHost,
			 char *pszURL);


/*
 * Name: CEXP_Shutdown
 *
 * Purpose: Cleanup all global memory, shutdown connections, 
 * etc when user is finsihed using the SDK.
 *
 * Parameters: None
 *
 * Returns: 0 indicating success, -1 indicating failure
 *
 * Comments: This should only be called after all threads using
 * the SDK have completed.
 *
 */
extern __export int CEXP_Shutdown(void);


/*
 * Name: CEXP_GetVersion
 *
 * Purpose: get version ID string
 *
 * Parameters: None
 *
 * Returns: string containing version string
 *
 */
extern __export char* CEXP_GetVersion(void);


/*
 * Name: CEXP_SetHttpPort
 *
 * Purpose: set the HTTP Port used when contacting a
 * webcalendar server
 *
 * Parameters: an integer specifying the port
 *
 * Returns: nothing
 *
 */
extern __export void CEXP_SetHttpPort(int iHttpPort);

