/*
** NETSCAPE COMMUNICATIONS CORPORATION 
** 
** Copyright (c) 1998 Netscape Communications Corporation. All Rights
** Reserved. 
** 
** Use of this Source Code is subject to the terms of the applicable license
** agreement from Netscape Communications Corporation. 
** 
** The copyright notice(s) in this Source Code does not indicate actual or
** intended publication of this Source Code. 
**
**  Filename 
**  --------
**  expauth.c
**
**  Description
**  -----------
**  source file for calendar express sample proxy auth sample CGI
**  
**
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "expapi.h"

#define HTML_SOURCE_FILE "login.html"
#define BUFFER_SIZE 1024
#define CALENDAR_SERVER "calendar.yourdomain.com"
#define DIRECTORY_SERVER "directory.yourdomain.com"
#define DN "o=yourdomain.com"
#define ADMINNAME "admin"
#define ADMINPASS "admin"

static void handle_get(void);
static void handle_post(void);

/*
 * put whatever HTML you want in the HTML_SOURCE_FILE
 * and this will spit it out to the user when they access
 * the CGI.
 */
static void handle_get(void) {
    FILE	*hHtmlFile;
    char	buffer[BUFFER_SIZE];

    if ((hHtmlFile = fopen(HTML_SOURCE_FILE, "r")) == NULL) {
	/* print something */
	fprintf(stdout, "<HTML><BR><CENTER><B>\r\n");
	fprintf(stdout, "Unable to read login source file\r\n");
	fprintf(stdout, "</B></CENTER></HTML>\r\n");
	return;
    }

    while (fgets(buffer, BUFFER_SIZE, hHtmlFile) != NULL) {
	fputs(buffer, stdout);
    }
}


/* 
 * as long as the CGI posts input variables named
 * "user" and "password" this will pick them up
 */
static void handle_post(void) {
    char	buffer[BUFFER_SIZE];
    char	user[BUFFER_SIZE];
    char	password[BUFFER_SIZE];
    char	url[BUFFER_SIZE];
    char	*p, *q;
    char	*ipaddress;

    /* 
     * note that in a real example you will probably
     * need to unescape the values from CGI post if
     * users have passwords with odd characters in them 
     * read http://hoohoo.ncsa.uiuc.edu/cgi/ for more info
     */

    /* read in the input */
    while(fgets(buffer, BUFFER_SIZE, stdin) != NULL) {

	if ((p = strchr(buffer, '\n')) != NULL)
	    *p = '\0';

	/* snag the user value */
	if ((p = strstr(buffer, "user=")) != NULL) {
	    p += 5;
	    if (p != '\0') {
		if ((q=strchr(p, '&')) == NULL) 
		    q=strchr(p, '\0');

		strncpy(user, p, q-p);
		user[q-p] = '\0';
	    }
	}

	/* snag the password value */
	if ((p = strstr(buffer, "password=")) != NULL) {
	    p += 9;
	    if (p != '\0') {
		if ((q=strchr(p, '&')) == NULL) 
		    q=strchr(p, '\0');

		strncpy(password, p, q-p);
		user[q-p] = '\0';
	    }
	}
	    
	/* parse for other stuff here */

    }
    
    /* 
     * now you call whatever your local authentication function is
     * to see if the password is correct. If it is, you get them a
     * session ID and send them the URL.
     */



    /* init the SDK */
    if (CEXP_Init(DIRECTORY_SERVER, "calendar", DN, 389, NULL, NULL, 
            ADMINNAME, ADMINPASS) == -1) {
        fprintf(stdout, "<HTML><SCRIPT>\n");
        fprintf(stdout, "alert('Unable to initialize authentication system');");
        fprintf(stdout, "</SCRIPT></HTML>\n");
        handle_get();
	return;
    }

    /*
     * you can get remote ip address (and lots of other stuff)
     * from the ENV vars http://hoohoo.ncsa.uiuc.edu/cgi/env.html
     */

    ipaddress = getenv("REMOTE_ADDR");

    /* attempt authentication */
    if (CEXP_GenerateLoginURL(user, ipaddress, CALENDAR_SERVER, url) == -1) {
        fprintf(stdout, "<HTML><SCRIPT>\n");
        fprintf(stdout, "alert('Authentication failed');");
        fprintf(stdout, "</SCRIPT></HTML>\n");
        handle_get();
	return;
    }

    /* authentication succeeded */
    fprintf(stdout, "<HTML><SCRIPT>\n");
    fprintf(stdout, "top.location='%s';\n", url);
    fprintf(stdout, "</SCRIPT></HTML>\n");

    return;
}


void main() {
    char 	*p;

    fprintf(stdout, "Content-type: text/html\r\n\r\n");

    p = getenv("REQUEST_METHOD");
    if ((p == NULL) || strcmp(p, "POST"))
	handle_get();
    else
	handle_post();

    exit(0);
}




