<%@ page language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/lib/sa.tld" prefix="sa"%>

<jato:useViewBean className="com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.reports.ZonePowerViewBean">

<%
  String isPrivilegedUser = (String)session.getAttribute("storade.privilegedRole");
  if (isPrivilegedUser == null) isPrivilegedUser = "false";
%>


<cc:header name="Header"
    pageTitle = "Zone Power up/down"
    baseName="com.sun.netstorage.mgmt.fm.storade.ui.resources.ApplicationResources"
    bundleID="appBundle">

<jato:form name="zoneForm" method="post">

<script language="javascript">
function toggleDisabledState() {
   // do we have the role to activate the menu?
   if (!('true' == '<%=isPrivilegedUser%>')) return;
   // Action button and menu names.
   var upButton = "ZonePower.powerUpButton";
   var downButton = "ZonePower.powerDownButton";
	
   // Element name (prefix) of selection checkbox/radiobutton.
   var elementName = "ZonePower.Table.SelectionCheckbox";
  
   // Document form.
   var form = document.zoneForm;

   // acked id list
   var idList = form.elements["ZonePower.IdList"].value;
 
   // Flag indicating to disable action button and menu options.
   var disabled_all = true;
   var disabled_up = false;
   var disabled_down = false; 

   // Set flags according to single or multiple selections.
   for (i = 0; i < form.elements.length; i++) {
        var e = form.elements[i];

        if (e.name.indexOf(elementName) != -1 && e.name.indexOf(".jato_boolean") == -1) {
             if (e.checked) {
                disabled_all = false;
                var id = e.name.substring(elementName.length, e.name.length);
	        if(idList.indexOf('|'+id+'|') != -1)
                    disabled_down = true;
                else
                    disabled_up = true;           
            }
        }
   }
  
   // Toggle action button disabled state.
   ccSetButtonDisabled(upButton, "zoneForm", disabled_all || disabled_up);
   ccSetButtonDisabled(downButton, "zoneForm", disabled_all || disabled_down);
}
</script>

<div class="ConMgn">                            
<!-- Alert -->
<br /><cc:alertinline name="Alert" bundleID="appBundle" />
</div>

<!-- Bread Crumb component -->

<cc:spacer name="spacer" height="15" newline="true"/>

<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
<td align="right" nowrap="nowrap" valign="bottom">
<cc:button name="BackToAdvisor" defaultValue="button.backToAdvisor" bundleID="appBundle" />
</td>
</tr>
</table>

<cc:spacer name="spacer" height="10" newline="true"/>

<cc:actiontable 
 name="Table" 
 bundleID="appBundle" 
 title="table.title.zonePower" 
 summary="table.summary.zonePower" 
 empty="table.empty.zonePower" 
 selectionType="multiple"
 selectionJavascript="toggleDisabledState()"
 showAdvancedSortingIcon="true" 
 showLowerActions="false" 
 showPaginationControls="false" 
 showPaginationIcon="false" 
 showSelectionIcons="true" 
 page="1" />

<cc:spacer name="spacer" height="10" newline="true"/>

<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
<td align="right" nowrap="nowrap" valign="bottom">
<cc:button name="BackToAdvisor" defaultValue="button.backToAdvisor" bundleID="appBundle" />
</td>
</tr>
</table>

<cc:hidden name="IdList" />

</jato:form>

</cc:header> 

</jato:useViewBean>





