<%@ page language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%> 
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/lib/sa.tld" prefix="sa"%>

<jato:useViewBean className="com.sun.netstorage.mgmt.fm.storade.ui.viewbeans.alarms.AlarmsViewBean">

<%
  String isPrivilegedUser = (String)session.getAttribute("storade.privilegedRole");
  if (isPrivilegedUser == null) isPrivilegedUser = "false";
%>

<sa:primarymasthead name="Masthead" showDefaultPageTitle="simple">

<script language="javascript">
// This function will toggle the disabled state of action buttons
// depending on single or multiple selections.

function deleteAlarmConfirm() {

 return confirm('<cc:text name="JSAlert" bundleID="appBundle" defaultValue="js.alert.deleteAlarm.confirm" escape="false"/>');

}

function toggleDisabledState() {
   // do we have the role to activate the menu?
   if (!('true' == '<%=isPrivilegedUser%>')) return;
   // Action button and menu names.
   var delButton = "Alarms.deleteButton";
   var ackButton = "Alarms.ackButton";
   var unackButton = "Alarms.unackButton";
	
   // Element name (prefix) of selection checkbox/radiobutton.
   var elementName = "Alarms.AlarmsTable.SelectionCheckbox";
  
   // Document form.
   var form = document.alarmForm;

   // acked id list
   var idList = form.elements["Alarms.IdList"].value;
 
   // Flag indicating to disable action button and menu options.
   var disabled_all = true;
   var disabled_ack = false;
   var disabled_unack = false; 

   // Set flags according to single or multiple selections.
   for (i = 0; i < form.elements.length; i++) {
        var e = form.elements[i];

        if (e.name.indexOf(elementName) != -1 && e.name.indexOf(".jato_boolean") == -1) {
             if (e.checked) {
                disabled_all = false;
                var id = e.name.substring(elementName.length, e.name.length);
	        if(idList.indexOf('|'+id+'|') != -1)
                    disabled_ack = true;
                else
                    disabled_unack = true;           
            }
        }
   }
  
   // Toggle action button disabled state.
   ccSetButtonDisabled(delButton, "alarmForm", disabled_all);
   ccSetButtonDisabled(ackButton, "alarmForm", disabled_all || disabled_ack);
   ccSetButtonDisabled(unackButton, "alarmForm", disabled_all || disabled_unack);
}
</script>

<jato:form name="alarmForm" method="post">

<!-- Bread Crumb component -->

<cc:spacer name="spacer" height="15" newline="true"/>

<cc:actiontable 
 name="AlarmsTable" 
 bundleID="appBundle" 
 title="table.title.allAlarms" 
 summary="table.summary.alarms" 
 empty="table.empty.alarms" 
 selectionType="multiple"
 selectionJavascript="toggleDisabledState()"
 showAdvancedSortingIcon="true" 
 showLowerActions="true" 
 showPaginationControls="true" 
 showPaginationIcon="true" 
 showSelectionIcons="true" 
 page="1" />

<cc:hidden name="IdList" />
</jato:form>
</sa:primarymasthead>

</jato:useViewBean>
