# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# $Id: TreefrogControls.pm,v 1.9 2005/03/28 15:55:29 sbrooks Exp $
package Java::TreefrogControls;

use Java::JrexMsg;
use Java::JrexClient;
use System;
use Debug;
use strict;


# Causes the LEDs of all installed drives to start blinking
# Requires the deviceKey of the target array.
# ex: SUN.348-0046776.0412071149
sub blinkArrayLEDs 
{
  my($class, $devKey) = @_;
  my $props = &getProperties($devKey);

  my $client = new Java::JrexClient();

  use Data::Dumper;
  $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"blinkArrayLEDs",
	[$props]
  );

  my $rval;
  if ($client->error)
  {
     $rval = $client->error; # error is a hash
  }
  else
  {
     $rval = "OK";
  }

  return $rval;

}

# Causes the LEDs of all drives in the target tray to start blinking
# Requires the deviceKey of the target array and the midplane device id
# ex. SUN.348-0046776.0412071149 and t0mpn
sub blinkTrayLEDs 
{
  my($class, $devKey, $id) = @_;
  my $props = &getProperties($devKey);

  my $client = new Java::JrexClient();

  use Data::Dumper;
  $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"blinkTrayLEDs",
	[$props, $id]
  );

  my $rval;
  if ($client->error)
  {
     $rval = $client->error; # error is a hash
  }
  else
  {
     $rval = "OK";
  }

  return $rval;


}

# Causes the LED of a drive to start blinking.
# Requires the deviceKey of the target array and the device id of the drive
# ex. SUN.348-0046776.0412071149 and t11drive5
sub blinkDriveLED 
{
  my($class, $devKey, $id) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  use Data::Dumper;
  $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"blinkDriveLED",
	[$props, $id]
  );

  my $rval;
  if ($client->error)
  {
     $rval = $client->error; # error is a hash
  }
  else
  {
     $rval = "OK";
  }

  return $rval;

}

# Causes the LED of a channel to start blinking.
# Requires the deviceKey of the target array and the id of the channel
# ex. SUN.348-0046776.0412071149 and t11drive5
sub blinkChannelLED 
{
  my($class, $devKey, $channel) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  use Data::Dumper;
  $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"blinkChannelLED",
	[$props, $channel]
  );

  my $rval;
  if ($client->error)
  {
     $rval = $client->error; # error is a hash
  }
  else
  {
     $rval = "OK";
  }

  return $rval;

}



# Indescriminately causes all blinking LEDs in the target array to
# cease blinking.
# Requires the deviceKey of the target array.
# ex: SUN.348-0046776.0412071149
sub stopLEDBlinking 
{
  my($class, $devKey) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  use Data::Dumper;
  $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"turnOffLEDs",
	[$props]
  );


  my $rval;
  if ($client->error)
  {
     $rval = $client->error; # error is a hash
  }
  else
  {
     $rval = "OK";
  }

  return $rval;
}

# Sets the target controller to the passive state
# Requires the deviceKey of the target array and the deviceID of the
# target controller.
# ex: SUN.348-0046776.0412071149 and t0ctr2
sub deactivateController 
{
  my($class, $devKey, $id) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  my $password = System->getDevicePassword($props, "6130");

  if (!$password)
  {
     $password = "";
  }

  my $rval = $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"deactivateController",
	[$props, $id, $password]
  );

  return $rval;
}

# Sets the target controller to the active state
# Requires the deviceKey of the target array and the deviceID of the
# target controller.
# ex: SUN.348-0046776.0412071149 and t0ctr2
sub activateController 
{
  my($class, $devKey, $id) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  my $password = System->getDevicePassword($props, "6130");
  if (!$password)
  {
     $password = "";
  }

  my $rval = $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"activateController",
	[$props, $id, $password]
  );


  return $rval;
}

# Resets the target battery date
# Requires the deviceKey of the target array and the deviceID of the
# target battery.
# ex: SUN.348-0046776.0412071149 and t0ctr2bat
sub resetBattery 
{
  my($class, $devKey, $id) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  my $password = System->getDevicePassword($props, "6130");
  if (!$password)
  {
     $password = "";
  }

  my $rval = $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"resetBattery",
	[$props, $id, $password]
  );

  return $rval;
}

# Set the target drive channel to optimal
# Requires the deviceKey of the target array and the channel to affect.
# Valid channel ids are 1 and 2
# 
# ex: SUN.348-0046776.0412071149 1 
sub setDriveChannelOptimal 
{
  my($class, $devKey, $channelID) = @_;

  my $props = &getProperties($devKey);
  my $client = new Java::JrexClient();

  my $password = System->getDevicePassword($props, "6130");
  if (!$password)
  {
     $password = "";
  }

  my $rval = $client->invoke
  ("com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt.Controls",
	"setDriveChannelOptimal",
	[$props, $channelID, $password]
  );

  return $rval;
}

# Collects support data for the target array
# Requires the deviceKey, ip or name of the target array, a path to the
# location for the output file, and a name for the output file.
# Note: The password recorded for the array (if any) will be
# used as it is required for some of the data collection operations.
#
# ex: SUN.348-0046776.0412071149  /tmp  SupportData
sub getSupportData 
{
  my($class, $devKey, $path, $fileName) = @_;
  my $rval = "no data";

  if ($devKey && $path && $fileName)
  {

     my $props = &getProperties($devKey);

     if ($props)
     {
        my $client = new Java::JrexClient();
     
        $rval = $client->invoke
        ("com.sun.netstorage.fm.storade.device.storage.treefrog.collector.SupportDataCollector",
     	   "collectSupportData",
           [$props, $path, $fileName]
        );
     }
     else
     {
        my $expl1 = "Run the command 'ras_admin device_list' and use an entry from either the 'Device' or";
	my $expl2 = "the 'IP' column for a 6130 if there is a question abount the validity of the chosen value.";

        $rval = "Could not find an array using $devKey.\n\n$expl1\n$expl2"; 
     }
  }
  else
  {
     $rval = "Missing required parameter";
  }

  return $rval;
}



# Given a device key (ex: SUN.348-0046776.0412071149)
# the properties are obtained from the rasagent.conf file.
sub getProperties 
{
  my($devKey) = @_;
  my $props;

  if ($devKey)
  {
    my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();

    foreach my $d (@$devs) 
    {
       if ($devKey eq $d->{key})
       {
          $props = $d;
          return $props;
       }

       elsif ($devKey eq $d->{name})
       {
          $props = $d;
          return $props;
       }

       elsif ($devKey eq $d->{ip})
       {
          $props = $d;
          return $props;
       }

       elsif ($devKey eq $d->{ipno})
       {
          $props = $d;
          return $props;
       }

       elsif ($devKey eq $d->{altip})
       {
          $props = $d;
          return $props;
       }

       elsif ($devKey eq $d->{altipno})
       {
          $props = $d;
          return $props;
       }


    }
  }


  return $props;
}


1;
