package Health::SP;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld21_029 $ 
#  $Id: SP.pm,v 1.6 2005/05/19 15:04:52 edunning Exp $

 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Report;
use strict;
use CIM::Instance;
use Message;
use Debug;
use TO;
use Health::Server;
  
use Health::Server;
use base 'Health::Server';

sub revision {'$Revision: 1.6 $'}
 

# runs every time
#
sub run_host {
  my($hm, $report) = @_;
  my($run, $orep, $x);
  my($renv)    = System->get_renv();
  my $Config   = PDM::ConfigFile->read();

  CIM->version("1.1");
  $DB::single = 1;

  my $rep     = $report->content();
  my $oreport = PDM->getOldReport($report->fileKey);
  my $orep    = $oreport->content()  if ($oreport);
  my $id      = $report->deviceName();

  if ($rep->get("drive.usb0_1.slot")) {
    Grid->setCode("sp.AlarmEvent.usb");
  $hm->mapValueChangeEvent($report, $orep, "SP", "drive.usb0_1", "slot", "the
Service Processor", "drive.usb0_1", $id, "usb0_1");

  }



  foreach my $C ('ntc=TerminalConcentrator','firewall=Firewall') {
     my($code, $name) = split(/\=/, $C);
     next if (!exists ($rep->{"info.$code.ping"}));
     my $IP = $rep->{"info.$code.ip"};
     my $STATUS = $rep->{"info.$code.ping"};

     my $key = $renv->{cust_no} || System->hostid();
     $hm->spCommLostEvent($report, $code, $IP, $STATUS, $name, $key);
  }

  $hm->free_space($report, $orep);
}




###############################################################

sub spCommLostEvent {
  my($hm, $report, $code, $IP, $STATUS, $name, $id) = @_;

  my($tran, $reps, $in_a_row_counter)= Transition->getTransition( {
                                          key => $IP,
                                         code => $code,
                                        value => $STATUS,
                             transition_value => "CannotPing",
                                       repeat => '24h'
                                        } );

  if ($tran =~ /IN/  || $tran =~ /OUT/ || $tran =~ /LOST/) {
        my ($et, $desc, $sev);
        if ($tran =~ /IN/ || $tran =~ /LOST/) {
          $et   = "sp.CommunicationLostEvent";
          Grid->setCode("sp.CommunicationLostEvent.$code");
          if($in_a_row_counter < 4){
            $sev  = Message::SEVERITY_NORMAL;
          }else{
            $sev  = Message::SEVERITY_DOWN;
          }
          $desc = "Lost Communication(oob) with $name / $IP";
        } else {
          $et   = "sp.CommunicationEstablishedEvent";
          Grid->setCode("sp.CommunicationEstablishedEvent.$code");
          $sev  = Message::SEVERITY_NORMAL;
          $desc = "Regained Communication(oob) with $name / $IP";
        }
        my $ev = CIM::Instance->new('NWS_CommunicationLostEvent', [
                  [ EventType       => $et  ],
                  [ EventId         => PDM->getEventSequence  ],
                  [ Severity        => $sev ],
                  [ Actionable      => ($sev > 0) ],
                  [ Component       => "sp.$code"],
                  [ Target          => $report->fileKey() ],
                  [ Caption         => $code ],
                  [ Description     => $desc ]
                   ]);
        my $sd = Events->sourceDetector({ event => $ev });

        my $key = CIM::Key->new( ['NWS_System',
                   'Name'       =>  $id,
              CreationClassName => 'NWS_System']);

        my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $key ],
                    ]);

        my $ed = Message->new( { id   => {},
                            instances => [$ev, @$sd, $pertains ], 
                            severity  => $sev });

        PDM->saveMessage($ed);
  }
}


1;
