package Discover::5210;
use Agent::5210;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "5210",
          sysDesc => 1,
          fromIP  => 0, 
          };
}



sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;

  if ($sysDesc =~ /5210/) {
     return $class->discoverFromIP($ip, $args);
  }
  return undef;
}



sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $rc = Agent::5210->getWWN($ipno);
  my $sn = $rc->{key};
  Debug->print1("Invalid or NULL Serial Number for $ipno") if (!$sn);
  return DiscoveryObject->error
     ($ipno, "Invalid or NULL Serial Number") if (!$sn);

  # For new MIB support
  my $osver = $rc->{revision};
  Debug->print1("No O/S version found for $ipno") if (!$osver);
  return DiscoveryObject->error($ipno, "No O/S version found") if (!$osver);
  if ($osver =~ /(\d+).(\d+).M(\d+).B(\d+)/ ) {
      my $major = $1;
      my $minor = $2;
      my $dot   = $3;
      my $incremental = $4;
      
      if (($major < 4) || ($minor < 3) || (($dot eq '0') && ($incremental < 16)) ) {
         Debug->print1("Unsupported firmware version, $rc->{revision}, for $ipno. Update to firmware 4.3.M0.B16 or above");
	 my $o = DiscoveryObject->error($ipno, 
              "Unsupported firmware version $rc->{revision}. Update to firmware 4.3.M0.B16 or above");
	 return [$o];

      }  
  }
  # End of new MIB support

  my $obj = DiscoveryObject->newFromString(
	    "storage.5210|5210|$ipno|$sn|$sn|$sn||$rc->{name}|$rc->{userLabel}");

  Discover->updateTopoDevice($obj, $sn);
  return [$obj];
  
}

1;

