package Discover::3310;
use Agent::3310;
use System;
use strict;
use DiscoveryObject;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "3310,3510,3511",
          sysDesc => 0,   # cannot use snmp sysDesc to identify
          no_snmp => 0,   # no snmp at all, don't even try this
                          # agent if  you got an unknown sysDesc string.
          fromIP  => 1,   # can call discoverFromIP directly
          inBand  => 1,   # inband || broadcast discovery (no ip)
     disco_level  => 2,   # need to run thick-client code
    merge_devices => 1, # merge proxy_ip
          };
}



sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $password = $args->{password};
  if (!$class->isValid($ipno)) {
      return undef;
  }
  my $rc = Agent::3310->getFastWWN($ipno);

  if ($rc->{error}) {
    my $o = DiscoveryObject->error($ipno, 
              "Could not retrieve information for $ipno $rc->{error}");
    return [$o];

  } elsif ($rc) {
    my $t = $rc->{type};


    my $o = DiscoveryObject->newFromString(
    "storage.$t|$t|$ipno|$rc->{wwn}|$rc->{key}|$rc->{wwn2}|||$t|");

    if($rc->{key} =~ /SUN.3310jbod\.(.*)/){
       $o->{wwns} = $1;
    }elsif($rc->{key} =~ /SUN.3120jbod\.(.*)/){
       $o->{wwns} = $1;
    }elsif($rc->{key} =~ /SUN.3310\.(.*)/){
       $o->{wwns} = $1;
    }elsif($rc->{key} =~ /SUN.3120\.(.*)/){
       $o->{wwns} = $1;
    }else{
       $o->{wwns} = $rc->{wwn2};
    }
    delete $o->{wwn2};
    my $discovered_okay = Discover->updateTopoDevice($o, {host_type => "oob"} );
    if(!$discovered_okay){
       my $o = DiscoveryObject->error($ipno, 
              "Could not retrieve Topology information for $ipno. Ensure password isn't set for this device or ensure correct password has been supplied under Device Passwords.");
       return [$o];
    }
    return [$o];
    
  }
  return undef;
}

sub isValid {
  my($class, $ip) = @_;

  my $sccli = "/opt/SUNWstade/bin/sccli";
  my($err,$com) = Util->run_command("$sccli $ip show inquiry 2>&1","luxadm.txt" , 30);
  return "@$com" =~ /StorEdge/;
}


#  was called get_discover
#  $q = { callback => &function }
#  callback is what saves the device discovered
#  what is returned is not used.  
#  RETURN: LIST OF DiscoveryObject(s)

sub discoverInBand {
  my($class, $q) = @_;

  my @LIST;
  my $renv = System->get_renv();
  my $TO   = $renv->{'timeout.sccli'} || 400;


  my $sccli = System->get_home() . "/bin/sccli";
  my $master = Util->findMaster();
  my $hname = $master ? $renv->{hostname} : "";

  if (-x $sccli) {
     my ($err, $L) = Util->run_command("$sccli --list", "sccli", $TO);
     foreach my $l (@$L) {
        Debug->print2("Discover::Inband: $l");
        if ($l =~ /\/dev\/([^ ]+) /) {
           my $path = "/dev/$1";
           my $rc = Agent::3310->getFastWWN($path);

           my $object;
           if (!$rc->{key}) {
              $object = DiscoveryObject->error($rc->{ip},
                              "Key not found for $path $rc->{error}");
           } else {
              my $type = $rc->{type};
              my $name = "$type-" . substr($rc->{wwn},-4);

              $object = DiscoveryObject->newFromString(
                 "storage.$type|$type|$rc->{ip}|$rc->{wwn}|$rc->{key}|".
                 "||$name|$rc->{userLabel}||$hname");

	      if($rc->{key} =~ /SUN.3310jbod\.(.*)/){
                 $object->{wwns} = $1;
              }elsif($rc->{key} =~ /SUN.3120jbod\.(.*)/){
                 $object->{wwns} = $1;
              }elsif($rc->{key} =~ /SUN.3310\.(.*)/){
                 $object->{wwns} = $1;
              }elsif($rc->{key} =~ /SUN.3120\.(.*)/){
                 $object->{wwns} = $1;
              }else{
                 $object->{wwns} = $rc->{wwn2};
              }
              $object->{path} = $path;
           }
           Discover->updateTopoDevice($object , {host_type => "ib"} );
           push(@LIST, $object);
        }
     }
  }
  return \@LIST;
}


1;
