package DeviceReport::SP;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';

# slightly different than HOST.pm
# does not add the enclosure as
# the enclosure data reported by the SP was different the one
# reported by the SE.
# added USB info


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;

  my $rep = $report->content();
  my $summary = $q->{summary};
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $name   = $report->id("name") ;
  my $ip     = Util->name2ip($name);
  my $hostid = $rep->{"location.hostId"};
  my $key0   = $report->id("deviceName") ;
  my $version = $rep->{"id.sp_version"};

  my $drive_usb_01_condition = $rep->{"drive.usb0_1.condition"};
  my $drive_usb_02_condition = $rep->{"drive.usb0_2.condition"};
  my $drive_usb_01_slot      = $rep->{"drive.usb0_1.slot"};
  my $drive_usb_02_slot      = $rep->{"drive.usb0_2.slot"};

  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $hostid },
                  device_name  => { order => 2 , value => $name },
                  device_ip    => { order => 3 , value => $ip   },
                  version      => { order => 4 , value => $version },
                  drive_usb_01_condition    => { order => 5 , value => $drive_usb_01_condition   },
                  drive_usb_02_condition    => { order => 6 , value => $drive_usb_02_condition   },
                  drive_usb_01_slot    => { order => 7 , value => $drive_usb_01_slot   },
                  drive_usb_02_slot    => { order => 8 , value => $drive_usb_02_slot   },
                 };
  $S{SAN} = $class->san_info($report);

  my $lun_cnt;
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1]";

       if (!$summary) {
          if (($L[0] eq "lun" || $L[0] eq "SES") && $L[2] eq "wwn") {
            $L[1] =~ s/_+/_/g;
            my $key = "$key0.$L[1]";
            $lun_cnt++;
            my $status = $rep->{"$x.status"} || $rep->{"$x.statusA"};
            $status .= " / " . $rep->{"$x.statusB"} if ($rep->{"$x.statusB"});
            my $type = $L[1];
            $status =~ s/HBA_PORTSTATE_//;
            $S{LOGICAL}{"$L[0].$L[1]"} = { 
                             name  => $rep->{"$x.product"} . " - " . $rep->{"$x.wwn"},
                               id  => "$L[0].$lun_cnt",
                           status  => $status,
                             type  => $type,
                          revision => "",
                            serial => $L[1],
                             model => "",
                          keyLabel => "WWN",
                          keyValue => $rep->{"$x.wwn"},
                           };

          } elsif (($L[0] eq "hba") && ($L[1] ne "count")) {
              $x = "$L[0].$L[1]";
              $S{FRU}{$x} = {  name  => $rep->{"$x.PortWWN"},
                                 id  =>  $x,
                              state  => $rep->{"$x.PortState"},
                            revision => $rep->{"$x.adapter_DriverVersion"} . "/" . 
                                        $rep->{"$x.adapter_FirmwareVersion"},
                             status  => "",
                               type  => $rep->{"$x.adapter_DriverName"},
                           keyLabel  => "DevicePath",
                           keyValue  => $rep->{"$x.path"},
                            };

          } elsif ($L[0] eq "switch" && $L[3] eq "InterNodeWWN") {
              $x = "$L[0].$L[1].Info";

              my $name =  $rep->{"$x.InterLogicalName"} || $rep->{"$x.InterNodeWWN"};
              my $serial = $rep->{"$x.VendorName"} . " - " . $rep->{"$x.ModelName"};

              $S{COMPONENT}{"$L[0].$L[1]"} = { 
	                         name  => $name,
                                 id  => "$L[0].$L[1]",
                              state  => "",
                            revision => $rep->{"$x.ReleaseCode"},
                              serial => $serial,
                             status  => "",
                               type  => $serial,
                            };

          } elsif ($L[0] eq "storage" && $L[2] eq "NodeWWN") {
              $x = "$L[0].$L[1]";
              my $serial = $rep->{"$x.Vendor"} . " - " . $rep->{"$x.ProductID"};
              my $state = $rep->{"$x.PortState"};
              $state =~ s/HBA_PORTSTATE_//;
              $S{COMPONENT}{$x} = {  name  => 
                $rep->{"$x.NodeWWN"} . " - " . ($rep->{"$x.OSDeviceName"}  || $rep->{"$x.PortWWN"}),
                                 id  =>  $x,
                              state  => $state,
                            revision => $rep->{"$x.Model"},
                              serial => $serial,
                             status  => "",
                               type  => $serial,
                            };

          } elsif ($L[0] eq "ports") {
              $x = "$L[0].$L[1]";
              my($front, $front2, $type) = split(/[\/\@]/, $L[1]);
              $S{FRU}{$x} = {  name  => $L[1],
                                 id  =>  $L[1],
                              state  => $rep->{$x},
                             status  => "",
                               type  => $type,
                           keyLabel  => "DevicePath",
                           keyValue  => $L[1],
                            };


          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };
        
          } elsif ($L[0] eq "freeSpace") {
              $x = "$L[0].$L[1]";
              my $val = $rep->{$el};
              if (index($x,"|") >= 0) {
                 $x =~ s/\|/ \(/;
                 $x .= ")";
              }
              $S{SYSTEM}{$x} = { value => $val };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       } else {
#print "DEFAULT: $el $summary \n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}



1;
