package DeviceReport::DSP;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';



# xml for GUI Interface

sub xmlSummary {
  my($class, $report, $q) = @_;
  my $summary = $q->{summary};
  my $rep = $report->content();
  my (%S);
  my $fru_list = ",MIC,SFC,SRC,";
  my $logical  = ",volume,slice,";
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";
  my $R = "cpuImageVersion.1.Revision";
  my $rev = $rep->{"MIC.Rear5.$R"} || $rep->{"MIC.Rear6.$R"} || $rep->{"SIO.Rear3.$R"} || 
            $rep->{"SIO.Rear4.$R"};
  my $revd = $rep->{'SIO.Rear3.cpuImageVersion.1.BuildDate'} || 
             $rep->{'SIO.Rear4.cpuImageVersion.1.BuildDate'};

  $S{HEADER} = {
      device_name     => {order => 1, value => $rep->{'system.Name'}    },
      fan_status      => {order => 2, value => $rep->{'fantray.FanState'} },

      power_A_state   => {order => 3, value => $rep->{'psu.1.PsuState'} },
      power_B_state   => {order => 4, value => $rep->{'psu.2.PsuState'} },

      revision        => {order => 5, value => $rev },
      revision_date   => {order => 6, value => $revd },

      number_of_volumes => {order => 7, value => $rep->{'totals.volume'}    },
      number_of_cards => {order => 8, value => $rep->{'totals.module'}    },
               };
  $S{SAN} = $class->san_info($report);

  my ($done);
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1]";
       $done .= ",$x,";

       if (!$summary) {
          if (index($fru_list, ",$L[0],") >= 0) {
            my $key = $rep->{"$x.PartNumber"} . "." . $rep->{"$x.SerialNumber"};
            $key = "" if ($key eq ".");
            $S{FRU}{$x} = {  name  => $x ,
                               id  => $x ,
                            state  => $rep->{"$x.State"},
                           status  => $rep->{"$x.Ready"},
                             type  => $rep->{"$x.Class"},
                          revision => $rep->{"$x.HWRev"} . "-" .  $rep->{"$x.PCBRev"},
                            serial => $rep->{"$x.SerialNumber"},
                             model => $rep->{"$x.PartNumber"},
                      availability => $rep->{"$x.availability"},
                            vendor => "SUN",
                          keyLabel => "serialno",
                          keyValue => $key,
                           };

          } elsif ($L[0] eq "SIO" ) {
            my $key = $rep->{"$x.PartNumber"} . "." . $rep->{"$x.SerialNumber"};
            $key = "" if ($key eq ".");
            # add the SIO subtype to be able to distinguish them
            my $displaySummary = "name,subtype,state,status,revision,serial";
            $S{FRU}{$x} = {  name  => $x ,
                               id  => $x ,
                            state  => $rep->{"$x.State"},
                           status  => $rep->{"$x.Ready"},
                             type  => $rep->{"$x.Class"},
                          revision => $rep->{"$x.HWRev"} . "-" .  $rep->{"$x.PCBRev"},
                            serial => $rep->{"$x.SerialNumber"},
                             model => $rep->{"$x.PartNumber"},
                      availability => $rep->{"$x.availability"},
                            vendor => "SUN",
                          keyLabel => "serialno",
                          keyValue => $key,
                          subtype  => $rep->{"$x.Type"},
                          summary  => $displaySummary,
                           };

          } elsif ($L[0] eq "fibrePort" || $L[0] eq "etherPort") {
              my $displaySummary = "name,state,status,serial";
              $S{PORT}{$x} = {  name  => $x,
                                 id  => $x,
                              state  => $rep->{"$x.PortState"},
                             status  => $rep->{"$x.HardwareState"},
                               type  => $rep->{"$x.PortType"},
                              serial => $rep->{"$x.PortWwn"} || 
                                        $rep->{"$x.MacAddr"},
                          summary    => $displaySummary,
                            };

          } elsif ($L[0] eq "psu") {
              $S{FRU}{$x} = {  name  => "Power Module ".$rep->{"$x.Label"},
                                 id  => $x,
                              state  => $rep->{"$x.PsuState"},
                             status  => "",
                            revision => "",
                            serial   => "",
                               type  => "power",
                           keyLabel  => "serialno",
                           keyValue  => $rep->{"id.wwn"} . ".$x",
                            };

          } elsif ($L[0] eq "fantray") {
              $S{FRU}{"fantray"} = {  name  => "FanTray",
                                 id  => "fantray",
                              state  => $rep->{"fantray.FanState"},
                             status  => "",
                            revision => "",
                            serial   => "",
                               type  => "fan",
                           keyLabel  => "serialno",
                           keyValue  => $rep->{"id.wwn"} . ".fantray",
                            };

          } elsif ($L[0] eq "system") {
              # skip the system parameters
              # as they do not contain real information

          } elsif ($L[0] eq "id") {
              $S{ID}{$x} = { value => $rep->{$el} };

          } elsif ($L[0] eq "volume")  {

              # find all the slices associated with this volume
              my $slices = "";
              $slices = $S{LOGICAL}{$x}->{slices};
              if ($L[4] eq "SliceName") {
                $slices = $slices.", ".$rep->{$el};
                if (substr($slices, 0, 2) eq ", ") {
                  $slices = substr($slices, 2, length($slices)-2);
                }
              }

              $S{LOGICAL}{$x} = { name => $rep->{"$x.ElementName"},
                                    id => $x,
                             condition => $rep->{"$x.Condition"},
                                 state => $rep->{"$x.State"},
                                status => "N/A",
                                  type => "volume",
                            volumeSize => $rep->{"$x.VolumeSize"},
                                slices => $slices,
                              summary  => "name,condition,state,volumeSize,slices"
                                };
          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




#    'SFC.Front5.Attention' => '0',
#    'SFC.Front5.CardNum' => '5',
#    'SFC.Front5.Class' => 'Switch Fabric Card',
#    'SFC.Front5.DateOfMfg' => '06-13-2003',
#    'SFC.Front5.HWRev' => 'AF',
#    'SFC.Front5.MACAddr' => '00:01:5D:00:3F:FF',
#    'SFC.Front5.MACCnt' => '0',
#    'SFC.Front5.NumCpus' => '1',
#    'SFC.Front5.NumPorts' => '0',
#    'SFC.Front5.PCBRev' => '04',
#    'SFC.Front5.Panel' => 'Front',
#    'SFC.Front5.PartNumber' => '720-00014-04',
#    'SFC.Front5.Power' => '1',
#    'SFC.Front5.Ready' => 'Ready',
#    'SFC.Front5.SerialNumber' => '500077',
#    'SFC.Front5.State' => 'Normal',
#    'SFC.Front5.TempF' => '111',
#    'SFC.Front5.Type' => 'SFC_1',



1;
