package Tests::3511;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base "Tests";
use Tests::General;
use PDM::ConfigFile;
use Agent::3310;
use Util;

#
#diag bypass sfp
#

sub diagBypassSfp3511_preForm {
  my($class, $command, $to, $node, $q) = @_;


  my ($err, $t);
  my $channels;
  my $ipaddr;

  my $config = PDM::ConfigFile->read();

  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  (my $readerr, my $rep1) = Report->readReport("3511:$key",$dev->{host});

  if ($rep1) {
      my $v = $rep1->value();
      my @list;
      foreach my $token (keys %$v) {
        if ( $token =~ /channel\.(\d+).mode/ ) {
             my $key = $1-1;
             push (@list, $key);
            #if ( $v->{$token} =~ /Drive/ ) {
            #    push (@list, $key);
            #}
        }
      }
      foreach my $ch (@list) {
          $channels .=$ch."|";
      }
  } else {
   $err ="Can not get the device report, please run rasagent first, if this is master-slave configuration, please make sure rasagent finished at least once on both master and slave ";
      return ($err, undef);

  }
  if ($dev->{path}) {
      $ipaddr = $dev->{path};  # in-band path
  } else {
      if ((!$dev->{ipno})) {
            $err .= "No IP Address or hostname defined for this device ($key)";
            $ipaddr = "*** NOT DEFINED ***";
      }else{
            $ipaddr = $dev->{ipno};
      }
  }

  chop $channels;

  my $looplist = Agent::3310->getLoops();

  my $row2;
  my $loop;
  my $x;

  for ($x=0; $x <= $#$looplist; $x++) {
         $row2 = $looplist->[$x];
         $loop .=$row2."|";
  }
  chop $loop;

  $loop .="|both"."|";

  my $port = "0|1|4|5|L|R";

  my $eid  = "0|1|2|3|4|5|6|7";

  my $pass = $class->getPassword($dev, \$err, 'minnow');

  my(%DATA) = ('#IPADDR' => $ipaddr ,
               '#USR'    => 'root',
               '#CHANNEL' => $channels,
               '#LOOPS'    =>$loop,
               '#PORT'    => $port,
               '#ENCLOSURE' => $eid,
               '#PASSWD' =>  $pass
              );

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);

}

sub diagBypassSfp3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_postForm($command, $to, $node, $q);
}


#
# bypass device 
#   

sub showBypassDevice3511_preForm {
  my($class, $command, $to, $node, $q) = @_;


  my ($err, $t);
  my $channels;
  my $ipaddr;

  my $config = PDM::ConfigFile->read();

  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  (my $readerr, my $rep1) = Report->readReport("3511:$key",$dev->{host});

  if ($rep1) {
      my $v = $rep1->value();
      my @list;
      foreach my $token (keys %$v) {
        if ( $token =~ /channel\.(\d+).mode/ ) {
             my $key = $1-1;
            if ( $v->{$token} =~ /Drive/ ) {
                push (@list, $key);
            }
        }
      }
      foreach my $ch (@list) {
          $channels .=$ch."|";
      }

  } else {
      $err ="Can not get the device report, please run rasagent first, if this is master-slave configuration, please make sure rasagent finished at least once on both master and slave ";
      return ($err, undef);

  }
  if ($dev->{path}) {
      $ipaddr = $dev->{path};  # in-band path
  } else {
      if ((!$dev->{ipno})) {
            $err .= "No IP Address or hostname defined for this device ($key)";
            $ipaddr = "*** NOT DEFINED ***";
      }else{
            $ipaddr = $dev->{ipno};
      }
  }

  chop $channels;

  my $looplist = Agent::3310->getLoops();

  my $row2;
  my $loop;
  my $x;

  for ($x=0; $x <= $#$looplist; $x++) {
         $row2 = $looplist->[$x];
         $loop .=$row2."|";
  }
  chop $loop;


  my $pass = $class->getPassword($dev, \$err, 'minnow');

  my(%DATA) = ('#IPADDR' => $ipaddr ,
               '#USR'    => 'root',
               '#CHANNEL' => $channels,
               '#LOOPS'    =>$loop,
               '#PASSWD' =>  $pass 
              );

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);

}

sub showBypassDevice3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_postForm($command, $to, $node, $q);
}

#
# show bypass SFP
#

sub showBypassSfp3511_preForm {
    my($class, $command, $to, $node, $q) = @_;
    return $class->showBypassDevice3511_preForm($command, $to, $node, $q);
}

sub showBypassSfp3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->showBypassDevice3511_postForm($command, $to, $node, $q);
}



sub loopmap3511_preForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_preForm($command, $to, $node, $q);
}

sub loopmap3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_postForm($command, $to, $node, $q);
}


sub echotest3511_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my ($err, $t);
  my $channels;
  my $ipaddr;
  my @list;
  my $count =0;

  my $config = PDM::ConfigFile->read();

  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }


  if ($dev->{path}) {
      $ipaddr = $dev->{path};  # in-band path
  } else {
      if ((!$dev->{ipno})) {
            $err .= "No IP Address or hostname defined for this device ($key)";
            $ipaddr = "*** NOT DEFINED ***";
      }else{
            $ipaddr = $dev->{ipno};
      }
  }
  
  (my $readerr, my $rep1) = Report->readReport("3511:$key",$dev->{host});

  if ($rep1) {
      my $v = $rep1->value();
      foreach my $token (keys %$v) {
          if ( $token =~ /channel\.(\d+).media_mode/) {

               my $ix  = rindex($token, ".");
               my $ele = substr($token, 0, $ix);
               my $speed = $ele."curclk";
               next if ($v->{$speed} =~ /ASYNC/i);
               my $key = $1-1;
               if ($v->{$token} =~ /fabric/ ){
                     push (@list, $key);
                     $count++;
               }
          }
      }
      if ($count>0) {
         foreach my $ch (@list) {
              $channels .=$ch."|";
         }
      } else {
          $err = "No channel is in fabric mode, can not run echotest, please check system set-up";
          return ($err, undef);
      }

  } else {
      $err ="Can not get the device report, please run rasagent first, if this is master-slave configuration, please make sure rasagent finished at least once on both master and slave ";
      return ($err, undef);

  }
 
  chop $channels;

  my $pass = $class->getPassword($dev, \$err, $dev->{type});

  my(%DATA) = ('#IPADDR' => $ipaddr ,
               '#USR'    => 'root',
               '#CHANNEL' => $channels,
               '#PASSWD' =>  $pass
              );


  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);
 

}

sub echotest3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_postForm($command, $to, $node, $q);
} 

sub wrbtest3511_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my ($err, $t);
  my $channels;
  my $ipaddr;

  my $config = PDM::ConfigFile->read();
  
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);
  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  if ($dev->{path}) {
      $ipaddr = $dev->{path};  # in-band path
  } else {
      if ((!$dev->{ipno})) {
            $err .= "No IP Address or hostname defined for this device ($key)";
            $ipaddr = "*** NOT DEFINED ***";
      }else{
            $ipaddr = $dev->{ipno};
      }
  }

  (my $readerr, my $rep1) = Report->readReport("3511:$key",$dev->{host});
  my $targets;
  if ($rep1) {
      my $v = $rep1->value();
      # $ipaddr = $v->{'id.ipno'};  # this ip is for host ip 
      my $value;
      my @tlist;
      my @list;
      foreach my $token (keys %$v) {
        if ( $token =~ /components\.disk\.(\d+).target/ ) {
           $value = $v->{$token};
           push (@tlist,$value);
        }
       
        if ( $token =~ /channel\.(\d+).mode/ ) {
             my $key = $1-1;
            if ( $v->{$token} =~ /Drive/ ) {
                push (@list, $key);
            }
        }
      }
      
      foreach my $target (@tlist) {
         $targets .=$target."|";
      }

     foreach my $ch (@list) {
          $channels .=$ch."|";
     }
     
  } else {
     $err ="Can not get the device report, please run rasagent first, if this is master-slave configuration, please make sure rasagent finished at least once on both master and slave "; 
    return ($err, undef);
  }
  
  chop $targets;
  chop $channels;

  my $pass = $class->getPassword($dev, \$err, $dev->{type});

  my(%DATA) = ('#IPADDR' => $ipaddr , 
               '#USR'    => 'root',
	       '#CHANNEL' => $channels,
               '#TARGET'  => $targets,
               '#PASSWD' =>  $pass
              );


  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);

}

sub wrbtest3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  my $dev = $config->deviceByKey($key);
  my $target;

  if ($dev->{ipno}) {
      $target = $dev->{ipno};  # OOB path
  } elsif( $dev->{path}) {
      $target = $dev->{path} ; # IB path
  }

  if (!$target) {
     return "Cannot find ($key) in Config. ";
  } 

  if (($t = $class->testRunning("*", $key))) {
     return "A test on $target already exists";
  }

  if ($q->{opt_dev} =~ /#IPADDR/ || !$q->{opt_dev}) {
     $err .= "Unable to obtain IP address. ";
  }

  if ($q->{opt_passwd} eq "#PASSWD") {
     $err .= "Must enter a valid password to run this test.";
  }
  return $err;
}


#
# looptest
#

sub looptest3511_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my ($err, $t);
  my $channels;
  my $ipaddr;
  my @list;
  my $count =0;
  my $fabric_count =0 ;
  my $config = PDM::ConfigFile->read();

  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  (my $readerr, my $rep1) = Report->readReport("3511:$key",$dev->{host});

  if ($rep1) {
      my $v = $rep1->value();
    # $ipaddr = $v->{'id.ipno'};
      foreach my $token (keys %$v) {
          if ( $token =~ /channel\.(\d+).media_mode/) {
               my $key = $1-1;
               if ( $v->{$token} =~ /loop/ ) {
                     push (@list, $key);
                     $count++;
               }
               if ( $v->{$token} =~ /fabric/ ) {
                     $fabric_count++;
               }
          }
      } 
      if ($count>0) {
         foreach my $ch (@list) {
              $channels .=$ch."|";
         }
      } else {
          $err = "No channel is in loop mode, can not run looptest, please check system set-up";
          return ($err, undef);
      }
     
  } else {
      $err ="Can not get the device report, please run rasagent first, if this is master-slave configuration, please make sure rasagent finished at least once on both master and slave ";
      return ($err, undef);

  } 

  chop $channels;
  my $mode;
  if ($fabric_count >0) {
        $mode ="10bit|1bit";
  } else {
        $mode ="10bit|1bit|external";
  }

  if ($dev->{path}) {
      $ipaddr = $dev->{path};  # in-band path
  } else {
      if ((!$dev->{ipno})) {
            $err .= "No IP Address or hostname defined for this device ($key)";
            $ipaddr = "*** NOT DEFINED ***";
      }else{
            $ipaddr = $dev->{ipno};
      }
  }

  my $pass = $class->getPassword($dev, \$err, $dev->{type});

  my(%DATA) = ('#IPADDR' => $ipaddr ,
               '#USR'    => 'root',
               '#CHANNEL' => $channels,
               '#MODE'    => $mode,
               '#PASSWD' =>  $pass
              );


  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);

}

sub looptest3511_postForm {
  my($class, $command, $to, $node, $q) = @_;
  return $class->wrbtest3511_postForm($command, $to, $node, $q);

}



1;
