package TO::TAPE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::STORAGE';
use strict;
use State;

sub leaf { 1 }

sub isKnownDevice {
  my($class, $dev) = @_;
  if ($dev->{ProductID} =~ /T9840B/ ) {
     return 1;
  }
  return 0;
}


sub getPortId {
  my($class, $port) = @_;    # 0 / 1

  if ($port == 0) {
     return 'port.A';
  } else {
     return 'port.B';
  }
}

sub newFromDev {
  my($class, $to, $dev, $arg) = @_;

  my $renv = System->get_renv();
  my $host = $renv->{hostname};

  my $k = $dev->{type} . ":" . $dev->{key};
  my $exists = $to->nodeByName($k) || $to->nodeBySynonym($dev);

  my $storages  =  $to->[2];
  my $key       = $dev->{key};
  my $type      = $dev->{type};

  my $obj = $exists || {};
  my $org_name          = $obj->{info}{name};
  $obj->{info}{type}    = $type;
  $obj->{info}{class}   = "storage.$type";
  $obj->{info}{name}    = "$type:$key";
  $obj->{info}{NodeWWN} = $dev->{key};
  $obj->{info}{PortWWN} = $dev->{wwn};
  $obj->{info}{BoxName} = $dev->{name};

  if ($dev->{wwn}) {
     $obj->{portInfo}[0]{PortWWN}      =  $dev->{wwn};
     $obj->{portInfo}[0]{LocalPortWWN} =  $dev->{wwn};
  }
  $obj->{portInfo}[0]{PortLabel}    =  'A';


  $obj->{portInfo}[0]{dataHost} = $host;

  bless($obj, 'TO::'. uc($dev->{type}));

  $storages->{"$dev->{type}:$key"} = $obj;
  return $obj;

}


sub statusFunc {
  my($class, $name, $State) = @_;
  my($type);
  my $Comp = $State->components($name);
  my $i    = $Comp->value("ib");
  my $enc  = $i->[0];
  my $encInfo = $i->[1];

  my($port, $portInfo, $other, $otherInfo);
  my($disk, $diskInfo);

  ($type, $name) = split(/:/, $name);
  $name = "tape:$name";

  my($p1)   = $Comp->value("port.A");
  $port     = $p1->[0];
  $portInfo =  $p1->[1];

  return ($enc, $port, $disk, $other, $encInfo, $portInfo, $diskInfo, $otherInfo);
}


sub iconLayout {
  my($class) = @_;

  return("a,tape,1/A,0,f,,,D0F0D0/tape.gif", "TAPE", 1);
}


1;


